/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R6.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R6.inventory.util.CraftMenus;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.model.PlayerModelPart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, czl entity) {
        super(server, entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.gB());
        this.enderChest = new CraftInventory(entity.gP());
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public MainHand getMainHand() {
        return this.getHandle().as() == cem.a ? MainHand.LEFT : MainHand.RIGHT;
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null");
        czn nms = czn.valueOf(part.name());
        return this.getHandle().a(nms);
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().cl.g());
    }

    public void setItemOnCursor(ItemStack item) {
        dhp stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().cl.a(stack);
        if (this instanceof CraftPlayer) {
            this.getHandle().cl.broadcastCarriedItem();
        }
    }

    public int getSleepTicks() {
        return this.getHandle().cF;
    }

    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        ja blockposition = CraftLocation.toBlockPosition(location);
        ejm iblockdata = this.getHandle().an().a_(blockposition);
        if (!(iblockdata.b() instanceof duo)) {
            return false;
        }
        if (this.getHandle().startSleepInBed(blockposition, force).left().isPresent()) {
            return false;
        }
        iblockdata = (ejm)iblockdata.b(duo.c, true);
        this.getHandle().an().a(blockposition, iblockdata, 4);
        return true;
    }

    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().a(true, setSpawnLocation);
    }

    public void startRiptideAttack(int duration, float damage, ItemStack attackItem) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        Preconditions.checkArgument((damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must not be negative");
        this.getHandle().a(duration, damage, CraftItemStack.asNMSCopy(attackItem));
    }

    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        ja bed2 = this.getHandle().ge().get();
        return CraftLocation.toBukkit(bed2, this.getWorld());
    }

    @Override
    public String getName() {
        return this.getHandle().cV();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        this.mode = mode;
    }

    @Override
    public czl getHandle() {
        return (czl)this.entity;
    }

    public void setHandle(czl entity) {
        super.setHandle(entity);
        this.inventory = new CraftInventoryPlayer(entity.gB());
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + "}";
    }

    public InventoryView getOpenInventory() {
        return this.getHandle().cl.getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        InventoryHolder inventoryHolder;
        egg te2;
        CraftInventory craft;
        if (!(this.getHandle() instanceof awy)) {
            return null;
        }
        awy player = (awy)this.getHandle();
        ddg formerContainer = this.getHandle().cl;
        cbt tileInventory = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            tileInventory = ((CraftInventoryDoubleChest)inventory).tile;
        } else if (inventory instanceof CraftInventoryLectern) {
            tileInventory = ((CraftInventoryLectern)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof cbt) {
            tileInventory = (cbt)((Object)craft.getInventory());
        }
        if (tileInventory instanceof cbt && tileInventory instanceof egg && !(te2 = (egg)((Object)tileInventory)).n()) {
            te2.a(this.getHandle().an());
        }
        if (tileInventory instanceof cbt) {
            this.getHandle().a(tileInventory);
        } else if (inventory instanceof CraftInventoryAbstractHorse && (inventoryHolder = (craft = (CraftInventoryAbstractHorse)inventory).getInventory().getOwner()) instanceof CraftAbstractHorse) {
            CraftAbstractHorse horse = (CraftAbstractHorse)inventoryHolder;
            this.getHandle().a(horse.getHandle(), craft.getInventory());
        } else {
            dep container = CraftContainer.getNotchInventoryType(inventory);
            CraftHumanEntity.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().cl == formerContainer) {
            return null;
        }
        this.getHandle().cl.checkReachable = false;
        return this.getHandle().cl.getBukkitView();
    }

    private static void openCustomInventory(Inventory inventory, awy player, dep<?> windowType) {
        if (player.g == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        ddg container = new CraftContainer(inventory, (czl)player, player.nextContainerCounter());
        container = CraftEventFactory.callInventoryOpenEvent(player, container);
        if (container == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        player.g.b(new aeu(container.l, windowType, CraftChatMessage.fromString(title)[0]));
        player.cl = container;
        player.a(container);
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().a(dux.cX.m().a(this.getHandle().an(), CraftLocation.toBlockPosition(location)));
        if (force) {
            this.getHandle().cl.checkReachable = false;
        }
        return this.getHandle().cl.getBukkitView();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        ja pos = CraftLocation.toBlockPosition(location);
        this.getHandle().a(dux.gg.m().a(this.getHandle().an(), pos));
        if (force) {
            this.getHandle().cl.checkReachable = false;
        }
        return this.getHandle().cl.getBukkitView();
    }

    public void openInventory(InventoryView inventory) {
        Preconditions.checkArgument((boolean)this.equals(inventory.getPlayer()), (Object)"InventoryView must belong to the opening player");
        if (!(this.getHandle() instanceof awy)) {
            return;
        }
        if (((awy)this.getHandle()).g == null) {
            return;
        }
        if (this.getHandle().cl != this.getHandle().ck) {
            ((awy)this.getHandle()).g.a(new aij(this.getHandle().cl.l));
        }
        awy player = (awy)this.getHandle();
        ddg container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        dep windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        if (windowType == dep.t) {
            CraftMenus.openMerchantMenu(player, (der)container);
            return;
        }
        String title = inventory.getTitle();
        player.g.b(new aeu(container.l, windowType, CraftChatMessage.fromString(title)[0]));
        player.cl = container;
        player.a(container);
    }

    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    public InventoryView openMerchant(Merchant merchant, boolean force) {
        xx name;
        dql mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().S_();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().gR().c();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.g(this.getHandle());
        mcMerchant.a(this.getHandle(), name, level);
        return this.getHandle().cl.getBukkitView();
    }

    public void closeInventory() {
        this.getHandle().r();
    }

    public boolean isBlocking() {
        return this.getHandle().fV();
    }

    public boolean isHandRaised() {
        return this.getHandle().fO();
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    public int getEnchantmentSeed() {
        return this.getHandle().cu;
    }

    public void setEnchantmentSeed(int i2) {
        this.getHandle().cu = i2;
    }

    public int getExpToLevel() {
        return this.getHandle().gL();
    }

    public float getAttackCooldown() {
        return this.getHandle().G(0.5f);
    }

    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.hasCooldown(new ItemStack(material));
    }

    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.getCooldown(new ItemStack(material));
    }

    public void setCooldown(Material material, int ticks) {
        this.setCooldown(new ItemStack(material), ticks);
    }

    public boolean hasCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.getHandle().gW().a(CraftItemStack.asNMSCopy(item));
    }

    public int getCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        amj group = this.getHandle().gW().b(CraftItemStack.asNMSCopy(item));
        if (group == null) {
            return 0;
        }
        dhm.a cooldown = this.getHandle().gW().a.get(group);
        return cooldown == null ? 0 : Math.max(0, cooldown.b() - this.getHandle().gW().b);
    }

    public void setCooldown(ItemStack item, int ticks) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().gW().a(CraftItemStack.asNMSCopy(item), ticks);
    }

    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().a(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().b(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<dmn<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        dmp manager = this.getHandle().an().q().aN();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional<dmn<?>> recipe = manager.b(CraftRecipe.toMinecraft(recipeKey));
            if (!recipe.isPresent()) continue;
            recipes.add(recipe.get());
        }
        return recipes;
    }

    public Entity getShoulderEntityLeft() {
        czl czl2 = this.getHandle();
        if (!(czl2 instanceof awy)) {
            return null;
        }
        awy handle = (awy)czl2;
        if (!handle.ak().j()) {
            cdv shoulder = handle.getEntityOnShoulder(handle.ak());
            return shoulder == null ? null : shoulder.getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityLeft(Entity entity) {
        czl czl2 = this.getHandle();
        if (!(czl2 instanceof awy)) {
            return;
        }
        awy handle = (awy)czl2;
        handle.b(entity == null ? new up() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public Entity getShoulderEntityRight() {
        czl czl2 = this.getHandle();
        if (!(czl2 instanceof awy)) {
            return null;
        }
        awy handle = (awy)czl2;
        if (!handle.al().j()) {
            cdv shoulder = handle.getEntityOnShoulder(handle.al());
            return shoulder == null ? null : shoulder.getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityRight(Entity entity) {
        czl czl2 = this.getHandle();
        if (!(czl2 instanceof awy)) {
            return;
        }
        awy handle = (awy)czl2;
        handle.c(entity == null ? new up() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public boolean dropItem(boolean dropAll) {
        if (!(this.getHandle() instanceof awy)) {
            return false;
        }
        return ((awy)this.getHandle()).a(dropAll);
    }

    public float getExhaustion() {
        return this.getHandle().gM().e;
    }

    public void setExhaustion(float value) {
        this.getHandle().gM().e = value;
    }

    public float getSaturation() {
        return this.getHandle().gM().d;
    }

    public void setSaturation(float value) {
        this.getHandle().gM().d = value;
    }

    public int getFoodLevel() {
        return this.getHandle().gM().c;
    }

    public void setFoodLevel(int value) {
        this.getHandle().gM().c = value;
    }

    public int getSaturatedRegenRate() {
        return this.getHandle().gM().saturatedRegenRate;
    }

    public void setSaturatedRegenRate(int i2) {
        this.getHandle().gM().saturatedRegenRate = i2;
    }

    public int getUnsaturatedRegenRate() {
        return this.getHandle().gM().unsaturatedRegenRate;
    }

    public void setUnsaturatedRegenRate(int i2) {
        this.getHandle().gM().unsaturatedRegenRate = i2;
    }

    public int getStarvationRate() {
        return this.getHandle().gM().starvationRate;
    }

    public void setStarvationRate(int i2) {
        this.getHandle().gM().starvationRate = i2;
    }

    public Location getLastDeathLocation() {
        return this.getHandle().gZ().map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public void setLastDeathLocation(Location location) {
        if (location == null) {
            this.getHandle().d(Optional.empty());
        } else {
            this.getHandle().d(Optional.of(CraftMemoryMapper.toNms(location)));
        }
    }

    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        dad fireworks = new dad(this.getHandle().an(), CraftItemStack.asNMSCopy(fireworkItemStack), this.getHandle());
        boolean success = this.getHandle().an().addFreshEntity(fireworks, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return success ? (Firework)fireworks.getBukkitEntity() : null;
    }

    @Override
    public Entity copy() {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }

    @Override
    public Entity copy(Location location) {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }
}

