/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class CraftMerchantRecipe
extends MerchantRecipe {
    private final dqm handle;

    public CraftMerchantRecipe(dqm merchantRecipe) {
        super(CraftItemStack.asBukkitCopy(merchantRecipe.e), 0);
        this.handle = merchantRecipe;
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.c.d()));
        merchantRecipe.d.ifPresent(costB -> this.addIngredient(CraftItemStack.asBukkitCopy(costB.d())));
    }

    @Deprecated
    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier) {
        this(result, uses, maxUses, experienceReward, experience, priceMultiplier, 0, 0);
    }

    public CraftMerchantRecipe(ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier, int demand, int specialPrice) {
        super(result, uses, maxUses, experienceReward, experience, priceMultiplier, demand, specialPrice);
        this.handle = new dqm(new dqk(dht.a), Optional.empty(), CraftItemStack.asNMSCopy(result), uses, maxUses, experience, priceMultiplier, demand, this);
        this.setSpecialPrice(specialPrice);
        this.setExperienceReward(experienceReward);
    }

    public int getSpecialPrice() {
        return this.handle.o();
    }

    public void setSpecialPrice(int specialPrice) {
        this.handle.i = specialPrice;
    }

    public int getDemand() {
        return this.handle.j;
    }

    public void setDemand(int demand) {
        this.handle.j = demand;
    }

    public int getUses() {
        return this.handle.f;
    }

    public void setUses(int uses) {
        this.handle.f = uses;
    }

    public int getMaxUses() {
        return this.handle.g;
    }

    public void setMaxUses(int maxUses) {
        this.handle.g = maxUses;
    }

    public boolean hasExperienceReward() {
        return this.handle.h;
    }

    public void setExperienceReward(boolean flag) {
        this.handle.h = flag;
    }

    public int getVillagerExperience() {
        return this.handle.l;
    }

    public void setVillagerExperience(int villagerExperience) {
        this.handle.l = villagerExperience;
    }

    public float getPriceMultiplier() {
        return this.handle.k;
    }

    public void setPriceMultiplier(float priceMultiplier) {
        this.handle.k = priceMultiplier;
    }

    public dqm toMinecraft() {
        List ingredients = this.getIngredients();
        Preconditions.checkState((!ingredients.isEmpty() ? 1 : 0) != 0, (Object)"No offered ingredients");
        dhp baseCostA = CraftItemStack.asNMSCopy((ItemStack)ingredients.get(0));
        kj baseCostAPredicate = kj.a(kq.a(km.a, baseCostA.d()));
        this.handle.c = new dqk(baseCostA.i(), baseCostA.M(), baseCostAPredicate, baseCostA);
        if (ingredients.size() > 1) {
            dhp costB = CraftItemStack.asNMSCopy((ItemStack)ingredients.get(1));
            kj costBPredicate = kj.a(kq.a(km.a, costB.d()));
            this.handle.d = Optional.of(new dqk(costB.i(), costB.M(), costBPredicate, costB));
        } else {
            this.handle.d = Optional.empty();
        }
        return this.handle;
    }

    public static CraftMerchantRecipe fromBukkit(MerchantRecipe recipe) {
        if (recipe instanceof CraftMerchantRecipe) {
            return (CraftMerchantRecipe)recipe;
        }
        CraftMerchantRecipe craft = new CraftMerchantRecipe(recipe.getResult(), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward(), recipe.getVillagerExperience(), recipe.getPriceMultiplier(), recipe.getDemand(), recipe.getSpecialPrice());
        craft.setIngredients(recipe.getIngredients());
        return craft;
    }
}

