/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;
import org.bukkit.inventory.recipe.CraftingBookCategory;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public Optional<dme> toNMSOptional(RecipeChoice bukkit, boolean requireNotEmpty) {
        return bukkit == null ? Optional.empty() : Optional.of(this.toNMS(bukkit, requireNotEmpty));
    }

    default public dme toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        dme stack;
        if (bukkit == null) {
            stack = dme.a(new drp[0]);
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = dme.a(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> CraftItemType.bukkitToMinecraft(mat)));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = dme.ofStacks(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> CraftItemStack.asNMSCopy(mat)).toList());
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + String.valueOf(bukkit));
        }
        if (requireNotEmpty) {
            Preconditions.checkArgument((!stack.b() ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    default public dnl toNMS(ItemStack stack) {
        dhp nms = CraftItemStack.asNMSCopy(stack);
        return new dnl(nms.i(), nms.M(), nms.d());
    }

    public static RecipeChoice toBukkit(Optional<dme> list) {
        return list.map(CraftRecipe::toBukkit).orElse(null);
    }

    public static RecipeChoice toBukkit(dme list) {
        if (list.b()) {
            return null;
        }
        if (list.isExact()) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.itemStacks().size());
            for (dhp i3 : list.itemStacks()) {
                choices.add(CraftItemStack.asBukkitCopy(i3));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        List<Material> choices = list.a().map(i2 -> CraftItemType.minecraftToBukkit((dhl)i2.a())).toList();
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static ItemStack toBukkit(dnl transmute) {
        dhp nms = new dhp(transmute.b(), transmute.c(), transmute.d());
        return CraftItemStack.asBukkitCopy(nms);
    }

    public static dlv getCategory(CraftingBookCategory bukkit) {
        return dlv.valueOf(bukkit.name());
    }

    public static CraftingBookCategory getCategory(dlv nms) {
        return CraftingBookCategory.valueOf((String)nms.name());
    }

    public static dlu getCategory(CookingBookCategory bukkit) {
        return dlu.valueOf(bukkit.name());
    }

    public static CookingBookCategory getCategory(dlu nms) {
        return CookingBookCategory.valueOf((String)nms.name());
    }

    public static ami<dmi<?>> toMinecraft(NamespacedKey key) {
        return ami.a(mp.bD, CraftNamespacedKey.toMinecraft(key));
    }
}

