/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.scoreboard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.RenderType;

public final class CraftCriteria
implements Criteria {
    static final Map<String, CraftCriteria> DEFAULTS;
    static final CraftCriteria DUMMY;
    final fpq criteria;
    final String bukkitName;

    private CraftCriteria(String bukkitName) {
        this.bukkitName = bukkitName;
        this.criteria = CraftCriteria.DUMMY.criteria;
    }

    private CraftCriteria(fpq criteria) {
        this.criteria = criteria;
        this.bukkitName = criteria.d();
    }

    public String getName() {
        return this.bukkitName;
    }

    public boolean isReadOnly() {
        return this.criteria.e();
    }

    public RenderType getDefaultRenderType() {
        return RenderType.values()[this.criteria.f().ordinal()];
    }

    static CraftCriteria getFromNMS(fpf objective) {
        return DEFAULTS.get(objective.d().d());
    }

    public static CraftCriteria getFromBukkit(String name) {
        CraftCriteria criteria = DEFAULTS.get(name);
        if (criteria != null) {
            return criteria;
        }
        return fpq.a(name).map(CraftCriteria::new).orElseGet(() -> new CraftCriteria(name));
    }

    public boolean equals(Object that) {
        if (!(that instanceof CraftCriteria)) {
            return false;
        }
        return ((CraftCriteria)that).bukkitName.equals(this.bukkitName);
    }

    public int hashCode() {
        return this.bukkitName.hashCode() ^ CraftCriteria.class.hashCode();
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (Map.Entry<String, fpq> entry : fpq.p.entrySet()) {
            String name = entry.getKey();
            fpq criteria = entry.getValue();
            defaults.put((Object)name, (Object)new CraftCriteria(criteria));
        }
        DEFAULTS = defaults.build();
        DUMMY = DEFAULTS.get("dummy");
    }
}

