/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.PermissionSource;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.command.VanillaCommandWrapper;
import org.spigotmc.SpigotConfig;

public class CommandListenerWrapper
implements ExecutionCommandSource<CommandListenerWrapper>,
PermissionSource,
ICompletionProvider {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("permissions.requires.player"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("permissions.requires.entity"));
    public final ICommandListener d;
    private final Vec3D e;
    private final WorldServer f;
    private final int g;
    private final String h;
    private final IChatBaseComponent i;
    private final MinecraftServer j;
    private final boolean k;
    @Nullable
    private final Entity l;
    private final CommandResultCallback m;
    private final ArgumentAnchor.Anchor n;
    private final Vec2F o;
    private final CommandSigningContext p;
    private final TaskChainer q;
    public volatile CommandNode currentCommand;

    public CommandListenerWrapper(ICommandListener icommandlistener, Vec3D vec3d, Vec2F vec2f, WorldServer worldserver, int i2, String s2, IChatBaseComponent ichatbasecomponent, MinecraftServer minecraftserver, @Nullable Entity entity) {
        this(icommandlistener, vec3d, vec2f, worldserver, i2, s2, ichatbasecomponent, minecraftserver, entity, false, CommandResultCallback.a, ArgumentAnchor.Anchor.a, CommandSigningContext.a, TaskChainer.immediate(minecraftserver));
    }

    protected CommandListenerWrapper(ICommandListener icommandlistener, Vec3D vec3d, Vec2F vec2f, WorldServer worldserver, int i2, String s2, IChatBaseComponent ichatbasecomponent, MinecraftServer minecraftserver, @Nullable Entity entity, boolean flag, CommandResultCallback commandresultcallback, ArgumentAnchor.Anchor argumentanchor_anchor, CommandSigningContext commandsigningcontext, TaskChainer taskchainer) {
        this.d = icommandlistener;
        this.e = vec3d;
        this.f = worldserver;
        this.k = flag;
        this.l = entity;
        this.g = i2;
        this.h = s2;
        this.i = ichatbasecomponent;
        this.j = minecraftserver;
        this.m = commandresultcallback;
        this.n = argumentanchor_anchor;
        this.o = vec2f;
        this.p = commandsigningcontext;
        this.q = taskchainer;
    }

    public CommandListenerWrapper a(ICommandListener icommandlistener) {
        return this.d == icommandlistener ? this : new CommandListenerWrapper(icommandlistener, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Entity entity) {
        return this.l == entity ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, entity.ap(), entity.S_(), this.j, entity, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Vec3D vec3d) {
        return this.e.equals(vec3d) ? this : new CommandListenerWrapper(this.d, vec3d, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Vec2F vec2f) {
        return this.o.c(vec2f) ? this : new CommandListenerWrapper(this.d, this.e, vec2f, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(CommandResultCallback commandresultcallback) {
        return Objects.equals(this.m, commandresultcallback) ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, commandresultcallback, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(CommandResultCallback commandresultcallback, BinaryOperator<CommandResultCallback> binaryoperator) {
        CommandResultCallback commandresultcallback1 = (CommandResultCallback)binaryoperator.apply(this.m, commandresultcallback);
        return this.a(commandresultcallback1);
    }

    public CommandListenerWrapper a() {
        return !this.k && !this.d.q_() ? new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, true, this.m, this.n, this.p, this.q) : this;
    }

    public CommandListenerWrapper a(int i2) {
        return i2 == this.g ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, i2, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper b(int i2) {
        return i2 <= this.g ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, i2, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(ArgumentAnchor.Anchor argumentanchor_anchor) {
        return argumentanchor_anchor == this.n ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, argumentanchor_anchor, this.p, this.q);
    }

    public CommandListenerWrapper a(WorldServer worldserver) {
        if (worldserver == this.f) {
            return this;
        }
        double d0 = DimensionManager.a(this.f.H_(), worldserver.H_());
        Vec3D vec3d = new Vec3D(this.e.g * d0, this.e.h, this.e.i * d0);
        return new CommandListenerWrapper(this.d, vec3d, this.o, worldserver, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Entity entity, ArgumentAnchor.Anchor argumentanchor_anchor) {
        return this.b(argumentanchor_anchor.a(entity));
    }

    public CommandListenerWrapper b(Vec3D vec3d) {
        Vec3D vec3d1 = this.n.a(this);
        double d0 = vec3d.g - vec3d1.g;
        double d1 = vec3d.h - vec3d1.h;
        double d2 = vec3d.i - vec3d1.i;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f2 = MathHelper.h((float)(-(MathHelper.d(d1, d3) * 57.2957763671875)));
        float f1 = MathHelper.h((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f);
        return this.a(new Vec2F(f2, f1));
    }

    public CommandListenerWrapper a(CommandSigningContext commandsigningcontext, TaskChainer taskchainer) {
        return commandsigningcontext == this.p && taskchainer == this.q ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, commandsigningcontext, taskchainer);
    }

    public IChatBaseComponent b() {
        return this.i;
    }

    public String c() {
        return this.h;
    }

    @Override
    public boolean c(int i2) {
        CommandNode currentCommand = this.currentCommand;
        if (currentCommand != null) {
            return this.hasPermission(i2, VanillaCommandWrapper.getPermission(currentCommand));
        }
        return this.g >= i2;
    }

    public boolean hasPermission(int i2, String bukkitPermission) {
        return (this.e() == null || !this.e().getCraftServer().ignoreVanillaPermissions) && this.g >= i2 || this.getBukkitSender().hasPermission(bukkitPermission);
    }

    public Vec3D d() {
        return this.e;
    }

    public WorldServer e() {
        return this.f;
    }

    @Nullable
    public Entity f() {
        return this.l;
    }

    public Entity g() throws CommandSyntaxException {
        if (this.l == null) {
            throw b.create();
        }
        return this.l;
    }

    public EntityPlayer h() throws CommandSyntaxException {
        Entity entity = this.l;
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            return entityplayer;
        }
        throw a.create();
    }

    @Nullable
    public EntityPlayer i() {
        EntityPlayer entityplayer1;
        Entity entity = this.l;
        EntityPlayer entityplayer = entity instanceof EntityPlayer ? (entityplayer1 = (EntityPlayer)entity) : null;
        return entityplayer;
    }

    public boolean j() {
        return this.l instanceof EntityPlayer;
    }

    public Vec2F k() {
        return this.o;
    }

    public MinecraftServer l() {
        return this.j;
    }

    public ArgumentAnchor.Anchor m() {
        return this.n;
    }

    public CommandSigningContext n() {
        return this.p;
    }

    public TaskChainer o() {
        return this.q;
    }

    public boolean a(EntityPlayer entityplayer) {
        EntityPlayer entityplayer1 = this.i();
        return entityplayer == entityplayer1 ? false : entityplayer1 != null && entityplayer1.Z() || entityplayer.Z();
    }

    public void a(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatMessageType.a chatmessagetype_a) {
        if (!this.k) {
            EntityPlayer entityplayer = this.i();
            if (entityplayer != null) {
                entityplayer.a(outgoingchatmessage, flag, chatmessagetype_a);
            } else {
                this.d.a(chatmessagetype_a.a(outgoingchatmessage.a()));
            }
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        if (!this.k) {
            EntityPlayer entityplayer = this.i();
            if (entityplayer != null) {
                entityplayer.a(ichatbasecomponent);
            } else {
                this.d.a(ichatbasecomponent);
            }
        }
    }

    public void a(Supplier<IChatBaseComponent> supplier, boolean flag) {
        boolean flag2;
        boolean flag1 = this.d.z_() && !this.k;
        boolean bl = flag2 = flag && this.d.c() && !this.k;
        if (flag1 || flag2) {
            IChatBaseComponent ichatbasecomponent = supplier.get();
            if (flag1) {
                this.d.a(ichatbasecomponent);
            }
            if (flag2) {
                this.c(ichatbasecomponent);
            }
        }
    }

    private void c(IChatBaseComponent ichatbasecomponent) {
        IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.a("chat.type.admin", this.b(), ichatbasecomponent).a(EnumChatFormat.h, EnumChatFormat.u);
        if (this.j.aQ().c(GameRules.q)) {
            for (EntityPlayer entityplayer : this.j.am().t()) {
                if (entityplayer.B() == this.d || !entityplayer.getBukkitEntity().hasPermission("minecraft.admin.command_feedback")) continue;
                entityplayer.a(ichatbasecomponent1);
            }
        }
        if (this.d != this.j && this.j.aQ().c(GameRules.n) && !SpigotConfig.silentCommandBlocks) {
            this.j.a(ichatbasecomponent1);
        }
    }

    public void b(IChatBaseComponent ichatbasecomponent) {
        if (this.d.A_() && !this.k) {
            this.d.a(IChatBaseComponent.i().b(ichatbasecomponent).a(EnumChatFormat.m));
        }
    }

    @Override
    public CommandResultCallback p() {
        return this.m;
    }

    @Override
    public Collection<String> q() {
        return Lists.newArrayList((Object[])this.j.T());
    }

    @Override
    public Collection<String> r() {
        return this.j.aO().e();
    }

    @Override
    public Stream<MinecraftKey> s() {
        return BuiltInRegistries.b.s().map(SoundEffect::a);
    }

    @Override
    public CompletableFuture<Suggestions> a(CommandContext<?> commandcontext) {
        return Suggestions.empty();
    }

    @Override
    public CompletableFuture<Suggestions> a(ResourceKey<? extends IRegistry<?>> resourcekey, ICompletionProvider.a icompletionprovider_a, SuggestionsBuilder suggestionsbuilder, CommandContext<?> commandcontext) {
        if (resourcekey == Registries.bD) {
            return ICompletionProvider.a(this.j.aN().d().stream().map(recipeholder -> recipeholder.a().a()), suggestionsbuilder);
        }
        if (resourcekey == Registries.bC) {
            Collection<AdvancementHolder> collection = this.j.aF().b();
            return ICompletionProvider.a(collection.stream().map(AdvancementHolder::a), suggestionsbuilder);
        }
        return this.a(resourcekey).map(holderlookup -> {
            this.a((HolderLookup<?>)holderlookup, icompletionprovider_a, suggestionsbuilder);
            return suggestionsbuilder.buildFuture();
        }).orElseGet(Suggestions::empty);
    }

    private Optional<? extends HolderLookup<?>> a(ResourceKey<? extends IRegistry<?>> resourcekey) {
        Optional optional = this.u().a(resourcekey);
        return optional.isPresent() ? optional : this.j.bi().a().a(resourcekey);
    }

    @Override
    public Set<ResourceKey<World>> t() {
        return this.j.P();
    }

    @Override
    public IRegistryCustom u() {
        return this.j.bg();
    }

    @Override
    public FeatureFlagSet v() {
        return this.f.O();
    }

    @Override
    public CommandDispatcher<CommandListenerWrapper> w() {
        return this.l().aG().a();
    }

    @Override
    public void a(CommandExceptionType commandexceptiontype, Message message, boolean flag, @Nullable TraceCallbacks tracecallbacks) {
        if (tracecallbacks != null) {
            tracecallbacks.a(message.getString());
        }
        if (!flag) {
            this.b(ChatComponentUtils.a(message));
        }
    }

    @Override
    public boolean x() {
        return this.k;
    }

    public CommandSender getBukkitSender() {
        return this.d.getBukkitSender(this);
    }

    @Override
    public boolean c_() {
        return this.hasPermission(2, "minecraft.command.selector");
    }
}

