/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    @SuppressForbidden(reason="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(OptionSet optionset) {
        SharedConstants.a();
        try {
            WorldStem worldstem;
            Dynamic<?> dynamic;
            Path path = (Path)optionset.valueOf("pidFile");
            if (path != null) {
                Main.a(path);
            }
            CrashReport.g();
            if (optionset.has("jfrProfile")) {
                JvmProfiler.f.a(Environment.b);
            }
            DispenserRegistry.a();
            DispenserRegistry.c();
            SystemUtils.p();
            Path path1 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings dedicatedserversettings = new DedicatedServerSettings(optionset);
            dedicatedserversettings.b();
            RegionFileCompression.a(dedicatedserversettings.a().T);
            Path path2 = Paths.get("eula.txt", new String[0]);
            EULA eula = new EULA(path2);
            if (optionset.has("initSettings")) {
                File configFile = (File)optionset.valueOf("bukkit-settings");
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
                configuration.options().copyDefaults(true);
                configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
                configuration.save(configFile);
                File commandFile = (File)optionset.valueOf("commands-settings");
                YamlConfiguration commandsConfiguration = YamlConfiguration.loadConfiguration((File)commandFile);
                commandsConfiguration.options().copyDefaults(true);
                commandsConfiguration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/commands.yml"), Charsets.UTF_8)));
                commandsConfiguration.save(commandFile);
                a.info("Initialized '{}' and '{}'", (Object)path1.toAbsolutePath(), (Object)path2.toAbsolutePath());
                return;
            }
            boolean eulaAgreed = Boolean.getBoolean("com.mojang.eula.agree");
            if (eulaAgreed) {
                System.err.println("You have used the Spigot command line EULA agreement flag.");
                System.err.println("By using this setting you are indicating your agreement to Mojang's EULA (https://account.mojang.com/documents/minecraft_eula).");
                System.err.println("If you do not agree to the above EULA please stop your server and remove this flag immediately.");
            }
            if (!eula.a() && !eulaAgreed) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File file = (File)optionset.valueOf("universe");
            Services services = Services.a(new YggdrasilAuthenticationService(Proxy.NO_PROXY), file);
            String s2 = Optional.ofNullable((String)optionset.valueOf("world")).orElse(dedicatedserversettings.a().o);
            Convertable convertable = Convertable.b(file.toPath());
            Convertable.ConversionSession convertable_conversionsession = convertable.validateAndCreateAccess(s2, WorldDimension.b);
            if (convertable_conversionsession.m()) {
                WorldInfo worldinfo;
                try {
                    dynamic = convertable_conversionsession.h();
                    worldinfo = convertable_conversionsession.a(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception) {
                    Convertable.b convertable_b = convertable_conversionsession.e();
                    a.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    a.info("Attempting to use fallback");
                    try {
                        dynamic = convertable_conversionsession.i();
                        worldinfo = convertable_conversionsession.a(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception1) {
                        a.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        a.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    convertable_conversionsession.n();
                }
                if (worldinfo.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            Dynamic<?> dynamic1 = dynamic;
            boolean flag = optionset.has("safeMode");
            if (flag) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            ResourcePackRepository resourcepackrepository = ResourcePackSourceVanilla.a(convertable_conversionsession);
            File bukkitDataPackFolder = new File(convertable_conversionsession.a(SavedFile.j).toFile(), "bukkit");
            if (!bukkitDataPackFolder.exists()) {
                bukkitDataPackFolder.mkdirs();
            }
            File mcMeta = new File(bukkitDataPackFolder, "pack.mcmeta");
            try {
                com.google.common.io.Files.write((CharSequence)("{\n    \"pack\": {\n        \"description\": \"Data pack for resources provided by Bukkit plugins\",\n        \"min_format\": " + String.valueOf(SharedConstants.b().a(EnumResourcePackType.b)) + ",\n        \"max_format\": " + String.valueOf(SharedConstants.b().a(EnumResourcePackType.b)) + "\n    }\n}\n"), (File)mcMeta, (Charset)Charsets.UTF_8);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not initialize Bukkit datapack", ex);
            }
            AtomicReference worldLoader = new AtomicReference();
            try {
                WorldLoader.c worldloader_c = Main.a(dedicatedserversettings.a(), dynamic1, flag, resourcepackrepository);
                worldstem = (WorldStem)SystemUtils.c(executor -> WorldLoader.a(worldloader_c, (WorldLoader.a worldloader_a) -> {
                    worldLoader.set(worldloader_a);
                    IRegistry<WorldDimension> iregistry = worldloader_a.d().f(Registries.by);
                    if (dynamic1 != null) {
                        LevelDataAndDimensions leveldataanddimensions = Convertable.a(dynamic1, worldloader_a.b(), iregistry, worldloader_a.c());
                        return new WorldLoader.b<SaveData>(leveldataanddimensions.a(), leveldataanddimensions.b().b());
                    }
                    a.info("No existing world data, creating new world");
                    return Main.a(dedicatedserversettings, worldloader_a, iregistry, optionset.has("demo"), optionset.has("bonusChest"));
                }, WorldStem::new, SystemUtils.h(), executor)).get();
            }
            catch (Exception exception) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                return;
            }
            DedicatedServer dedicatedServer = MinecraftServer.a((Thread thread) -> {
                int port;
                boolean flag2;
                DedicatedServer dedicatedserver1 = new DedicatedServer(optionset, (WorldLoader.a)worldLoader.get(), (Thread)thread, convertable_conversionsession, resourcepackrepository, worldstem, dedicatedserversettings, DataConverterRegistry.a(), services);
                boolean bl = flag2 = !optionset.has("nogui") && !optionset.nonOptionArguments().contains("nogui");
                if (flag2 && !GraphicsEnvironment.isHeadless()) {
                    dedicatedserver1.bF();
                }
                if (optionset.has("port") && (port = ((Integer)optionset.valueOf("port")).intValue()) > 0) {
                    dedicatedserver1.b(port);
                }
                return dedicatedserver1;
            });
        }
        catch (Exception exception1) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static WorldLoader.b<SaveData> a(DedicatedServerSettings dedicatedserversettings, WorldLoader.a worldloader_a, IRegistry<WorldDimension> iregistry, boolean flag, boolean flag1) {
        WorldDimensions worlddimensions;
        WorldOptions worldoptions;
        WorldSettings worldsettings;
        if (flag) {
            worldsettings = MinecraftServer.e;
            worldoptions = WorldOptions.b;
            worlddimensions = WorldPresets.a(worldloader_a.c());
        } else {
            DedicatedServerProperties dedicatedserverproperties = dedicatedserversettings.a();
            worldsettings = new WorldSettings(dedicatedserverproperties.o, dedicatedserverproperties.n.get(), dedicatedserverproperties.D, dedicatedserverproperties.m.get(), false, new GameRules(worldloader_a.b().b()), worldloader_a.b());
            worldoptions = flag1 ? dedicatedserverproperties.ai.a(true) : dedicatedserverproperties.ai;
            worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
        }
        WorldDimensions.b worlddimensions_b = worlddimensions.a(iregistry);
        Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
        return new WorldLoader.b<SaveData>(new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle), worlddimensions_b.b());
    }

    private static void a(Path path) {
        try {
            long i2 = ProcessHandle.current().pid();
            Files.writeString(path, (CharSequence)Long.toString(i2), new OpenOption[0]);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }

    private static WorldLoader.c a(DedicatedServerProperties dedicatedserverproperties, @Nullable Dynamic<?> dynamic, boolean flag, ResourcePackRepository resourcepackrepository) {
        WorldDataConfiguration worlddataconfiguration;
        boolean flag1;
        if (dynamic != null) {
            WorldDataConfiguration worlddataconfiguration1 = Convertable.a(dynamic);
            flag1 = false;
            worlddataconfiguration = worlddataconfiguration1;
        } else {
            flag1 = true;
            worlddataconfiguration = new WorldDataConfiguration(dedicatedserverproperties.ab, FeatureFlags.h);
        }
        WorldLoader.d worldloader_d = new WorldLoader.d(resourcepackrepository, worlddataconfiguration, flag, flag1);
        return new WorldLoader.c(worldloader_d, CommandDispatcher.ServerType.b, dedicatedserverproperties.H);
    }

    public static void a(Convertable.ConversionSession convertable_conversionsession, SaveData savedata, DataFixer datafixer, boolean flag, BooleanSupplier booleansupplier, IRegistryCustom iregistrycustom, boolean flag1) {
        a.info("Forcing world upgrade! {}", (Object)convertable_conversionsession.f());
        try (WorldUpgrader worldupgrader = new WorldUpgrader(convertable_conversionsession, datafixer, savedata, iregistrycustom, flag, flag1);){
            IChatBaseComponent ichatbasecomponent = null;
            while (!worldupgrader.b()) {
                int i2;
                IChatBaseComponent ichatbasecomponent1 = worldupgrader.h();
                if (ichatbasecomponent != ichatbasecomponent1) {
                    ichatbasecomponent = ichatbasecomponent1;
                    a.info(worldupgrader.h().getString());
                }
                if ((i2 = worldupgrader.e()) > 0) {
                    int j2 = worldupgrader.f() + worldupgrader.g();
                    a.info("{}% completed ({} / {} chunks)...", new Object[]{MathHelper.d((float)j2 / (float)i2 * 100.0f), j2, i2});
                }
                if (!booleansupplier.getAsBoolean()) {
                    worldupgrader.a();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

