/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundShowDialogPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.HashOps;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.HappyGhast;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman {
    private static final Logger cA = LogUtils.getLogger();
    private static final int cB = 32;
    private static final int cC = 10;
    private static final int cD = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    public static final String f = "Dimension";
    private static final AttributeModifier cE = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cF = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    private static final IChatBaseComponent cG = IChatBaseComponent.c("block.minecraft.set_spawn");
    private static final AttributeModifier cH = new AttributeModifier(MinecraftKey.b("waypoint_transmit_range_crouch"), -1.0, AttributeModifier.Operation.c);
    private static final boolean cI = false;
    private static final boolean cJ = false;
    public PlayerConnection g;
    public final MinecraftServer cK;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cL;
    private final ServerStatisticManager cM;
    private float cN = Float.MIN_VALUE;
    private int cO = Integer.MIN_VALUE;
    private int cP = Integer.MIN_VALUE;
    private int cS = Integer.MIN_VALUE;
    private int cT = Integer.MIN_VALUE;
    private int cU = Integer.MIN_VALUE;
    private float cV = -1.0E8f;
    private int cW = -99999999;
    private boolean cX = true;
    public int cY = -99999999;
    private EnumChatVisibility cZ = EnumChatVisibility.a;
    private ParticleStatus da = ParticleStatus.a;
    private boolean db = true;
    private long dc = SystemUtils.c();
    @Nullable
    private Entity dd;
    public boolean de;
    public boolean i = false;
    private final RecipeBookServer df;
    @Nullable
    private Vec3D dg;
    private int dh;
    private boolean di;
    private int dj = 2;
    public String dk = "en_us";
    @Nullable
    private Vec3D dl;
    @Nullable
    private Vec3D dm;
    @Nullable
    private Vec3D dn;
    private SectionPosition do = SectionPosition.a(0, 0, 0);
    private ChunkTrackingView dp = ChunkTrackingView.a;
    @Nullable
    private RespawnConfig dq;
    private final ITextFilter dr;
    private boolean ds;
    private boolean dt;
    private boolean du = false;
    private WardenSpawnTracker dv = new WardenSpawnTracker();
    @Nullable
    private BlockPosition dw;
    private Vec3D dx = Vec3D.c;
    private Input dy = Input.b;
    private final Set<EntityEnderPearl> dz = new HashSet<EntityEnderPearl>();
    private long dA;
    private NBTTagCompound dB = new NBTTagCompound();
    private NBTTagCompound dC = new NBTTagCompound();
    private final ContainerSynchronizer dD = new ContainerSynchronizer(){
        private final LoadingCache<TypedDataComponent<?>, Integer> b = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){
            private final DynamicOps<HashCode> b;
            {
                this.b = EntityPlayer.this.ej().a(HashOps.c);
            }

            public Integer a(TypedDataComponent<?> typeddatacomponent) {
                return ((HashCode)typeddatacomponent.a(this.b).getOrThrow(s2 -> {
                    String s1 = String.valueOf(typeddatacomponent);
                    return new IllegalArgumentException("Failed to hash " + s1 + ": " + s2);
                })).asInt();
            }
        });

        @Override
        public void a(Container container, List<ItemStack> list, ItemStack itemstack, int[] aint) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowItems(container.l, container.k(), list, itemstack));
            for (int i2 = 0; i2 < aint.length; ++i2) {
                this.b(container, i2, aint[i2]);
            }
        }

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            EntityPlayer.this.g.b(new PacketPlayOutSetSlot(container.l, container.k(), i2, itemstack));
        }

        @Override
        public void a(Container container, ItemStack itemstack) {
            EntityPlayer.this.g.b(new ClientboundSetCursorItemPacket(itemstack));
        }

        @Override
        public void a(Container container, int i2, int j2) {
            this.b(container, i2, j2);
        }

        private void b(Container container, int i2, int j2) {
            EntityPlayer.this.g.b(new PacketPlayOutWindowData(container.l, i2, j2));
        }

        @Override
        public RemoteSlot a() {
            LoadingCache<TypedDataComponent<?>, Integer> loadingcache = this.b;
            Objects.requireNonNull(this.b);
            return new RemoteSlot.a(arg_0 -> loadingcache.getUnchecked(arg_0));
        }
    };
    private final ICrafting dE = new ICrafting(){

        @Override
        public void a(Container container, int i2, ItemStack itemstack) {
            Slot slot = container.b(i2);
            if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gB()) {
                CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gB(), itemstack);
            }
        }

        @Override
        public void a(Container container, int i2, int j2) {
        }
    };
    @Nullable
    private RemoteChatSession dF;
    @Nullable
    public final Object j;
    private final ICommandListener dG = new ICommandListener(){

        @Override
        public boolean z_() {
            return EntityPlayer.this.A().S().c(GameRules.q);
        }

        @Override
        public boolean A_() {
            return true;
        }

        @Override
        public boolean c() {
            return true;
        }

        @Override
        public void a(IChatBaseComponent ichatbasecomponent) {
            EntityPlayer.this.a(ichatbasecomponent);
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
            return EntityPlayer.this.getBukkitEntity();
        }
    };
    private Set<DebugSubscription<?>> dH = Set.of();
    private int dI;
    public boolean k;
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public String kickLeaveMessage = null;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public EntityPlayer(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile, ClientInformation clientinformation) {
        super(worldserver, gameprofile);
        this.cK = minecraftserver;
        this.dr = minecraftserver.a(this);
        this.h = minecraftserver.b(this);
        this.h.a(this.b((EnumGamemode)null), null);
        this.df = new RecipeBookServer((resourcekey, consumer) -> minecraftserver.aN().a(resourcekey, consumer));
        this.cM = minecraftserver.am().getPlayerStats(this);
        this.cL = minecraftserver.am().f(this);
        this.a(clientinformation);
        this.j = null;
        this.displayName = this.cV();
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.fj();
    }

    public void resendItemInHands() {
        this.cl.b(this.gB(), this.gB().g()).ifPresent(s2 -> this.dD.a(this.cl, s2, this.fq()));
        this.dD.a((Container)this.ck, 45, this.fr());
    }

    @Override
    public BlockPosition a(WorldServer worldserver, BlockPosition blockposition) {
        CompletableFuture<Vec3D> completablefuture = PlayerSpawnFinder.a(worldserver, blockposition);
        MinecraftServer minecraftserver = this.cK;
        Objects.requireNonNull(completablefuture);
        minecraftserver.b(completablefuture::isDone);
        return BlockPosition.a(completablefuture.join());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.dv = valueinput.a("warden_spawn_tracker", WardenSpawnTracker.a).orElseGet(WardenSpawnTracker::new);
        this.dm = valueinput.a("entered_nether_pos", Vec3D.a).orElse(null);
        this.i = valueinput.a("seenCredits", false);
        valueinput.a("recipeBook", RecipeBookServer.b.a).ifPresent(recipebookserver_b -> this.df.a((RecipeBookServer.b)recipebookserver_b, (ResourceKey<IRecipe<?>> resourcekey) -> this.cK.aN().b((ResourceKey<IRecipe<?>>)resourcekey).isPresent()));
        this.getBukkitEntity().readExtraData(valueinput);
        if (this.gg()) {
            this.gh();
        }
        this.dq = valueinput.a("respawn", RespawnConfig.a).orElse(null);
        String spawnWorld = valueinput.a("SpawnWorld", "");
        CraftWorld oldWorld = (CraftWorld)Bukkit.getWorld((String)spawnWorld);
        if (oldWorld != null) {
            RespawnConfig respawnConfig = this.dq;
            WorldData.a respawnData = respawnConfig.a();
            this.dq = new RespawnConfig(WorldData.a.a(oldWorld.getHandle().al(), respawnData.b(), respawnData.d(), respawnData.e()), respawnConfig.b());
        }
        this.du = valueinput.a("spawn_extra_particles_on_fall", false);
        this.dw = valueinput.a("raid_omen_position", BlockPosition.a).orElse(null);
        this.h.a(this.b(EntityPlayer.a(valueinput, "playerGameType")), EntityPlayer.a(valueinput, "previousPlayerGameType"));
        this.b(valueinput.a("ShoulderEntityLeft", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
        this.c(valueinput.a("ShoulderEntityRight", NBTTagCompound.a).orElseGet(NBTTagCompound::new));
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("warden_spawn_tracker", WardenSpawnTracker.a, this.dv);
        this.g(valueoutput);
        valueoutput.a("seenCredits", this.i);
        valueoutput.b("entered_nether_pos", Vec3D.a, this.dm);
        this.e(valueoutput);
        valueoutput.a("recipeBook", RecipeBookServer.b.a, this.df.b());
        valueoutput.a(f, this.A().al().a().toString());
        valueoutput.b("respawn", RespawnConfig.a, this.dq);
        this.getBukkitEntity().setExtraData(valueoutput);
        valueoutput.a("spawn_extra_particles_on_fall", this.du);
        valueoutput.b("raid_omen_position", BlockPosition.a, this.dw);
        this.f(valueoutput);
        if (!this.ak().j()) {
            valueoutput.a("ShoulderEntityLeft", NBTTagCompound.a, this.ak());
        }
        if (!this.al().j()) {
            valueoutput.a("ShoulderEntityRight", NBTTagCompound.a, this.al());
        }
    }

    private void e(ValueOutput valueoutput) {
        Entity entity = this.dp();
        Entity entity1 = this.du();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (Entity vehicle = entity1; vehicle != null; vehicle = vehicle.du()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.do()) {
            ValueOutput valueoutput1 = valueoutput.a("RootVehicle");
            valueoutput1.a("Attach", UUIDUtil.a, entity1.cT());
            entity.c(valueoutput1.a("Entity"));
        }
    }

    public void b(ValueInput valueinput) {
        Optional<ValueInput> optional = valueinput.a("RootVehicle");
        if (!optional.isEmpty()) {
            WorldServer worldserver = this.A();
            Entity entity = EntityTypes.a(optional.get().b("Entity"), (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c((Entity)entity1) ? null : entity1);
            if (entity != null) {
                UUID uuid = optional.get().a("Attach", UUIDUtil.a).orElse(null);
                if (entity.cT().equals(uuid)) {
                    this.a(entity, true, false);
                } else {
                    for (Entity entity12 : entity.dm()) {
                        if (!entity12.cT().equals(uuid)) continue;
                        this.a(entity12, true, false);
                        break;
                    }
                }
                if (!this.cl()) {
                    cA.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity2 : entity.dm()) {
                        entity2.discard(null);
                    }
                }
            }
        }
    }

    private void f(ValueOutput valueoutput) {
        if (!this.dz.isEmpty()) {
            ValueOutput.b valueoutput_b = valueoutput.b(d);
            for (EntityEnderPearl entityenderpearl : this.dz) {
                if (entityenderpearl.ec()) {
                    cA.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                ValueOutput valueoutput1 = valueoutput_b.a();
                entityenderpearl.c(valueoutput1);
                valueoutput1.a(e, net.minecraft.world.level.World.g, entityenderpearl.an().al());
            }
        }
    }

    public void c(ValueInput valueinput) {
        valueinput.d(d).forEach(this::e);
    }

    private void e(ValueInput valueinput) {
        Optional<ResourceKey<net.minecraft.world.level.World>> optional = valueinput.a(e, net.minecraft.world.level.World.g);
        if (!optional.isEmpty()) {
            WorldServer worldserver = this.A().q().a(optional.get());
            if (worldserver != null) {
                Entity entity = EntityTypes.a(valueinput, (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c((Entity)entity1) ? null : entity1);
                if (entity != null) {
                    EntityPlayer.a(worldserver, entity.dH());
                } else {
                    cA.warn("Failed to spawn player ender pearl in level ({}), skipping", optional.get());
                }
            } else {
                cA.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional.get());
            }
        }
    }

    public void spawnIn(net.minecraft.world.level.World world, boolean flag) {
        this.a(world);
        if (world == null) {
            this.ee();
            TeleportTransition teleporttransition = this.findRespawnPositionAndUseSpawnBlock(!flag, TeleportTransition.a, null);
            this.a((net.minecraft.world.level.World)teleporttransition.b());
            this.b(teleporttransition.c());
        }
        this.h.a((WorldServer)world);
    }

    public void a(int i2) {
        float f2 = this.gL();
        float f1 = (f2 - 1.0f) / f2;
        this.ct = MathHelper.a((float)i2 / f2, 0.0f, f1);
        this.cY = -1;
    }

    public void b(int i2) {
        this.cr = i2;
        this.cY = -1;
    }

    @Override
    public void c(int i2) {
        super.c(i2);
        this.cY = -1;
    }

    @Override
    public void a(ItemStack itemstack, int i2) {
        super.a(itemstack, i2);
        this.cY = -1;
    }

    public void a(Container container) {
        container.a(this.dE);
        container.a(this.dD);
        container.startOpen();
    }

    public void c() {
        this.a(this.ck);
    }

    @Override
    public void i_() {
        super.i_();
        this.g.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void Q_() {
        super.Q_();
        this.g.b(new ClientboundPlayerCombatEndPacket(this.fh()));
    }

    @Override
    public void a(IBlockData iblockdata) {
        CriterionTriggers.e.a(this, iblockdata);
    }

    @Override
    protected ItemCooldown f() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void g() {
        Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.hc();
        this.h.a();
        this.dv.a();
        if (this.ax > 0) {
            --this.ax;
        }
        this.cl.d();
        if (!this.cl.b(this)) {
            this.r();
            this.cl = this.ck;
        }
        if ((entity = this.N()) != this) {
            if (entity.bX()) {
                this.a(entity.dK(), entity.dM(), entity.dQ(), entity.dX(), entity.dZ());
                this.A().n().a(this);
                if (this.gq()) {
                    this.d((Entity)this);
                }
            } else {
                this.d((Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.dg != null) {
            CriterionTriggers.v.a(this, this.dg, this.at - this.dh);
        }
        this.m();
        this.n();
        this.hk();
        this.cL.a(this, true);
    }

    private void hk() {
        AttributeModifiable attributemodifiable2;
        AttributeModifiable attributemodifiable1;
        AttributeModifiable attributemodifiable = this.h(GenericAttributes.g);
        if (attributemodifiable != null) {
            if (this.gQ()) {
                attributemodifiable.a(cE);
            } else {
                attributemodifiable.e(cE);
            }
        }
        if ((attributemodifiable1 = this.h(GenericAttributes.k)) != null) {
            if (this.gQ()) {
                attributemodifiable1.a(cF);
            } else {
                attributemodifiable1.e(cF);
            }
        }
        if ((attributemodifiable2 = this.h(GenericAttributes.H)) != null) {
            if (this.cu()) {
                attributemodifiable2.a(cH);
            } else {
                attributemodifiable2.e(cH);
            }
        }
    }

    public void h() {
        try {
            if (!this.at() || !this.dy()) {
                super.g();
                if (!this.cl.b(this)) {
                    this.r();
                    this.cl = this.ck;
                }
                this.cm.a(this);
                this.a(StatisticList.k);
                this.a(StatisticList.l);
                if (this.bX()) {
                    this.a(StatisticList.m);
                }
                if (this.cs()) {
                    this.a(StatisticList.o);
                }
                if (!this.gg()) {
                    this.a(StatisticList.n);
                }
            }
            for (int i2 = 0; i2 < this.gB().b(); ++i2) {
                ItemStack itemstack = this.gB().a(i2);
                if (itemstack.f()) continue;
                this.i(itemstack);
            }
            if (this.eU() != this.cV || this.cW != this.cm.a() || this.cm.c() == 0.0f != this.cX) {
                this.g.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.cm.a(), this.cm.c()));
                this.cV = this.eU();
                this.cW = this.cm.a();
                boolean bl = this.cX = this.cm.c() == 0.0f;
            }
            if (this.eU() + this.fM() != this.cN) {
                this.cN = this.eU() + this.fM();
                this.a(IScoreboardCriteria.h, MathHelper.f(this.cN));
            }
            if (this.cm.a() != this.cO) {
                this.cO = this.cm.a();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cO));
            }
            if (this.cF() != this.cP) {
                this.cP = this.cF();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cP));
            }
            if (this.fg() != this.cS) {
                this.cS = this.fg();
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cS));
            }
            if (this.cs != this.cU) {
                this.cU = this.cs;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.cU));
            }
            if (this.maxHealthCache != (double)this.fj()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cr != this.cT) {
                this.cT = this.cr;
                this.a(IScoreboardCriteria.m, MathHelper.f((float)this.cT));
            }
            if (this.cs != this.cY) {
                this.cY = this.cs;
                this.g.b(new PacketPlayOutExperience(this.ct, this.cs, this.cr));
            }
            if (this.at % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cr;
            }
            if (this.oldLevel != this.cr) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cr);
                this.oldLevel = this.cr;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    private void i(ItemStack itemstack) {
        Packet<?> packet;
        MapId mapid = itemstack.a(DataComponents.M);
        WorldMap worldmap = ItemWorldMap.a(mapid, (net.minecraft.world.level.World)this.A());
        if (worldmap != null && (packet = worldmap.a(mapid, this)) != null) {
            this.g.b(packet);
        }
    }

    @Override
    protected void i() {
        if (this.A().aq() == EnumDifficulty.a && this.A().S().c(GameRules.l)) {
            if (this.at % 20 == 0) {
                float f2;
                if (this.eU() < this.fj()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((f2 = this.cm.c()) < 20.0f) {
                    this.cm.b(f2 + 1.0f);
                }
            }
            if (this.at % 10 == 0 && this.cm.b()) {
                this.cm.a(this.cm.a() + 1);
            }
        }
    }

    @Override
    public void j() {
        this.e(this.ak());
        this.e(this.al());
        if (this.an > 0.5 || this.bu() || this.gC().b || this.gg() || this.aJ) {
            this.k();
        }
    }

    private void e(NBTTagCompound nbttagcompound) {
        EntityTypes entitytypes;
        if (!(nbttagcompound.j() || nbttagcompound.b("Silent", false) || this.as.a(200) != 0 || (entitytypes = (EntityTypes)nbttagcompound.a("id", EntityTypes.a).orElse(null)) != EntityTypes.aT || EntityParrot.a((net.minecraft.world.level.World)this.A(), (Entity)this))) {
            this.A().a((Entity)null, this.dK(), this.dM(), this.dQ(), EntityParrot.a((net.minecraft.world.level.World)this.A(), this.as), this.dw(), 1.0f, EntityParrot.a(this.as));
        }
    }

    public boolean a(NBTTagCompound nbttagcompound) {
        if (!this.cl() && this.aS() && !this.bu() && !this.aJ) {
            if (this.ak().j()) {
                this.b(nbttagcompound);
                this.dA = this.A().ag();
                return true;
            }
            if (this.al().j()) {
                this.c(nbttagcompound);
                this.dA = this.A().ag();
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    protected void k() {
        if (this.dA + 20L < this.A().ag()) {
            if (this.respawnEntityOnShoulder(this.ak())) {
                this.b(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.al())) {
                this.c(new NBTTagCompound());
            }
        }
    }

    public Entity getEntityOnShoulder(NBTTagCompound nbttagcompound) {
        WorldServer worldserver = this.A();
        if (worldserver instanceof WorldServer) {
            WorldServer worldserver1 = worldserver;
            if (!nbttagcompound.j()) {
                try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this.en(), cA);){
                    Entity entity2 = EntityTypes.a(TagValueInput.a(problemreporter_j.a(() -> ".shoulder"), (HolderLookup.a)worldserver1.L_(), nbttagcompound), (net.minecraft.world.level.World)worldserver1, EntitySpawnReason.r).map(entity -> {
                        if (entity instanceof EntityTameableAnimal) {
                            EntityTameableAnimal entitytameableanimal = (EntityTameableAnimal)entity;
                            entitytameableanimal.i(this);
                        }
                        entity.a_(this.dK(), this.dM() + (double)0.7f, this.dQ());
                        return entity;
                    }).orElse(null);
                    return entity2;
                }
            }
        }
        return null;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        Entity entity = this.getEntityOnShoulder(nbttagcompound);
        if (entity != null) {
            return this.A().addWithUUID(entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
        }
        return true;
    }

    @Override
    public void l() {
        if (this.eU() > 0.0f && this.dl != null) {
            CriterionTriggers.Y.a(this, this.dl);
        }
        this.dl = null;
        super.l();
    }

    public void m() {
        if (this.an > 0.0 && this.dl == null) {
            this.dl = this.dD();
            if (this.cy != null && this.cy.h <= this.dl.h) {
                CriterionTriggers.af.a(this, this.cy, this.cz);
            }
        }
    }

    public void n() {
        if (this.du() != null && this.du().bJ()) {
            if (this.dn == null) {
                this.dn = this.dD();
            } else {
                CriterionTriggers.Z.a(this, this.dn);
            }
        }
        if (!(this.dn == null || this.du() != null && this.du().bJ())) {
            this.dn = null;
        }
    }

    private void a(IScoreboardCriteria iscoreboardcriteria, int i2) {
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(iscoreboardcriteria, this, scoreaccess -> scoreaccess.a(i2));
    }

    @Override
    public void a(DamageSource damagesource) {
        String deathMessage;
        boolean keepInventory;
        this.c(GameEvent.p);
        boolean flag = this.A().S().c(GameRules.o);
        if (this.ec()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.gB().b());
        boolean bl = keepInventory = this.A().S().c(GameRules.e) || this.at();
        if (!keepInventory) {
            for (ItemStack item : this.gB()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(CraftItemStack.asCraftMirror(item).markForInventoryDrop());
            }
        }
        this.b(this.A(), damagesource, this.bH > 0);
        this.a(this.A(), damagesource, flag);
        loot.addAll(this.drops);
        this.drops.clear();
        IChatBaseComponent defaultMessage = this.fh().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damagesource, loot, deathmessage, keepInventory);
        if (this.cl != this.ck) {
            this.r();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            IChatBaseComponent ichatbasecomponent = deathMessage.equals(deathmessage) ? this.fh().a() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.g.a(new ClientboundPlayerCombatKillPacket(this.az(), ichatbasecomponent), PacketSendListener.a(() -> {
                int i2 = 256;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatbasecomponent2 = IChatBaseComponent.a("death.attack.even_more_magic", this.S_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable.e(ichatbasecomponent1)));
                return new ClientboundPlayerCombatKillPacket(this.az(), ichatbasecomponent2);
            }));
            ScoreboardTeam scoreboardteambase = this.cD();
            if (scoreboardteambase != null && ((ScoreboardTeamBase)scoreboardteambase).l() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (((ScoreboardTeamBase)scoreboardteambase).l() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.cK.am().a((EntityHuman)this, ichatbasecomponent);
                } else if (((ScoreboardTeamBase)scoreboardteambase).l() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.cK.am().b(this, ichatbasecomponent);
                }
            } else {
                this.cK.am().a(ichatbasecomponent, false);
            }
        } else {
            this.g.b(new ClientboundPlayerCombatKillPacket(this.az(), CommonComponents.a));
        }
        this.k();
        if (this.A().S().c(GameRules.P)) {
            this.hl();
        }
        this.b(this.A(), damagesource.d());
        if (!event.getKeepInventory()) {
            this.gB().a();
        }
        this.d((Entity)this);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
        EntityLiving entityliving = this.fi();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ax()));
            entityliving.a((Entity)this, damagesource);
            this.e(entityliving);
        }
        this.A().a((Entity)this, (byte)3);
        this.a(StatisticList.O);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aQ();
        this.k(0);
        this.d(false);
        this.fh().c();
        this.d(Optional.of(GlobalPos.a(this.A().al(), this.dF())));
        this.w(false);
    }

    private void hl() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.dF()).c(32.0, 10.0, 32.0);
        this.A().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this.A(), this));
    }

    @Override
    public void a(Entity entity, DamageSource damagesource) {
        if (entity != this) {
            super.a(entity, damagesource);
            CraftScoreboardManager scoreboard = this.A().getCraftServer().getScoreboardManager();
            scoreboard.forAllObjectives(IScoreboardCriteria.g, this, ScoreAccess::b);
            if (entity instanceof EntityHuman) {
                this.a(StatisticList.R);
                scoreboard.forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.P);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entity, IScoreboardCriteria.n);
            this.a((ScoreHolder)entity, (ScoreHolder)this, IScoreboardCriteria.o);
            CriterionTriggers.c.a(this, entity, damagesource);
        }
    }

    private void a(ScoreHolder scoreholder, ScoreHolder scoreholder1, IScoreboardCriteria[] aiscoreboardcriteria) {
        int i2;
        ScoreboardServer scoreboard = this.A().g();
        ScoreboardTeam scoreboardteam = scoreboard.e(scoreholder1.cV());
        if (scoreboardteam != null && (i2 = scoreboardteam.o().b()) >= 0 && i2 < aiscoreboardcriteria.length) {
            this.A().getCraftServer().getScoreboardManager().forAllObjectives(aiscoreboardcriteria[i2], scoreholder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        Entity entity1;
        EntityHuman entityhuman;
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        Entity entity = damagesource.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).ai_()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        return super.a(worldserver, damagesource, f2);
    }

    @Override
    public boolean a(EntityHuman entityhuman) {
        return !this.hm() ? false : super.a(entityhuman);
    }

    private boolean hm() {
        return this.A().getWorld().getPVP();
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean flag, TeleportTransition.a teleporttransition_a, PlayerRespawnEvent.RespawnReason reason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        RespawnConfig entityplayer_respawnconfig = this.V();
        WorldServer worldserver = this.cK.a(RespawnConfig.b(entityplayer_respawnconfig));
        if (worldserver != null && entityplayer_respawnconfig != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(worldserver, entityplayer_respawnconfig, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(worldserver, entityplayer_respawnposangle.a(), Vec3D.c, entityplayer_respawnposangle.b(), entityplayer_respawnposangle.c(), teleporttransition_a);
            } else {
                teleportTransition = TeleportTransition.b(this, teleporttransition_a);
            }
        } else {
            teleportTransition = TeleportTransition.a(this, teleporttransition_a);
        }
        if (reason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (World)teleportTransition.b().getWorld(), teleportTransition.e(), teleportTransition.f());
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason);
        this.A().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.g.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause());
    }

    public boolean o() {
        return this.i(GenericAttributes.I) > 0.0;
    }

    @Override
    protected void a(Holder<AttributeBase> holder) {
        if (holder.a(GenericAttributes.I)) {
            ServerWaypointManager serverwaypointmanager = this.A().h();
            if (this.fp().c(holder) > 0.0) {
                serverwaypointmanager.a(this);
            } else {
                serverwaypointmanager.c(this);
            }
        }
        super.a(holder);
    }

    public static Optional<RespawnPosAngle> a(WorldServer worldserver, RespawnConfig entityplayer_respawnconfig, boolean flag) {
        WorldData.a worlddata_a = entityplayer_respawnconfig.b;
        BlockPosition blockposition = worlddata_a.b();
        float f2 = worlddata_a.d();
        float f1 = worlddata_a.e();
        boolean flag1 = entityplayer_respawnconfig.c;
        IBlockData iblockdata = worldserver.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (flag1 || iblockdata.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(worldserver)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bX, worldserver, blockposition);
            if (!flag1 && flag && optional.isPresent()) {
                worldserver.a(blockposition, (IBlockData)iblockdata.b(BlockRespawnAnchor.d, iblockdata.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, 0.0f, false, true));
        }
        if (block instanceof BlockBed && BlockBed.a(worldserver)) {
            return BlockBed.a(EntityTypes.bX, (ICollisionAccess)worldserver, blockposition, (EnumDirection)iblockdata.c(BlockBed.f), f2).map(vec3d -> RespawnPosAngle.of(vec3d, blockposition, 0.0f, true, false));
        }
        if (!flag1) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = worldserver.a_(blockposition.d());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3D((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.1, (double)blockposition.w() + 0.5), f2, f1, false, false)) : Optional.empty();
    }

    public void p() {
        this.av();
        this.A().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    @Nullable
    public EntityPlayer a(TeleportTransition teleporttransition) {
        if (this.gg()) {
            return null;
        }
        if (this.ec()) {
            return null;
        }
        if (teleporttransition.g()) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer worldserver = teleporttransition.b();
        WorldServer worldserver1 = this.A();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(absolutePosition.a(), (World)worldserver.getWorld(), absolutePosition.c(), absolutePosition.d());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, teleporttransition.cause());
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            worldserver = ((CraftWorld)newExit.getWorld()).getHandle();
            teleporttransition = new TeleportTransition(worldserver, CraftLocation.toVec3D(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleporttransition.g(), teleporttransition.h(), Set.of(), teleporttransition.j(), teleporttransition.cause());
        }
        if (!teleporttransition.h()) {
            this.ad();
        }
        if (worldserver != null && worldserver.al() == worldserver1.al()) {
            this.g.internalTeleport(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
            this.g.l();
            teleporttransition.j().onTransition(this);
            return this;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("moving");
        if (worldserver != null && resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
            this.dm = this.dD();
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("placing");
        this.de = true;
        WorldData worlddata = worldserver.F_();
        this.g.b(new PacketPlayOutRespawn(this.b(worldserver), 3));
        this.g.b(new PacketPlayOutServerDifficulty(worlddata.p(), worlddata.q()));
        PlayerList playerlist = this.cK.am();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.ee();
        this.a(worldserver);
        this.g.internalTeleport(PositionMoveRotation.a(teleporttransition), teleporttransition.i());
        this.g.l();
        worldserver.d(this);
        gameprofilerfiller.c();
        this.h(worldserver1);
        this.fU();
        this.g.b(new PacketPlayOutAbilities(this.gC()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        playerlist.c(this);
        teleporttransition.j().onTransition(this);
        this.cY = -1;
        this.cV = -1.0f;
        this.cW = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.A().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        this.a(teleporttransition, worldserver1);
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void a(float f2, boolean flag, float f1, boolean flag1) {
        super.a(f2, flag, f1, flag1);
        this.g.b(new ClientboundPlayerRotationPacket(f2, flag, f1, flag1));
    }

    public void h(WorldServer worldserver) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = worldserver.al();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.A().al();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(worldserver);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.A());
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.w.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.dm != null) {
            CriterionTriggers.D.a(this, this.dm);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.dm = null;
        }
    }

    @Override
    public boolean a(EntityPlayer entityplayer) {
        return entityplayer.at() ? this.N() == this : (this.at() ? false : super.a(entityplayer));
    }

    @Override
    public void a(Entity entity, int i2) {
        super.a(entity, i2);
        this.cl.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.gg() && this.bX()) {
            if (!this.A().H_().j() || !this.A().H_().l()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.a));
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.c));
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.d));
            }
            this.setRespawnPosition(new RespawnConfig(WorldData.a.a(this.A().al(), blockposition, this.dX(), this.dZ()), false), true, PlayerSpawnChangeEvent.Cause.BED);
            if (this.A().aa()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.b));
            }
            if (!this.gQ()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.A().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.a(this.A(), this));
                if (!list.isEmpty()) {
                    return Either.left((Object)((Object)EntityHuman.EnumBedResult.f));
                }
            }
            return Either.right((Object)((Object)Unit.a));
        }
        return Either.left((Object)((Object)EntityHuman.EnumBedResult.e));
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.A().a_(blockposition).c(BlockFacingHorizontal.f);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right((Object)((Object)Unit.a));
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.aq);
            CriterionTriggers.r.a(this);
        });
        if (!this.A().e()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        this.A().f();
        return either;
    }

    @Override
    public void b(BlockPosition blockposition) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(blockposition);
    }

    private boolean a(BlockPosition blockposition, EnumDirection enumdirection) {
        return this.i(blockposition) || this.i(blockposition.a(enumdirection.g()));
    }

    private boolean i(BlockPosition blockposition) {
        Vec3D vec3d = Vec3D.c(blockposition);
        return Math.abs(this.dK() - vec3d.a()) <= 3.0 && Math.abs(this.dM() - vec3d.b()) <= 2.0 && Math.abs(this.dQ() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.d();
        return !this.h(blockposition1) || !this.h(blockposition1.a(enumdirection.g()));
    }

    @Override
    public void a(boolean flag, boolean flag1) {
        if (!this.gg()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.ge().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.A().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.A().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.A().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.gg()) {
            this.A().n().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(flag, flag1);
        if (this.g != null) {
            this.g.teleport(this.dK(), this.dM(), this.dQ(), this.dX(), this.dZ(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return super.a(worldserver, damagesource) || this.S() && !damagesource.a(DamageTypes.m) || !this.hb();
    }

    @Override
    protected void b(WorldServer worldserver, BlockPosition blockposition) {
        if (!this.at()) {
            super.b(worldserver, blockposition);
        }
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.du && flag && this.an > 0.0) {
            Vec3D vec3d = blockposition.b().b(0.0, 0.5, 0.0);
            int i2 = (int)MathHelper.a(50.0 * this.an, 0.0, 200.0);
            this.A().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.g, vec3d.h, vec3d.i, i2, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            this.du = false;
        }
        super.a(d0, flag, iblockdata, blockposition);
    }

    @Override
    public void a(@Nullable Entity entity) {
        super.a(entity);
        this.cy = this.dD();
        this.cz = entity;
        this.x(entity != null && entity.ax() == EntityTypes.bM);
    }

    @Override
    protected void q() {
        if (this.A().w().i()) {
            super.q();
        }
    }

    @Override
    public void a(TileEntitySign tileentitysign, boolean flag) {
        this.g.b(new PacketPlayOutBlockChange(this.A(), tileentitysign.aD_()));
        this.g.b(new PacketPlayOutOpenSignEditor(tileentitysign.aD_(), flag));
    }

    @Override
    public void b(Holder<Dialog> holder) {
        this.g.b(new ClientboundShowDialogPacket(holder));
    }

    public int nextContainerCounter() {
        this.dI = this.dI % 100 + 1;
        return this.dI;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        if (itileinventory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = itileinventory.createMenu(this.dI, this.gB(), this);
        if (container != null) {
            container.setTitle(itileinventory.S_());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (itileinventory instanceof IInventory) {
                    ((IInventory)((Object)itileinventory)).b(this);
                } else if (itileinventory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)itileinventory).inventorylargechest.b(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.at()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cl = container;
        this.g.b(new PacketPlayOutOpenWindow(container.l, container.a(), container.getTitle()));
        this.a(container);
        return OptionalInt.of(this.dI);
    }

    @Override
    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
        this.g.b(new PacketPlayOutOpenWindowMerchant(i2, merchantrecipelist, j2, k2, flag, flag1));
    }

    @Override
    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dI, this.gB(), iinventory, entityhorseabstract, entityhorseabstract.ad_());
        container.setTitle(entityhorseabstract.S_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            iinventory.b(this);
            return;
        }
        if (this.cl != this.ck) {
            this.r();
        }
        int i2 = entityhorseabstract.ad_();
        this.g.b(new PacketPlayOutOpenWindowHorse(this.dI, i2, entityhorseabstract.az()));
        this.cl = container;
        this.a(this.cl);
    }

    @Override
    public void a(ItemStack itemstack, EnumHand enumhand) {
        if (itemstack.c(DataComponents.V)) {
            if (WrittenBookContent.a(itemstack, this.C(), this)) {
                this.cl.d();
            }
            this.g.b(new PacketPlayOutOpenBook(enumhand));
        }
    }

    @Override
    public void a(TileEntityCommand tileentitycommand) {
        this.g.b(PacketPlayOutTileEntityData.a(tileentitycommand, TileEntity::d));
    }

    @Override
    public void r() {
        CraftEventFactory.handleInventoryCloseEvent(this);
        this.g.b(new PacketPlayOutCloseWindow(this.cl.l));
        this.s();
    }

    @Override
    public void s() {
        this.cl.a(this);
        this.ck.a(this.cl);
        this.cl = this.ck;
    }

    @Override
    public void t() {
        double d0 = this.dK();
        double d1 = this.dM();
        double d2 = this.dQ();
        super.t();
        this.p(this.dK() - d0, this.dM() - d1, this.dQ() - d2);
    }

    public void a(double d0, double d1, double d2) {
        if (!this.cl() && !EntityPlayer.q(d0, d1, d2)) {
            if (this.cw()) {
                int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.D, i2);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((Entity)this).a(TagsFluid.a)) {
                int j2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                if (j2 > 0) {
                    this.a(StatisticList.w, j2);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)j2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bu()) {
                int k2 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (k2 > 0) {
                    this.a(StatisticList.s, k2);
                    this.causeFoodExhaustion(this.A().spigotConfig.swimMultiplier * (float)k2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.fe()) {
                if (d1 > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(d1 * 100.0));
                }
            } else if (this.aS()) {
                int l2 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (l2 > 0) {
                    if (this.cv()) {
                        this.a(StatisticList.r, l2);
                        this.causeFoodExhaustion(this.A().spigotConfig.sprintMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.cu()) {
                        this.a(StatisticList.q, l2);
                        this.causeFoodExhaustion(this.A().spigotConfig.otherMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, l2);
                        this.causeFoodExhaustion(this.A().spigotConfig.otherMultiplier * (float)l2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fY()) {
                int i1 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
                this.a(StatisticList.C, i1);
            } else {
                int j1 = Math.round((float)Math.sqrt(d0 * d0 + d2 * d2) * 100.0f);
                if (j1 > 25) {
                    this.a(StatisticList.v, j1);
                }
            }
        }
    }

    private void p(double d0, double d1, double d2) {
        if (this.cl() && !EntityPlayer.q(d0, d1, d2)) {
            int i2 = Math.round((float)Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2) * 100.0f);
            Entity entity = this.du();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof AbstractBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.B, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.E, i2);
            } else if (entity instanceof HappyGhast) {
                this.a(StatisticList.A, i2);
            }
        }
    }

    private static boolean q(double d0, double d1, double d2) {
        return d0 == 0.0 && d1 == 0.0 && d2 == 0.0;
    }

    @Override
    public void a(Statistic<?> statistic, int i2) {
        this.cM.b(this, statistic, i2);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, scoreaccess -> scoreaccess.b(i2));
    }

    @Override
    public void a(Statistic<?> statistic) {
        this.cM.a(this, statistic, 0);
        this.A().getCraftServer().getScoreboardManager().forAllObjectives(statistic, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> collection) {
        return this.df.a(collection, this);
    }

    @Override
    public void a(RecipeHolder<?> recipeholder, List<ItemStack> list) {
        CriterionTriggers.ad.a(this, recipeholder.a(), list);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> list) {
        List<RecipeHolder<?>> list1 = list.stream().flatMap(resourcekey -> this.cK.aN().b((ResourceKey<IRecipe<?>>)resourcekey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list1);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> collection) {
        return this.df.b(collection, this);
    }

    @Override
    public void u() {
        super.u();
        this.a(StatisticList.F);
        if (this.cv()) {
            this.causeFoodExhaustion(this.A().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.A().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int i2) {
        super.d(i2);
        this.cY = -1;
    }

    public void v() {
        this.di = true;
        this.ca();
        if (this.gg()) {
            this.a(true, false);
        }
    }

    public boolean w() {
        return this.di;
    }

    public void x() {
        this.cV = -1.0E8f;
        this.cY = -1;
    }

    @Override
    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.b(ichatbasecomponent, flag);
    }

    @Override
    protected void R_() {
        if (!this.bS.f() && this.fO()) {
            this.g.b(new PacketPlayOutEntityStatus(this, 9));
            super.R_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Vec3D vec3d) {
        super.a(argumentanchor_anchor, vec3d);
        this.g.b(new PacketPlayOutLookAt(argumentanchor_anchor, vec3d.g, vec3d.h, vec3d.i));
    }

    public void a(ArgumentAnchor.Anchor argumentanchor_anchor, Entity entity, ArgumentAnchor.Anchor argumentanchor_anchor1) {
        Vec3D vec3d = argumentanchor_anchor1.a(entity);
        super.a(argumentanchor_anchor, vec3d);
        this.g.b(new PacketPlayOutLookAt(argumentanchor_anchor, entity, argumentanchor_anchor1));
    }

    public void a(EntityPlayer entityplayer, boolean flag) {
        this.dv = entityplayer.dv;
        this.dF = entityplayer.dF;
        this.h.a(entityplayer.h.b(), entityplayer.h.c());
        this.z();
        if (flag) {
            this.fp().b(entityplayer.fp());
            this.x(entityplayer.eU());
            this.cm = entityplayer.cm;
            for (MobEffect mobEffect : entityplayer.eR()) {
            }
            this.gB().a(entityplayer.gB());
            this.cr = entityplayer.cr;
            this.cs = entityplayer.cs;
            this.ct = entityplayer.ct;
            this.q(entityplayer.gu());
            this.aG = entityplayer.aG;
        } else {
            this.fp().b(entityplayer.fp());
            if (this.A().S().c(GameRules.e) || entityplayer.at()) {
                this.gB().a(entityplayer.gB());
                this.cr = entityplayer.cr;
                this.cs = entityplayer.cs;
                this.ct = entityplayer.ct;
                this.q(entityplayer.gu());
            }
        }
        this.cu = entityplayer.cu;
        this.cj = entityplayer.cj;
        this.aC().a(t, (Byte)entityplayer.aC().a(t));
        this.cY = -1;
        this.cV = -1.0f;
        this.cW = -1;
        this.i = entityplayer.i;
        this.dm = entityplayer.dm;
        this.dp = entityplayer.dp;
        this.dH = entityplayer.dH;
        this.b(entityplayer.ak());
        this.c(entityplayer.al());
        this.d(entityplayer.gZ());
    }

    @Override
    protected void a(MobEffect mobeffect, @Nullable Entity entity) {
        super.a(mobeffect, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.az(), mobeffect, true));
        if (mobeffect.a(MobEffects.y)) {
            this.dh = this.at;
            this.dg = this.dD();
        }
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void a(MobEffect mobeffect, boolean flag, @Nullable Entity entity) {
        super.a(mobeffect, flag, entity);
        this.g.b(new PacketPlayOutEntityEffect(this.az(), mobeffect, false));
        CriterionTriggers.B.a(this, entity);
    }

    @Override
    protected void c(Collection<MobEffect> collection) {
        super.c(collection);
        for (MobEffect mobeffect : collection) {
            this.g.b(new PacketPlayOutRemoveEntityEffect(this.az(), mobeffect.c()));
            if (!mobeffect.a(MobEffects.y)) continue;
            this.dg = null;
        }
        CriterionTriggers.B.a(this, (Entity)null);
    }

    @Override
    public void b(double d0, double d1, double d2) {
        this.g.a(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k));
    }

    @Override
    public void c(double d0, double d1, double d2) {
        this.g.a(new PositionMoveRotation(new Vec3D(d0, d1, d2), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag1;
        if (this.gg()) {
            this.a(true, true);
        }
        if (flag) {
            this.d((Entity)this);
        }
        if (flag1 = super.teleportTo(worldserver, d0, d1, d2, set, f2, f1, flag, cause)) {
            this.r(set.contains((Object)Relative.d) ? this.cN() + f2 : f2);
        }
        return flag1;
    }

    @Override
    public void d(double d0, double d1, double d2) {
        super.d(d0, d1, d2);
        this.g.l();
    }

    @Override
    public void b(Entity entity) {
        this.A().n().a(this, new PacketPlayOutAnimation(entity, 4));
    }

    @Override
    public void c(Entity entity) {
        this.A().n().a(this, new PacketPlayOutAnimation(entity, 5));
    }

    @Override
    public void z() {
        if (this.g != null) {
            this.g.b(new PacketPlayOutAbilities(this.gC()));
            this.M();
        }
    }

    public WorldServer A() {
        return (WorldServer)super.an();
    }

    public boolean a(EnumGamemode enumgamemode) {
        boolean flag = this.at();
        if (!this.h.a(enumgamemode)) {
            return false;
        }
        this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, enumgamemode.a()));
        if (enumgamemode == EnumGamemode.d) {
            this.k();
            this.cb();
            EnchantmentManager.a(this);
        } else {
            this.d((Entity)this);
            if (flag) {
                EnchantmentManager.a(this.A(), (EntityLiving)this);
            }
        }
        this.z();
        this.fN();
        return true;
    }

    @Override
    @Nonnull
    public EnumGamemode a() {
        return this.h.b();
    }

    public ICommandListener B() {
        return this.dG;
    }

    public CommandListenerWrapper C() {
        return new CommandListenerWrapper(this.B(), this.dD(), this.cg(), this.A(), this.I(), this.ap(), this.S_(), this.cK, this);
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        this.b(ichatbasecomponent, false);
    }

    public void b(IChatBaseComponent ichatbasecomponent, boolean flag) {
        if (this.y(flag)) {
            this.g.a(new ClientboundSystemChatPacket(ichatbasecomponent, flag), PacketSendListener.a(() -> {
                if (this.y(false)) {
                    int i2 = 256;
                    String s2 = ichatbasecomponent.a(256);
                    IChatMutableComponent ichatbasecomponent1 = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatbasecomponent1).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage outgoingchatmessage, boolean flag, ChatMessageType.a chatmessagetype_a) {
        if (this.ho()) {
            outgoingchatmessage.a(this, flag, chatmessagetype_a);
        }
    }

    public String D() {
        SocketAddress socketaddress = this.g.m();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void a(ClientInformation clientinformation) {
        PlayerChangedMainHandEvent event;
        if (this.as() != clientinformation.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.as() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.cK.server.getPluginManager().callEvent((Event)event);
        }
        if (!this.dk.equals(clientinformation.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientinformation.b());
            this.cK.server.getPluginManager().callEvent((Event)event);
        }
        this.dk = clientinformation.b();
        this.dj = clientinformation.c();
        this.cZ = clientinformation.d();
        this.db = clientinformation.e();
        this.ds = clientinformation.h();
        this.dt = clientinformation.i();
        this.da = clientinformation.j();
        this.aC().a(t, (byte)clientinformation.f());
        this.aC().a(s, (byte)clientinformation.g().b());
    }

    public ClientInformation E() {
        byte i2 = (Byte)this.aC().a(t);
        EnumMainHand enummainhand = EnumMainHand.d.apply(((Byte)this.aC().a(s)).byteValue());
        return new ClientInformation(this.dk, this.dj, this.cZ, this.db, i2, enummainhand, this.ds, this.dt, this.da);
    }

    public boolean F() {
        return this.db;
    }

    public EnumChatVisibility G() {
        return this.cZ;
    }

    private boolean y(boolean flag) {
        return this.cZ == EnumChatVisibility.c ? flag : true;
    }

    private boolean ho() {
        return this.cZ == EnumChatVisibility.a;
    }

    public int H() {
        return this.dj;
    }

    public void a(ServerPing serverping) {
        this.g.b(new ClientboundServerDataPacket(serverping.a(), serverping.d().map(ServerPing.a::a)));
    }

    @Override
    public int I() {
        return this.cK.b(this.gA());
    }

    public void J() {
        this.dc = SystemUtils.c();
    }

    public ServerStatisticManager K() {
        return this.cM;
    }

    public RecipeBookServer L() {
        return this.df;
    }

    @Override
    protected void M() {
        if (this.at()) {
            this.eP();
            this.l(true);
        } else {
            super.M();
        }
    }

    public Entity N() {
        return this.dd == null ? this : this.dd;
    }

    public void d(@Nullable Entity entity) {
        Entity entity1 = this.N();
        Entity entity2 = this.dd = entity == null ? this : entity;
        if (entity1 != this.dd) {
            WorldServer worldserver;
            boolean result;
            net.minecraft.world.level.World world = this.dd.an();
            if (world instanceof WorldServer && !(result = this.teleportTo(worldserver = (WorldServer)world, this.dd.dK(), this.dd.dM(), this.dd.dQ(), Set.of(), this.dX(), this.dZ(), false, PlayerTeleportEvent.TeleportCause.SPECTATE))) {
                this.dd = entity1;
                return;
            }
            if (entity != null) {
                this.A().n().a(this);
            }
            this.g.b(new PacketPlayOutCamera(this.dd));
            this.g.l();
        }
    }

    @Override
    protected void O() {
        if (!this.de) {
            super.O();
        }
    }

    @Override
    public void e(Entity entity) {
        if (this.at()) {
            this.d(entity);
        } else {
            super.e(entity);
        }
    }

    public long P() {
        return this.dc;
    }

    @Nullable
    public IChatBaseComponent Q() {
        return this.listName;
    }

    public int R() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand enumhand) {
        super.a(enumhand);
        this.gV();
    }

    public boolean S() {
        return this.de;
    }

    public void T() {
        this.de = false;
    }

    public AdvancementDataPlayer U() {
        return this.cL;
    }

    @Nullable
    public RespawnConfig V() {
        return this.dq;
    }

    public void b(EntityPlayer entityplayer) {
        this.a(entityplayer.dq, false);
    }

    public void a(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag) {
        this.setRespawnPosition(entityplayer_respawnconfig, flag, PlayerSpawnChangeEvent.Cause.UNKNOWN);
    }

    public void setRespawnPosition(@Nullable RespawnConfig entityplayer_respawnconfig, boolean flag, PlayerSpawnChangeEvent.Cause cause) {
        Location newSpawn = null;
        boolean forced = false;
        if (entityplayer_respawnconfig != null) {
            WorldData.a respawnData = entityplayer_respawnconfig.a();
            WorldServer newWorld = this.cK.a(respawnData.a());
            newSpawn = CraftLocation.toBukkit(respawnData.b(), (World)newWorld.getWorld(), respawnData.d(), respawnData.e());
            forced = entityplayer_respawnconfig.b();
        }
        PlayerSpawnChangeEvent event = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), newSpawn, forced, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        newSpawn = event.getNewSpawn();
        entityplayer_respawnconfig = newSpawn != null ? new RespawnConfig(WorldData.a.a(((CraftWorld)newSpawn.getWorld()).getHandle().al(), BlockPosition.a(newSpawn.getX(), newSpawn.getY(), newSpawn.getZ()), newSpawn.getYaw(), newSpawn.getPitch()), event.isForced()) : null;
        if (flag && entityplayer_respawnconfig != null && !entityplayer_respawnconfig.a(this.dq)) {
            this.a(cG);
        }
        this.dq = entityplayer_respawnconfig;
    }

    public SectionPosition W() {
        return this.do;
    }

    public void a(SectionPosition sectionposition) {
        this.do = sectionposition;
    }

    public ChunkTrackingView X() {
        return this.dp;
    }

    public void a(ChunkTrackingView chunktrackingview) {
        this.dp = chunktrackingview;
    }

    @Override
    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
        this.g.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(soundeffect), soundcategory, this.dK(), this.dM(), this.dQ(), f2, f1, this.as.g()));
    }

    @Override
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        EntityItem entityitem = super.drop(itemstack, flag, flag1, callEvent);
        if (flag1) {
            ItemStack itemstack1;
            ItemStack itemStack = itemstack1 = entityitem != null ? entityitem.e() : ItemStack.l;
            if (!itemstack1.f()) {
                this.a(StatisticList.f.b(itemstack1.h()), itemstack.M());
                this.a(StatisticList.G);
            }
        }
        return entityitem;
    }

    public ITextFilter Y() {
        return this.dr;
    }

    public void a(WorldServer worldserver) {
        this.a((net.minecraft.world.level.World)worldserver);
        this.h.a(worldserver);
    }

    @Nullable
    private static EnumGamemode a(ValueInput valueinput, String s2) {
        return valueinput.a(s2, EnumGamemode.h).orElse(null);
    }

    private EnumGamemode b(@Nullable EnumGamemode enumgamemode) {
        EnumGamemode enumgamemode1 = this.cK.bj();
        return enumgamemode1 != null ? enumgamemode1 : (enumgamemode != null ? enumgamemode : this.cK.y());
    }

    private void g(ValueOutput valueoutput) {
        valueoutput.a("playerGameType", EnumGamemode.h, this.h.b());
        EnumGamemode enumgamemode = this.h.c();
        valueoutput.b("previousPlayerGameType", EnumGamemode.h, enumgamemode);
    }

    @Override
    public boolean Z() {
        return this.ds;
    }

    public boolean c(EntityPlayer entityplayer) {
        return entityplayer == this ? false : this.ds || entityplayer.ds;
    }

    @Override
    public boolean c(WorldServer worldserver, BlockPosition blockposition) {
        return super.c(worldserver, blockposition) && worldserver.a((Entity)this, blockposition);
    }

    @Override
    protected void a(ItemStack itemstack) {
        CriterionTriggers.X.a(this, itemstack);
        super.a(itemstack);
    }

    public boolean a(boolean flag) {
        PlayerInventory playerinventory = this.gB();
        ItemStack itemstack = playerinventory.a(flag);
        this.cl.b(playerinventory, playerinventory.g()).ifPresent(i2 -> this.cl.a(i2, playerinventory.h()));
        return this.a(itemstack, false, true) != null;
    }

    @Override
    public void b(ItemStack itemstack) {
        if (!this.gB().g(itemstack)) {
            this.a(itemstack, false);
        }
    }

    public boolean aa() {
        return this.dt;
    }

    @Override
    public Optional<WardenSpawnTracker> ab() {
        return Optional.of(this.dv);
    }

    public void b(boolean flag) {
        this.du = flag;
    }

    @Override
    public void a(EntityItem entityitem) {
        super.a(entityitem);
        Entity entity = entityitem.ai_();
        if (entity != null) {
            CriterionTriggers.S.a(this, entityitem.e(), entity);
        }
    }

    public void a(RemoteChatSession remotechatsession) {
        this.dF = remotechatsession;
    }

    @Nullable
    public RemoteChatSession ac() {
        return this.dF != null && this.dF.b() ? null : this.dF;
    }

    @Override
    public void a(double d0, double d1) {
        this.cx = (float)(MathHelper.d(d1, d0) * 57.2957763671875 - (double)this.dX());
        this.g.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(Entity entity, boolean flag, boolean flag1) {
        if (super.a(entity, flag, flag1)) {
            entity.k(this);
            this.g.a(new PositionMoveRotation(this.dD(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.cK.am().a(entityliving, this.g);
            }
            this.g.b(new PacketPlayOutMount(entity));
            return true;
        }
        return false;
    }

    @Override
    public void ad() {
        Entity entity = this.du();
        super.ad();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eR()) {
                this.g.b(new PacketPlayOutRemoveEntityEffect(entity.az(), mobeffect.c()));
            }
        }
        if (entity != null) {
            this.g.b(new PacketPlayOutMount(entity));
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer worldserver) {
        return new CommonPlayerSpawnInfo(worldserver.ak(), worldserver.al(), BiomeManager.a(worldserver.H()), this.h.b(), this.h.c(), worldserver.am(), worldserver.G(), this.gZ(), this.aK(), worldserver.T());
    }

    public void c(BlockPosition blockposition) {
        this.dw = blockposition;
    }

    public void ae() {
        this.dw = null;
    }

    @Nullable
    public BlockPosition af() {
        return this.dw;
    }

    @Override
    public Vec3D ag() {
        Entity entity = this.du();
        return entity != null && entity.dg() != this ? entity.ag() : this.dx;
    }

    public void a(Vec3D vec3d) {
        this.dx = vec3d;
    }

    @Override
    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return EnchantmentManager.a(this.A(), this.el(), entity, damagesource, f2);
    }

    @Override
    public void a(Item item, EnumItemSlot enumitemslot) {
        super.a(item, enumitemslot);
        this.b(StatisticList.d.b(item));
    }

    public Input ah() {
        return this.dy;
    }

    public void a(Input input) {
        this.dy = input;
    }

    public Vec3D ai() {
        float f2;
        float f3 = this.dy.c() == this.dy.d() ? 0.0f : (f2 = this.dy.c() ? 1.0f : -1.0f);
        float f1 = this.dy.a() == this.dy.b() ? 0.0f : (this.dy.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.dX());
    }

    public void a(EntityEnderPearl entityenderpearl) {
        this.dz.add(entityenderpearl);
    }

    public void b(EntityEnderPearl entityenderpearl) {
        this.dz.remove(entityenderpearl);
    }

    public Set<EntityEnderPearl> aj() {
        return this.dz;
    }

    public NBTTagCompound ak() {
        return this.dB;
    }

    public void b(NBTTagCompound nbttagcompound) {
        this.dB = nbttagcompound;
        this.b(EntityPlayer.d(nbttagcompound));
    }

    public NBTTagCompound al() {
        return this.dC;
    }

    public void c(NBTTagCompound nbttagcompound) {
        this.dC = nbttagcompound;
        this.c(EntityPlayer.d(nbttagcompound));
    }

    public long c(EntityEnderPearl entityenderpearl) {
        net.minecraft.world.level.World world = entityenderpearl.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ChunkCoordIntPair chunkcoordintpair = entityenderpearl.dH();
            this.a(entityenderpearl);
            worldserver.j();
            return EntityPlayer.a(worldserver, chunkcoordintpair) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer worldserver, ChunkCoordIntPair chunkcoordintpair) {
        worldserver.n().b(TicketType.n, chunkcoordintpair, 2);
        return TicketType.n.g();
    }

    public void a(Set<DebugSubscription<?>> set) {
        this.dH = Set.copyOf(set);
    }

    public Set<DebugSubscription<?>> am() {
        return !this.cK.bA().a(this) ? Set.of() : this.dH;
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.A().ah() + this.timeOffset;
        }
        return this.A().ah() - this.A().ah() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.A().F_().h() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cV() + " at " + this.dK() + "," + this.dM() + "," + this.dQ() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.g.l();
    }

    @Override
    public boolean fv() {
        return super.fv() || !this.getBukkitEntity().isOnline();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.ct;
            this.newTotalExp = this.cs;
            this.newLevel = this.cr;
        }
        this.x(this.fj());
        this.fU();
        this.h(0);
        this.an = 0.0;
        this.cm = new FoodMetaData();
        this.cr = this.newLevel;
        this.cs = this.newTotalExp;
        this.ct = 0.0f;
        this.bv = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.co = true;
        this.cl = this.ck;
        this.bG = null;
        this.cp = null;
        this.ck = new CombatTracker(this);
        this.cY = -1;
        if (this.keepLevel) {
            this.ct = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.m(0.0, 0.0, 0.0);
        this.cC = 0;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public static final class RespawnConfig
    extends Record {
        private final WorldData.a b;
        private final boolean c;
        public static final Codec<RespawnConfig> a = RecordCodecBuilder.create(instance -> instance.group((App)WorldData.a.b.forGetter(RespawnConfig::a), (App)Codec.BOOL.optionalFieldOf("forced", (Object)false).forGetter(RespawnConfig::b)).apply((Applicative)instance, RespawnConfig::new));

        public RespawnConfig(WorldData.a respawnData, boolean forced) {
            this.b = respawnData;
            this.c = forced;
        }

        static ResourceKey<net.minecraft.world.level.World> b(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null ? entityplayer_respawnconfig.a().a() : net.minecraft.world.level.World.h;
        }

        public boolean a(@Nullable RespawnConfig entityplayer_respawnconfig) {
            return entityplayer_respawnconfig != null && this.b.c().equals(entityplayer_respawnconfig.b.c());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnConfig.class, "respawnData;forced", "b", "c"}, this, o2);
        }

        public WorldData.a a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }
    }

    public record RespawnPosAngle(Vec3D a, float b, float c, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D vec3d, BlockPosition blockposition, float f2, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.a(vec3d, blockposition), f2, isBedSpawn, isAnchorSpawn);
        }

        private static float a(Vec3D vec3d, BlockPosition blockposition) {
            Vec3D vec3d1 = Vec3D.c(blockposition).d(vec3d).d();
            return (float)MathHelper.e(MathHelper.d(vec3d1.i, vec3d1.g) * 57.2957763671875 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn", "a", "b", "c", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn", "a", "b", "c", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;pitch;isBedSpawn;isAnchorSpawn", "a", "b", "c", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }

    public static final class c
    extends Record {
        private final Optional<ResourceKey<net.minecraft.world.level.World>> c;
        private final Optional<Vec3D> d;
        private final Optional<Vec2F> e;
        public static final MapCodec<c> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)net.minecraft.world.level.World.g.optionalFieldOf(EntityPlayer.f).forGetter(c::a), (App)Vec3D.a.optionalFieldOf("Pos").forGetter(c::b), (App)Vec2F.i.optionalFieldOf("Rotation").forGetter(c::c)).apply((Applicative)instance, c::new));
        public static final c b = new c(Optional.empty(), Optional.empty(), Optional.empty());

        public c(Optional<ResourceKey<net.minecraft.world.level.World>> dimension, Optional<Vec3D> position, Optional<Vec2F> rotation) {
            this.c = dimension;
            this.d = position;
            this.e = rotation;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimension;position;rotation", "c", "d", "e"}, this, o2);
        }

        public Optional<ResourceKey<net.minecraft.world.level.World>> a() {
            return this.c;
        }

        public Optional<Vec3D> b() {
            return this.d;
        }

        public Optional<Vec2F> c() {
            return this.e;
        }
    }
}

