/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;

@FunctionalInterface
public interface ResourceProvider {
    public static final ResourceProvider b = var0 -> Optional.empty();

    public Optional<IResource> getResource(MinecraftKey var1);

    default public IResource getResourceOrThrow(MinecraftKey var0) throws FileNotFoundException {
        return this.getResource(var0).orElseThrow(() -> new FileNotFoundException(var0.toString()));
    }

    default public InputStream open(MinecraftKey var0) throws IOException {
        return this.getResourceOrThrow(var0).d();
    }

    default public BufferedReader openAsReader(MinecraftKey var0) throws IOException {
        return this.getResourceOrThrow(var0).e();
    }

    public static ResourceProvider fromMap(Map<MinecraftKey, IResource> var0) {
        return var1 -> Optional.ofNullable((IResource)var0.get(var1));
    }
}

