/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatisticManager
extends StatisticManager {
    private static final Logger b = LogUtils.getLogger();
    private static final Codec<Map<Statistic<?>, Integer>> c = Codec.dispatchedMap(BuiltInRegistries.w.q(), SystemUtils.b(ServerStatisticManager::a)).xmap(map -> {
        HashMap map1 = new HashMap();
        map.forEach((statisticwrapper, map2) -> map1.putAll(map2));
        return map1;
    }, map -> map.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Statistic)entry.getKey()).a(), SystemUtils.a())));
    private final MinecraftServer d;
    private final File e;
    private final Set<Statistic<?>> f = Sets.newHashSet();

    private static <T> Codec<Map<Statistic<T>, Integer>> a(StatisticWrapper<T> statisticwrapper) {
        Codec<T> codec = statisticwrapper.b().q();
        Objects.requireNonNull(statisticwrapper);
        Codec codec1 = codec.flatComapMap(statisticwrapper::b, statistic -> statistic.a() == statisticwrapper ? DataResult.success(statistic.b()) : DataResult.error(() -> {
            String s2 = String.valueOf(statisticwrapper);
            return "Expected type " + s2 + ", but got " + String.valueOf(statistic.a());
        }));
        return Codec.unboundedMap((Codec)codec1, (Codec)Codec.INT);
    }

    public ServerStatisticManager(MinecraftServer minecraftserver, File file) {
        this.d = minecraftserver;
        this.e = file;
        for (Map.Entry<MinecraftKey, Integer> entry : SpigotConfig.forcedStats.entrySet()) {
            Statistic<MinecraftKey> wrapper = StatisticList.i.b(entry.getKey());
            this.a.put(wrapper, entry.getValue().intValue());
        }
        if (file.isFile()) {
            try {
                this.a(minecraftserver.aE(), FileUtils.readFileToString((File)file));
            }
            catch (IOException ioexception) {
                b.error("Couldn't read statistics file {}", (Object)file, (Object)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                b.error("Couldn't parse statistics file {}", (Object)file, (Object)jsonparseexception);
            }
        }
    }

    public void a() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.e, (String)this.b());
        }
        catch (IOException ioexception) {
            b.error("Couldn't save stats", (Throwable)ioexception);
        }
    }

    @Override
    public void a(EntityHuman entityhuman, Statistic<?> statistic, int i2) {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        super.a(entityhuman, statistic, i2);
        this.f.add(statistic);
    }

    private Set<Statistic<?>> d() {
        HashSet set = Sets.newHashSet(this.f);
        this.f.clear();
        return set;
    }

    public void a(DataFixer datafixer, String s2) {
        try {
            JsonElement jsonelement = StrictJsonParser.a(s2);
            if (jsonelement.isJsonNull()) {
                b.error("Unable to parse Stat data from {}", (Object)this.e);
                return;
            }
            Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
            dynamic = DataFixTypes.h.a(datafixer, dynamic, GameProfileSerializer.b(dynamic, 1343));
            this.a.putAll(c.parse(dynamic.get("stats").orElseEmptyMap()).resultOrPartial(s1 -> b.error("Failed to parse statistics for {}: {}", (Object)this.e, s1)).orElse(Map.of()));
        }
        catch (JsonParseException jsonparseexception) {
            b.error("Unable to parse Stat data from {}", (Object)this.e, (Object)jsonparseexception);
        }
    }

    protected String b() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("stats", (JsonElement)c.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.a).getOrThrow());
        jsonobject.addProperty("DataVersion", (Number)SharedConstants.b().a().b());
        return jsonobject.toString();
    }

    public void c() {
        this.f.addAll((Collection<Statistic<?>>)this.a.keySet());
    }

    public void a(EntityPlayer entityplayer) {
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (Statistic<?> statistic : this.d()) {
            object2intmap.put(statistic, this.a(statistic));
        }
        entityplayer.g.b(new PacketPlayOutStatistic((Object2IntMap<Statistic<?>>)object2intmap));
    }
}

