/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final int e = 5;
    private static final DataWatcherObject<Float> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> h = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float i = 32.0f;
    private static final int j = 0;
    private static final int k = 0;
    private static final float l = 0.0f;
    private static final float m = 0.0f;
    private static final float n = 1.0f;
    private static final float o = 0.5f;
    private static final float p = 3.0f;
    public static final float a = 6.0f;
    public static final float b = 0.5f;
    public static final int c = -1;
    public static final int d = 600;
    private static final int q = 20;
    private static final int r = 20;
    private static final ColorParticleOption s = ColorParticleOption.a(Particles.v, -1);
    @Nullable
    private ParticleParam t;
    public PotionContents u = PotionContents.a;
    private float aN = 1.0f;
    private final Map<Entity, Integer> aO = Maps.newHashMap();
    private int aP = -1;
    public int aQ = 20;
    public int aR = 20;
    public int aS = 0;
    public float aT = 0.0f;
    public float aU = 0.0f;
    @Nullable
    private EntityReference<EntityLiving> aV;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> entitytypes, World world) {
        super(entitytypes, world);
        this.ar = true;
    }

    public EntityAreaEffectCloud(World world, double d0, double d1, double d2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.f, world);
        this.a_(d0, d1, d2);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(f, Float.valueOf(3.0f));
        datawatcher_a.a(g, false);
        datawatcher_a.a(h, s);
    }

    public void a(float f2) {
        if (!this.an().D_()) {
            this.aC().a(f, Float.valueOf(MathHelper.a(f2, 0.0f, 32.0f)));
        }
    }

    @Override
    public void l_() {
        double d0 = this.dK();
        double d1 = this.dM();
        double d2 = this.dQ();
        super.l_();
        this.a_(d0, d1, d2);
    }

    public float c() {
        return this.aC().a(f).floatValue();
    }

    public void a(PotionContents potioncontents) {
        this.u = potioncontents;
        this.q();
    }

    public void a(@Nullable ParticleParam particleparam) {
        this.t = particleparam;
        this.q();
    }

    public void b(float f2) {
        this.aN = f2;
    }

    public void q() {
        if (this.t != null) {
            this.az.a(h, this.t);
        } else {
            int i2 = ARGB.f(this.u.b());
            this.az.a(h, ColorParticleOption.a(s.a(), i2));
        }
    }

    public void a(MobEffect mobeffect) {
        this.a(this.u.a(mobeffect));
    }

    public ParticleParam e() {
        return this.aC().a(h);
    }

    protected void a(boolean flag) {
        this.aC().a(g, flag);
    }

    public boolean f() {
        return this.aC().a(g);
    }

    public int h() {
        return this.aP;
    }

    public void a(int i2) {
        this.aP = i2;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.at >= this.aQ + this.aP) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void g() {
        super.g();
        World world = this.an();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver);
        } else {
            this.r();
        }
    }

    private void r() {
        boolean flag = this.f();
        float f2 = this.c();
        if (!flag || !this.as.h()) {
            float f1;
            int i2;
            ParticleParam particleparam = this.e();
            if (flag) {
                i2 = 2;
                f1 = 0.2f;
            } else {
                i2 = MathHelper.f((float)Math.PI * f2 * f2);
                f1 = f2;
            }
            for (int j2 = 0; j2 < i2; ++j2) {
                float f22 = this.as.i() * ((float)Math.PI * 2);
                float f3 = MathHelper.c(this.as.i()) * f1;
                double d0 = this.dK() + (double)(MathHelper.b(f22) * f3);
                double d1 = this.dM();
                double d2 = this.dQ() + (double)(MathHelper.a(f22) * f3);
                if (particleparam.a() == Particles.v) {
                    if (flag && this.as.h()) {
                        this.an().b(s, d0, d1, d2, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.an().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                if (flag) {
                    this.an().b(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                this.an().b(particleparam, d0, d1, d2, (0.5 - this.as.j()) * 0.15, 0.01f, (0.5 - this.as.j()) * 0.15);
            }
        }
    }

    private void a(WorldServer worldserver) {
        if (this.aP != -1 && this.at - this.aQ >= this.aP) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag1;
            boolean flag = this.f();
            boolean bl = flag1 = this.at < this.aQ;
            if (flag != flag1) {
                this.a(flag1);
            }
            if (!flag1) {
                float f2 = this.c();
                if (this.aU != 0.0f) {
                    if ((f2 += this.aU) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(f2);
                }
                if (this.at % 5 == 0) {
                    this.aO.entrySet().removeIf(entry -> this.at >= (Integer)entry.getValue());
                    if (!this.u.c()) {
                        this.aO.clear();
                    } else {
                        ArrayList list = new ArrayList();
                        PotionContents potioncontents = this.u;
                        Objects.requireNonNull(list);
                        potioncontents.a(list::add, this.aN);
                        List<EntityLiving> list1 = this.an().a(EntityLiving.class, this.de());
                        if (!list1.isEmpty()) {
                            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
                            for (EntityLiving entityliving : list1) {
                                double d1;
                                double d0;
                                double d2;
                                if (this.aO.containsKey(entityliving) || !entityliving.ga()) continue;
                                Stream stream = list.stream();
                                Objects.requireNonNull(entityliving);
                                if (stream.noneMatch(entityliving::b) || !((d2 = (d0 = entityliving.dK() - this.dK()) * d0 + (d1 = entityliving.dQ() - this.dQ()) * d1) <= (double)(f2 * f2))) continue;
                                entities.add((LivingEntity)entityliving.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    EntityLiving entityliving = ((CraftLivingEntity)entity).getHandle();
                                    this.aO.put(entityliving, this.at + this.aR);
                                    for (MobEffect mobeffect : list) {
                                        if (mobeffect.c().a().a()) {
                                            mobeffect.c().a().a(worldserver, this, this.n(), entityliving, mobeffect.e(), 0.5);
                                            continue;
                                        }
                                        entityliving.addEffect(new MobEffect(mobeffect), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.aT != 0.0f) {
                                        if ((f2 += this.aT) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.a(f2);
                                    }
                                    if (this.aS == 0 || this.aP == -1) continue;
                                    this.aP += this.aS;
                                    if (this.aP > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float i() {
        return this.aT;
    }

    public void c(float f2) {
        this.aT = f2;
    }

    public float j() {
        return this.aU;
    }

    public void d(float f2) {
        this.aU = f2;
    }

    public int k() {
        return this.aS;
    }

    public void b(int i2) {
        this.aS = i2;
    }

    public int m() {
        return this.aQ;
    }

    public void c(int i2) {
        this.aQ = i2;
    }

    public void a(@Nullable EntityLiving entityliving) {
        this.aV = EntityReference.a(entityliving);
    }

    @Nullable
    public EntityLiving n() {
        return EntityReference.b(this.aV, this.an());
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.at = valueinput.a("Age", 0);
        this.aP = valueinput.a("Duration", -1);
        this.aQ = valueinput.a("WaitTime", 20);
        this.aR = valueinput.a("ReapplicationDelay", 20);
        this.aS = valueinput.a("DurationOnUse", 0);
        this.aT = valueinput.a("RadiusOnUse", 0.0f);
        this.aU = valueinput.a("RadiusPerTick", 0.0f);
        this.a(valueinput.a("Radius", 3.0f));
        this.aV = EntityReference.a(valueinput, "Owner");
        this.a((ParticleParam)valueinput.a("custom_particle", Particles.bl).orElse(null));
        this.a(valueinput.a("potion_contents", PotionContents.c).orElse(PotionContents.a));
        this.aN = valueinput.a("potion_duration_scale", 1.0f);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        valueoutput.a("Age", this.at);
        valueoutput.a("Duration", this.aP);
        valueoutput.a("WaitTime", this.aQ);
        valueoutput.a("ReapplicationDelay", this.aR);
        valueoutput.a("DurationOnUse", this.aS);
        valueoutput.a("RadiusOnUse", this.aT);
        valueoutput.a("RadiusPerTick", this.aU);
        valueoutput.a("Radius", this.c());
        valueoutput.b("custom_particle", Particles.bl, this.t);
        EntityReference.a(this.aV, valueoutput, "Owner");
        if (!this.u.equals(PotionContents.a)) {
            valueoutput.a("potion_contents", PotionContents.c, this.u);
        }
        if (this.aN != 1.0f) {
            valueoutput.a("potion_duration_scale", this.aN);
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (f.equals(datawatcherobject)) {
            this.l_();
        }
        super.a(datawatcherobject);
    }

    @Override
    public EnumPistonReaction p_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose entitypose) {
        return EntitySize.b(this.c() * 2.0f, 0.5f);
    }

    @Override
    public final boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        return false;
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.R ? EntityAreaEffectCloud.c(datacomponenttype, this.u) : (datacomponenttype == DataComponents.S ? EntityAreaEffectCloud.c(datacomponenttype, Float.valueOf(this.aN)) : super.a(datacomponenttype));
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.R);
        this.a(datacomponentgetter, DataComponents.S);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.R) {
            this.a(EntityAreaEffectCloud.c(DataComponents.R, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.S) {
            this.b(EntityAreaEffectCloud.c(DataComponents.S, t0).floatValue());
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

