/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicLike;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.slf4j.Logger;

public class GameRules {
    public static final int a = 3;
    static final Logger aj = LogUtils.getLogger();
    private static final Map<GameRuleKey<?>, GameRuleDefinition<?>> ak = Maps.newTreeMap(Comparator.comparing(gamerules_gamerulekey -> gamerules_gamerulekey.a));
    public static final GameRuleKey<GameRuleBoolean> b = GameRules.a("doFireTick", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> c = GameRules.a("allowFireTicksAwayFromPlayer", GameRuleCategory.e, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> d = GameRules.a("mobGriefing", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> e = GameRules.a("keepInventory", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> f = GameRules.a("doMobSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> g = GameRules.a("doMobLoot", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> h = GameRules.a("projectilesCanBreakBlocks", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> i = GameRules.a("doTileDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> j = GameRules.a("doEntityDrops", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> k = GameRules.a("commandBlockOutput", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> l = GameRules.a("naturalRegeneration", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> m = GameRules.a("doDaylightCycle", GameRuleCategory.e, GameRuleBoolean.a(!SharedConstants.aU));
    public static final GameRuleKey<GameRuleBoolean> n = GameRules.a("logAdminCommands", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> o = GameRules.a("showDeathMessages", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> p = GameRules.a("randomTickSpeed", GameRuleCategory.e, GameRuleInt.a(3));
    public static final GameRuleKey<GameRuleBoolean> q = GameRules.a("sendCommandFeedback", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> r = GameRules.a("reducedDebugInfo", GameRuleCategory.g, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        byte b0 = (byte)(gamerules_gameruleboolean.a() ? 22 : 23);
        for (EntityPlayer entityplayer : minecraftserver.C()) {
            entityplayer.g.b(new PacketPlayOutEntityStatus(entityplayer, b0));
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> s = GameRules.a("spectatorsGenerateChunks", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> t = GameRules.a("spawnRadius", GameRuleCategory.a, GameRuleInt.a(10));
    public static final GameRuleKey<GameRuleBoolean> u = GameRules.a("disablePlayerMovementCheck", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> v = GameRules.a("disableElytraMovementCheck", GameRuleCategory.a, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> w = GameRules.a("maxEntityCramming", GameRuleCategory.b, GameRuleInt.a(24));
    public static final GameRuleKey<GameRuleBoolean> x = GameRules.a("doWeatherCycle", GameRuleCategory.e, GameRuleBoolean.a(!SharedConstants.aU));
    public static final GameRuleKey<GameRuleBoolean> y = GameRules.a("doLimitedCrafting", GameRuleCategory.a, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (EntityPlayer entityplayer : minecraftserver.C()) {
            entityplayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.n, gamerules_gameruleboolean.a() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> z = GameRules.a("maxCommandChainLength", GameRuleCategory.g, GameRuleInt.a(65536));
    public static final GameRuleKey<GameRuleInt> A = GameRules.a("maxCommandForkCount", GameRuleCategory.g, GameRuleInt.a(65536));
    public static final GameRuleKey<GameRuleInt> B = GameRules.a("commandModificationBlockLimit", GameRuleCategory.g, GameRuleInt.a(32768));
    public static final GameRuleKey<GameRuleBoolean> C = GameRules.a("announceAdvancements", GameRuleCategory.f, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> D = GameRules.a("disableRaids", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> E = GameRules.a("doInsomnia", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> F = GameRules.a("doImmediateRespawn", GameRuleCategory.a, GameRuleBoolean.a(false, (minecraftserver, gamerules_gameruleboolean) -> {
        for (EntityPlayer entityplayer : minecraftserver.C()) {
            entityplayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, gamerules_gameruleboolean.a() ? 1.0f : 0.0f));
        }
    }));
    public static final GameRuleKey<GameRuleInt> G = GameRules.a("playersNetherPortalDefaultDelay", GameRuleCategory.a, GameRuleInt.a(80));
    public static final GameRuleKey<GameRuleInt> H = GameRules.a("playersNetherPortalCreativeDelay", GameRuleCategory.a, GameRuleInt.a(0));
    public static final GameRuleKey<GameRuleBoolean> I = GameRules.a("drowningDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> J = GameRules.a("fallDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> K = GameRules.a("fireDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> L = GameRules.a("freezeDamage", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> M = GameRules.a("doPatrolSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> N = GameRules.a("doTraderSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> O = GameRules.a("doWardenSpawning", GameRuleCategory.c, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> P = GameRules.a("forgiveDeadPlayers", GameRuleCategory.b, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> Q = GameRules.a("universalAnger", GameRuleCategory.b, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> R = GameRules.a("playersSleepingPercentage", GameRuleCategory.a, GameRuleInt.a(100));
    public static final GameRuleKey<GameRuleBoolean> S = GameRules.a("blockExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> T = GameRules.a("mobExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> U = GameRules.a("tntExplosionDropDecay", GameRuleCategory.d, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleInt> V = GameRules.a("snowAccumulationHeight", GameRuleCategory.e, GameRuleInt.a(1));
    public static final GameRuleKey<GameRuleBoolean> W = GameRules.a("waterSourceConversion", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> X = GameRules.a("lavaSourceConversion", GameRuleCategory.e, GameRuleBoolean.a(false));
    public static final GameRuleKey<GameRuleBoolean> Y = GameRules.a("globalSoundEvents", GameRuleCategory.g, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> Z = GameRules.a("doVinesSpread", GameRuleCategory.e, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> aa = GameRules.a("enderPearlsVanishOnDeath", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleInt> ab = GameRules.a("minecartMaxSpeed", GameRuleCategory.g, GameRuleInt.a(8, 1, 1000, FeatureFlagSet.a(FeatureFlags.d), (minecraftserver, gamerules_gameruleint) -> {}));
    public static final GameRuleKey<GameRuleBoolean> ac = GameRules.a("tntExplodes", GameRuleCategory.g, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> ad = GameRules.a("locatorBar", GameRuleCategory.a, GameRuleBoolean.a(true, (worldserver, gamerules_gameruleboolean) -> {
        ServerWaypointManager serverwaypointmanager = worldserver.h();
        if (gamerules_gameruleboolean.a()) {
            List<EntityPlayer> list = worldserver.C();
            Objects.requireNonNull(serverwaypointmanager);
            list.forEach(serverwaypointmanager::b);
        } else {
            serverwaypointmanager.a();
        }
    }));
    public static final GameRuleKey<GameRuleBoolean> ae = GameRules.a("pvp", GameRuleCategory.a, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> af = GameRules.a("allowEnteringNetherUsingPortals", GameRuleCategory.g, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> ag = GameRules.a("spawnMonsters", GameRuleCategory.c, GameRuleBoolean.a(true, (minecraftserver, gamerules_gameruleboolean) -> minecraftserver.b(MinecraftServer.isSpawningMonsters(minecraftserver))));
    public static final GameRuleKey<GameRuleBoolean> ah = GameRules.a("commandBlocksEnabled", GameRuleCategory.g, GameRuleBoolean.a(true));
    public static final GameRuleKey<GameRuleBoolean> ai = GameRules.a("spawnerBlocksEnabled", GameRuleCategory.g, GameRuleBoolean.a(true));
    private final Map<GameRuleKey<?>, GameRuleValue<?>> al;
    private final FeatureFlagSet am;

    public static <T extends GameRuleValue<T>> GameRuleDefinition<T> a(GameRuleKey<T> gamerules_gamerulekey) {
        return ak.get(gamerules_gamerulekey);
    }

    public static <T extends GameRuleValue<T>> Codec<GameRuleKey<T>> a(Class<T> oclass) {
        return Codec.STRING.comapFlatMap(s2 -> ak.entrySet().stream().filter(entry -> ((GameRuleDefinition)entry.getValue()).e == oclass).map(Map.Entry::getKey).filter(gamerules_gamerulekey -> gamerules_gamerulekey.a().equals(s2)).map(gamerules_gamerulekey -> gamerules_gamerulekey).findFirst().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Invalid game rule ID for type: " + s2)), GameRuleKey::a);
    }

    private static <T extends GameRuleValue<T>> GameRuleKey<T> a(String s2, GameRuleCategory gamerules_gamerulecategory, GameRuleDefinition<T> gamerules_gameruledefinition) {
        GameRuleKey gamerules_gamerulekey = new GameRuleKey(s2, gamerules_gamerulecategory);
        GameRuleDefinition<T> gamerules_gameruledefinition1 = ak.put(gamerules_gamerulekey, gamerules_gameruledefinition);
        if (gamerules_gameruledefinition1 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + s2);
        }
        return gamerules_gamerulekey;
    }

    public GameRules(FeatureFlagSet featureflagset, DynamicLike<?> dynamiclike) {
        this(featureflagset);
        this.a(dynamiclike);
    }

    public GameRules(FeatureFlagSet featureflagset) {
        this((Map)GameRules.a(featureflagset).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((GameRuleDefinition)entry.getValue()).a())), featureflagset);
    }

    public static Stream<Map.Entry<GameRuleKey<?>, GameRuleDefinition<?>>> a(FeatureFlagSet featureflagset) {
        return ak.entrySet().stream().filter(entry -> ((GameRuleDefinition)entry.getValue()).f.a(featureflagset));
    }

    private GameRules(Map<GameRuleKey<?>, GameRuleValue<?>> map, FeatureFlagSet featureflagset) {
        this.al = map;
        this.am = featureflagset;
    }

    public <T extends GameRuleValue<T>> T b(GameRuleKey<T> gamerules_gamerulekey) {
        GameRuleValue<?> t0 = this.al.get(gamerules_gamerulekey);
        if (t0 == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return (T)t0;
    }

    public NBTTagCompound a() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.al.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> nbttagcompound.a(gamerules_gamerulekey.a, gamerules_gamerulevalue.b()));
        return nbttagcompound;
    }

    private void a(DynamicLike<?> dynamiclike) {
        this.al.forEach((gamerules_gamerulekey, gamerules_gamerulevalue) -> {
            DataResult dataresult = dynamiclike.get(gamerules_gamerulekey.a).asString();
            Objects.requireNonNull(gamerules_gamerulevalue);
            dataresult.ifSuccess(gamerules_gamerulevalue::a);
        });
    }

    public GameRules b(FeatureFlagSet featureflagset) {
        return new GameRules((Map)GameRules.a(featureflagset).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.al.containsKey(entry.getKey()) ? this.al.get(entry.getKey()).f() : ((GameRuleDefinition)entry.getValue()).a())), featureflagset);
    }

    public void a(GameRuleVisitor gamerules_gamerulevisitor) {
        ak.forEach((gamerules_gamerulekey, gamerules_gameruledefinition) -> this.a(gamerules_gamerulevisitor, (GameRuleKey<?>)gamerules_gamerulekey, (GameRuleDefinition<?>)gamerules_gameruledefinition));
    }

    private <T extends GameRuleValue<T>> void a(GameRuleVisitor gamerules_gamerulevisitor, GameRuleKey<?> gamerules_gamerulekey, GameRuleDefinition<?> gamerules_gameruledefinition) {
        if (gamerules_gameruledefinition.f.a(this.am)) {
            gamerules_gamerulevisitor.a(gamerules_gamerulekey, gamerules_gameruledefinition);
            gamerules_gameruledefinition.a(gamerules_gamerulevisitor, gamerules_gamerulekey);
        }
    }

    public void assignFrom(GameRules gamerules, @Nullable WorldServer minecraftserver) {
        gamerules.al.keySet().forEach(gamerules_gamerulekey -> this.assignCap((GameRuleKey)gamerules_gamerulekey, gamerules, minecraftserver));
    }

    private <T extends GameRuleValue<T>> void assignCap(GameRuleKey<T> gamerules_gamerulekey, GameRules gamerules, @Nullable WorldServer minecraftserver) {
        T t0 = gamerules.b(gamerules_gamerulekey);
        ((GameRuleValue)this.b(gamerules_gamerulekey)).setFrom(t0, minecraftserver);
    }

    public boolean c(GameRuleKey<GameRuleBoolean> gamerules_gamerulekey) {
        return this.b(gamerules_gamerulekey).a();
    }

    public int d(GameRuleKey<GameRuleInt> gamerules_gamerulekey) {
        return this.b(gamerules_gamerulekey).a();
    }

    public static class GameRuleDefinition<T extends GameRuleValue<T>> {
        final Supplier<ArgumentType<?>> a;
        private final Function<GameRuleDefinition<T>, T> b;
        final BiConsumer<WorldServer, T> c;
        private final h<T> d;
        final Class<T> e;
        final FeatureFlagSet f;

        GameRuleDefinition(Supplier<ArgumentType<?>> supplier, Function<GameRuleDefinition<T>, T> function, BiConsumer<WorldServer, T> biconsumer, h<T> gamerules_h, Class<T> oclass, FeatureFlagSet featureflagset) {
            this.a = supplier;
            this.b = function;
            this.c = biconsumer;
            this.d = gamerules_h;
            this.e = oclass;
            this.f = featureflagset;
        }

        public RequiredArgumentBuilder<CommandListenerWrapper, ?> a(String s2) {
            return CommandDispatcher.a(s2, this.a.get());
        }

        public T a() {
            return (T)((GameRuleValue)this.b.apply(this));
        }

        public void a(GameRuleVisitor gamerules_gamerulevisitor, GameRuleKey<T> gamerules_gamerulekey) {
            this.d.call(gamerules_gamerulevisitor, gamerules_gamerulekey, this);
        }

        public FeatureFlagSet b() {
            return this.f;
        }
    }

    public static final class GameRuleKey<T extends GameRuleValue<T>> {
        final String a;
        private final GameRuleCategory b;

        public GameRuleKey(String s2, GameRuleCategory gamerules_gamerulecategory) {
            this.a = s2;
            this.b = gamerules_gamerulecategory;
        }

        public String toString() {
            return this.a;
        }

        public boolean equals(Object object) {
            return this == object ? true : object instanceof GameRuleKey && ((GameRuleKey)object).a.equals(this.a);
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public String a() {
            return this.a;
        }

        public String b() {
            return "gamerule." + this.a;
        }

        public GameRuleCategory c() {
            return this.b;
        }
    }

    public static enum GameRuleCategory {
        a("gamerule.category.player"),
        b("gamerule.category.mobs"),
        c("gamerule.category.spawning"),
        d("gamerule.category.drops"),
        e("gamerule.category.updates"),
        f("gamerule.category.chat"),
        g("gamerule.category.misc");

        private final String h;

        private GameRuleCategory(String s2) {
            this.h = s2;
        }

        public String a() {
            return this.h;
        }
    }

    public static abstract class GameRuleValue<T extends GameRuleValue<T>> {
        protected final GameRuleDefinition<T> a;

        public GameRuleValue(GameRuleDefinition<T> gamerules_gameruledefinition) {
            this.a = gamerules_gameruledefinition;
        }

        protected abstract void a(CommandContext<CommandListenerWrapper> var1, String var2);

        public void b(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.a(commandcontext, s2);
            this.onChanged(((CommandListenerWrapper)commandcontext.getSource()).e());
        }

        public void onChanged(@Nullable WorldServer minecraftserver) {
            if (minecraftserver != null) {
                this.a.c.accept(minecraftserver, (WorldServer)this.g());
            }
        }

        public abstract void a(String var1);

        public abstract String b();

        public String toString() {
            return this.b();
        }

        public abstract int c();

        protected abstract T g();

        protected abstract T f();

        public abstract void setFrom(T var1, @Nullable WorldServer var2);
    }

    public static interface GameRuleVisitor {
        default public <T extends GameRuleValue<T>> void a(GameRuleKey<T> gamerules_gamerulekey, GameRuleDefinition<T> gamerules_gameruledefinition) {
        }

        default public void b(GameRuleKey<GameRuleBoolean> gamerules_gamerulekey, GameRuleDefinition<GameRuleBoolean> gamerules_gameruledefinition) {
        }

        default public void c(GameRuleKey<GameRuleInt> gamerules_gamerulekey, GameRuleDefinition<GameRuleInt> gamerules_gameruledefinition) {
        }
    }

    public static class GameRuleBoolean
    extends GameRuleValue<GameRuleBoolean> {
        private boolean b;

        private static GameRuleDefinition<GameRuleBoolean> a(boolean flag, BiConsumer<WorldServer, GameRuleBoolean> biconsumer, FeatureFlagSet featureflagset) {
            return new GameRuleDefinition<GameRuleBoolean>(BoolArgumentType::bool, gamerules_gameruledefinition -> new GameRuleBoolean((GameRuleDefinition<GameRuleBoolean>)gamerules_gameruledefinition, flag), biconsumer, GameRuleVisitor::b, GameRuleBoolean.class, featureflagset);
        }

        static GameRuleDefinition<GameRuleBoolean> a(boolean flag, BiConsumer<WorldServer, GameRuleBoolean> biconsumer) {
            return new GameRuleDefinition<GameRuleBoolean>(BoolArgumentType::bool, gamerules_gameruledefinition -> new GameRuleBoolean((GameRuleDefinition<GameRuleBoolean>)gamerules_gameruledefinition, flag), biconsumer, GameRuleVisitor::b, GameRuleBoolean.class, FeatureFlagSet.a());
        }

        public static GameRuleDefinition<GameRuleBoolean> a(boolean flag) {
            return GameRuleBoolean.a(flag, (minecraftserver, gamerules_gameruleboolean) -> {});
        }

        public GameRuleBoolean(GameRuleDefinition<GameRuleBoolean> gamerules_gameruledefinition, boolean flag) {
            super(gamerules_gameruledefinition);
            this.b = flag;
        }

        @Override
        protected void a(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.b = BoolArgumentType.getBool(commandcontext, (String)s2);
        }

        public boolean a() {
            return this.b;
        }

        public void set(boolean flag, @Nullable WorldServer minecraftserver) {
            this.b = flag;
            this.onChanged(minecraftserver);
        }

        @Override
        public String b() {
            return Boolean.toString(this.b);
        }

        @Override
        public void a(String s2) {
            this.b = Boolean.parseBoolean(s2);
        }

        @Override
        public int c() {
            return this.b ? 1 : 0;
        }

        protected GameRuleBoolean d() {
            return this;
        }

        protected GameRuleBoolean e() {
            return new GameRuleBoolean(this.a, this.b);
        }

        @Override
        public void setFrom(GameRuleBoolean gamerules_gameruleboolean, @Nullable WorldServer minecraftserver) {
            this.b = gamerules_gameruleboolean.b;
            this.onChanged(minecraftserver);
        }
    }

    public static class GameRuleInt
    extends GameRuleValue<GameRuleInt> {
        private int b;

        private static GameRuleDefinition<GameRuleInt> a(int i2, BiConsumer<WorldServer, GameRuleInt> biconsumer) {
            return new GameRuleDefinition<GameRuleInt>(IntegerArgumentType::integer, gamerules_gameruledefinition -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)gamerules_gameruledefinition, i2), biconsumer, GameRuleVisitor::c, GameRuleInt.class, FeatureFlagSet.a());
        }

        static GameRuleDefinition<GameRuleInt> a(int i2, int j2, int k2, FeatureFlagSet featureflagset, BiConsumer<WorldServer, GameRuleInt> biconsumer) {
            return new GameRuleDefinition<GameRuleInt>(() -> IntegerArgumentType.integer((int)j2, (int)k2), gamerules_gameruledefinition -> new GameRuleInt((GameRuleDefinition<GameRuleInt>)gamerules_gameruledefinition, i2), biconsumer, GameRuleVisitor::c, GameRuleInt.class, featureflagset);
        }

        public static GameRuleDefinition<GameRuleInt> a(int i2) {
            return GameRuleInt.a(i2, (minecraftserver, gamerules_gameruleint) -> {});
        }

        public GameRuleInt(GameRuleDefinition<GameRuleInt> gamerules_gameruledefinition, int i2) {
            super(gamerules_gameruledefinition);
            this.b = i2;
        }

        @Override
        protected void a(CommandContext<CommandListenerWrapper> commandcontext, String s2) {
            this.b = IntegerArgumentType.getInteger(commandcontext, (String)s2);
        }

        public int a() {
            return this.b;
        }

        public void set(int i2, @Nullable WorldServer minecraftserver) {
            this.b = i2;
            this.onChanged(minecraftserver);
        }

        @Override
        public String b() {
            return Integer.toString(this.b);
        }

        @Override
        public void a(String s2) {
            this.b = GameRuleInt.c(s2);
        }

        public boolean b(String s2) {
            try {
                StringReader stringreader = new StringReader(s2);
                this.b = (Integer)this.a.a.get().parse(stringreader);
                return !stringreader.canRead();
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        }

        private static int c(String s2) {
            if (!s2.isEmpty()) {
                try {
                    return Integer.parseInt(s2);
                }
                catch (NumberFormatException numberformatexception) {
                    aj.warn("Failed to parse integer {}", (Object)s2);
                }
            }
            return 0;
        }

        @Override
        public int c() {
            return this.b;
        }

        protected GameRuleInt d() {
            return this;
        }

        protected GameRuleInt e() {
            return new GameRuleInt(this.a, this.b);
        }

        @Override
        public void setFrom(GameRuleInt gamerules_gameruleint, @Nullable WorldServer minecraftserver) {
            this.b = gamerules_gameruleint.b;
            this.onChanged(minecraftserver);
        }
    }

    private static interface h<T extends GameRuleValue<T>> {
        public void call(GameRuleVisitor var1, GameRuleKey<T> var2, GameRuleDefinition<T> var3);
    }
}

