/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public abstract class MobSpawnerAbstract {
    private static final Logger a = LogUtils.getLogger();
    public static final String b = "SpawnData";
    private static final int c = 1;
    private static final int d = 20;
    private static final int e = 200;
    private static final int f = 800;
    private static final int g = 4;
    private static final int h = 6;
    private static final int i = 16;
    private static final int j = 4;
    public int k = 20;
    public WeightedList<MobSpawnerData> l = WeightedList.a();
    @Nullable
    public MobSpawnerData m;
    private double n;
    private double o;
    public int p = 200;
    public int q = 800;
    public int r = 4;
    @Nullable
    private Entity s;
    public int t = 6;
    public int u = 16;
    public int v = 4;

    public void a(EntityTypes<?> entitytypes, @Nullable World world, RandomSource randomsource, BlockPosition blockposition) {
        this.a(world, randomsource, blockposition).a().a("id", BuiltInRegistries.g.b(entitytypes).toString());
        this.l = WeightedList.a();
    }

    private boolean c(World world, BlockPosition blockposition) {
        return world.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, (double)this.u);
    }

    public void a(World world, BlockPosition blockposition) {
        if (!this.c(world, blockposition)) {
            this.o = this.n;
        } else if (this.s != null) {
            RandomSource randomsource = world.I_();
            double d0 = (double)blockposition.u() + randomsource.j();
            double d1 = (double)blockposition.v() + randomsource.j();
            double d2 = (double)blockposition.w() + randomsource.j();
            world.a(Particles.ai, d0, d1, d2, 0.0, 0.0, 0.0);
            world.a(Particles.G, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.k > 0) {
                --this.k;
            }
            this.o = this.n;
            this.n = (this.n + (double)(1000.0f / ((float)this.k + 200.0f))) % 360.0;
        }
    }

    public void a(WorldServer worldserver, BlockPosition blockposition) {
        if (this.c(worldserver, blockposition) && worldserver.q().r()) {
            if (this.k == -1) {
                this.d(worldserver, blockposition);
            }
            if (this.k > 0) {
                --this.k;
            } else {
                boolean flag = false;
                RandomSource randomsource = worldserver.I_();
                MobSpawnerData mobspawnerdata = this.a((World)worldserver, randomsource, blockposition);
                for (int i2 = 0; i2 < this.r; ++i2) {
                    try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(this::toString, a);){
                        ValueInput valueinput = TagValueInput.a((ProblemReporter)problemreporter_j, (HolderLookup.a)worldserver.L_(), mobspawnerdata.a());
                        Optional<EntityTypes<?>> optional = EntityTypes.a(valueinput);
                        if (optional.isEmpty()) {
                            this.d(worldserver, blockposition);
                            return;
                        }
                        Vec3D vec3d = valueinput.a("Pos", Vec3D.a).orElseGet(() -> new Vec3D((double)blockposition.u() + (randomsource.j() - randomsource.j()) * (double)this.v + 0.5, blockposition.v() + randomsource.a(3) - 1, (double)blockposition.w() + (randomsource.j() - randomsource.j()) * (double)this.v + 0.5));
                        if (!worldserver.b(optional.get().a(vec3d.g, vec3d.h, vec3d.i))) continue;
                        BlockPosition blockposition1 = BlockPosition.a(vec3d);
                        if (mobspawnerdata.b().isPresent()) {
                            MobSpawnerData.a mobspawnerdata_a;
                            if (!optional.get().f().d() && worldserver.aq() == EnumDifficulty.a || !(mobspawnerdata_a = mobspawnerdata.b().get()).a(blockposition1, worldserver)) continue;
                        } else if (!EntityPositionTypes.a(optional.get(), worldserver, EntitySpawnReason.c, blockposition1, worldserver.I_())) continue;
                        Entity entity = EntityTypes.a(valueinput, (World)worldserver, EntitySpawnReason.c, entity1 -> {
                            entity1.b(vec3d.g, vec3d.h, vec3d.i, entity1.dX(), entity1.dZ());
                            return entity1;
                        });
                        if (entity == null) {
                            this.d(worldserver, blockposition);
                            return;
                        }
                        int j2 = worldserver.a(EntityTypeTest.b(entity.getClass()), new AxisAlignedBB(blockposition.u(), blockposition.v(), blockposition.w(), blockposition.u() + 1, blockposition.v() + 1, blockposition.w() + 1).g(this.v), IEntitySelector.f).size();
                        if (j2 >= this.t) {
                            this.d(worldserver, blockposition);
                            return;
                        }
                        entity.b(entity.dK(), entity.dM(), entity.dQ(), randomsource.i() * 360.0f, 0.0f);
                        if (entity instanceof EntityInsentient) {
                            boolean flag1;
                            EntityInsentient entityinsentient = (EntityInsentient)entity;
                            if (mobspawnerdata.b().isEmpty() && !entityinsentient.a((GeneratorAccess)worldserver, EntitySpawnReason.c) || !entityinsentient.a((IWorldReader)worldserver)) continue;
                            boolean bl = flag1 = mobspawnerdata.a().i() == 1 && mobspawnerdata.a().i("id").isPresent();
                            if (flag1) {
                                ((EntityInsentient)entity).a((WorldAccess)worldserver, worldserver.d_(entity.dF()), EntitySpawnReason.c, (GroupDataEntity)null);
                            }
                            Optional<EquipmentTable> optional1 = mobspawnerdata.c();
                            Objects.requireNonNull(entityinsentient);
                            optional1.ifPresent(entityinsentient::a);
                            if (entityinsentient.an().spigotConfig.nerfSpawnerMobs) {
                                entityinsentient.aware = false;
                            }
                        }
                        if (CraftEventFactory.callSpawnerSpawnEvent(entity, blockposition).isCancelled()) continue;
                        if (!worldserver.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.SPAWNER)) {
                            this.d(worldserver, blockposition);
                            return;
                        }
                        worldserver.c(2004, blockposition, 0);
                        worldserver.a(entity, GameEvent.t, blockposition1);
                        if (entity instanceof EntityInsentient) {
                            ((EntityInsentient)entity).Y();
                        }
                        flag = true;
                        continue;
                    }
                }
                if (flag) {
                    this.d(worldserver, blockposition);
                }
            }
        }
    }

    private void d(World world, BlockPosition blockposition) {
        RandomSource randomsource = world.z;
        this.k = this.q <= this.p ? this.p : this.p + randomsource.a(this.q - this.p);
        this.l.a(randomsource).ifPresent(mobspawnerdata -> this.a(world, blockposition, (MobSpawnerData)mobspawnerdata));
        this.a(world, blockposition, 1);
    }

    public void a(@Nullable World world, BlockPosition blockposition, ValueInput valueinput) {
        this.k = valueinput.a("Delay", (short)20);
        valueinput.a(b, MobSpawnerData.b).ifPresent(mobspawnerdata -> this.a(world, blockposition, (MobSpawnerData)mobspawnerdata));
        this.l = valueinput.a("SpawnPotentials", MobSpawnerData.c).orElseGet(() -> WeightedList.a(this.m != null ? this.m : new MobSpawnerData()));
        this.p = valueinput.a("MinSpawnDelay", 200);
        this.q = valueinput.a("MaxSpawnDelay", 800);
        this.r = valueinput.a("SpawnCount", 4);
        this.t = valueinput.a("MaxNearbyEntities", 6);
        this.u = valueinput.a("RequiredPlayerRange", 16);
        this.v = valueinput.a("SpawnRange", 4);
        this.s = null;
    }

    public void a(ValueOutput valueoutput) {
        valueoutput.a("Delay", (short)this.k);
        valueoutput.a("MinSpawnDelay", (short)this.p);
        valueoutput.a("MaxSpawnDelay", (short)this.q);
        valueoutput.a("SpawnCount", (short)this.r);
        valueoutput.a("MaxNearbyEntities", (short)this.t);
        valueoutput.a("RequiredPlayerRange", (short)this.u);
        valueoutput.a("SpawnRange", (short)this.v);
        valueoutput.b(b, MobSpawnerData.b, this.m);
        valueoutput.a("SpawnPotentials", MobSpawnerData.c, this.l);
    }

    @Nullable
    public Entity b(World world, BlockPosition blockposition) {
        if (this.s == null) {
            NBTTagCompound nbttagcompound = this.a(world, world.I_(), blockposition).a();
            if (nbttagcompound.i("id").isEmpty()) {
                return null;
            }
            this.s = EntityTypes.a(nbttagcompound, world, EntitySpawnReason.c, Function.identity());
            if (nbttagcompound.i() != 1 || this.s instanceof EntityInsentient) {
                // empty if block
            }
        }
        return this.s;
    }

    public boolean a(World world, int i2) {
        if (i2 == 1) {
            if (world.D_()) {
                this.k = this.p;
            }
            return true;
        }
        return false;
    }

    protected void a(@Nullable World world, BlockPosition blockposition, MobSpawnerData mobspawnerdata) {
        this.m = mobspawnerdata;
    }

    private MobSpawnerData a(@Nullable World world, RandomSource randomsource, BlockPosition blockposition) {
        if (this.m != null) {
            return this.m;
        }
        this.a(world, blockposition, this.l.a(randomsource).orElseGet(MobSpawnerData::new));
        return this.m;
    }

    public abstract void a(World var1, BlockPosition var2, int var3);

    public double a() {
        return this.n;
    }

    public double b() {
        return this.o;
    }
}

