/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;

public class BlockCrops
extends VegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockCrops> d = BlockCrops.b(BlockCrops::new);
    public static final int e = 7;
    public static final BlockStateInteger f = BlockProperties.az;
    private static final VoxelShape[] a = Block.a(7, (int i2) -> Block.b(16.0, 0.0, 2 + i2 * 2));

    public MapCodec<? extends BlockCrops> a() {
        return d;
    }

    protected BlockCrops(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)this.C.b()).b(this.b(), 0));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return a[this.i(iblockdata)];
    }

    @Override
    protected boolean b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.a(Blocks.cZ);
    }

    protected BlockStateInteger b() {
        return f;
    }

    public int c() {
        return 7;
    }

    public int i(IBlockData iblockdata) {
        return iblockdata.c(this.b());
    }

    public IBlockData b(int i2) {
        return (IBlockData)this.m().b(this.b(), i2);
    }

    public final boolean n(IBlockData iblockdata) {
        return this.i(iblockdata) >= this.c();
    }

    @Override
    protected boolean f(IBlockData iblockdata) {
        return !this.n(iblockdata);
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        int i2;
        if (worldserver.b(blockposition, 0) >= 9 && (i2 = this.i(iblockdata)) < this.c()) {
            float f2 = BlockCrops.a(this, worldserver, blockposition);
            int modifier = this == Blocks.lz ? worldserver.spigotConfig.beetrootModifier : (this == Blocks.hj ? worldserver.spigotConfig.carrotModifier : (this == Blocks.hk ? worldserver.spigotConfig.potatoModifier : worldserver.spigotConfig.wheatModifier));
            if ((double)randomsource.i() < (double)modifier / (100.0 * Math.floor(25.0f / f2 + 1.0f))) {
                CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, this.b(i2 + 1), 2);
            }
        }
    }

    public void b(World world, BlockPosition blockposition, IBlockData iblockdata) {
        int i2 = Math.min(this.c(), this.i(iblockdata) + this.a(world));
        CraftEventFactory.handleBlockGrowEvent(world, blockposition, this.b(i2), 2);
    }

    protected int a(World world) {
        return MathHelper.a(world.z, 2, 5);
    }

    protected static float a(Block block, IBlockAccess iblockaccess, BlockPosition blockposition) {
        boolean flag1;
        float f2 = 1.0f;
        BlockPosition blockposition1 = blockposition.e();
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                float f1 = 0.0f;
                IBlockData iblockdata = iblockaccess.a_(blockposition1.b(i2, 0, j2));
                if (iblockdata.a(Blocks.cZ)) {
                    f1 = 1.0f;
                    if (iblockdata.c(BlockSoil.b) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (i2 != 0 || j2 != 0) {
                    f1 /= 4.0f;
                }
                f2 += f1;
            }
        }
        BlockPosition blockposition2 = blockposition.f();
        BlockPosition blockposition3 = blockposition.g();
        BlockPosition blockposition4 = blockposition.h();
        BlockPosition blockposition5 = blockposition.i();
        boolean flag = iblockaccess.a_(blockposition4).a(block) || iblockaccess.a_(blockposition5).a(block);
        boolean bl = flag1 = iblockaccess.a_(blockposition2).a(block) || iblockaccess.a_(blockposition3).a(block);
        if (flag && flag1) {
            f2 /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = iblockaccess.a_(blockposition4.f()).a(block) || iblockaccess.a_(blockposition5.f()).a(block) || iblockaccess.a_(blockposition5.g()).a(block) || iblockaccess.a_(blockposition4.g()).a(block);
            if (flag2) {
                f2 /= 2.0f;
            }
        }
        return f2;
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return BlockCrops.a(iworldreader, blockposition) && super.a(iblockdata, iworldreader, blockposition);
    }

    protected static boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
        return iworldreader.b(blockposition, 0) >= 8;
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (entity instanceof EntityRavager && CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, Blocks.a.m(), !worldserver.S().c(GameRules.d))) {
                worldserver.a(blockposition, true, entity);
            }
        }
        super.a(iblockdata, world, blockposition, entity, insideblockeffectapplier, flag);
    }

    protected IMaterial d() {
        return Items.rb;
    }

    @Override
    protected ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
        return new ItemStack(this.d());
    }

    @Override
    public boolean a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return !this.n(iblockdata);
    }

    @Override
    public boolean a(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void a(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        this.b(worldserver, blockposition, iblockdata);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{f});
    }
}

