/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.grower.WorldGenTreeProvider;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.world.StructureGrowEvent;

public class BlockSapling
extends VegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockSapling> e = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldGenTreeProvider.a.fieldOf("tree").forGetter(blocksapling -> blocksapling.g), BlockSapling.x()).apply((Applicative)instance, BlockSapling::new));
    public static final BlockStateInteger f = BlockProperties.aY;
    private static final VoxelShape a = Block.b(12.0, 0.0, 12.0);
    protected final WorldGenTreeProvider g;
    public static TreeType treeType;

    public MapCodec<? extends BlockSapling> a() {
        return e;
    }

    protected BlockSapling(WorldGenTreeProvider worldgentreeprovider, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.g = worldgentreeprovider;
        this.l((IBlockData)((IBlockData)this.C.b()).b(f, 0));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return a;
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.C(blockposition.d()) >= 9 && randomsource.i() < (float)worldserver.spigotConfig.saplingModifier / 700.0f) {
            this.a(worldserver, blockposition, iblockdata, randomsource);
        }
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, RandomSource randomsource) {
        if (iblockdata.c(f) == 0) {
            worldserver.a(blockposition, (IBlockData)iblockdata.a(f), 260);
        } else if (worldserver.captureTreeGeneration) {
            this.g.a(worldserver, worldserver.n().g(), blockposition, iblockdata, randomsource);
        } else {
            worldserver.captureTreeGeneration = true;
            this.g.a(worldserver, worldserver.n().g(), blockposition, iblockdata, randomsource);
            worldserver.captureTreeGeneration = false;
            if (worldserver.capturedBlockStates.size() > 0) {
                TreeType treeType = BlockSapling.treeType;
                BlockSapling.treeType = null;
                Location location = CraftLocation.toBukkit(blockposition, (org.bukkit.World)worldserver.getWorld());
                ArrayList blocks = new ArrayList(worldserver.capturedBlockStates.values());
                worldserver.capturedBlockStates.clear();
                StructureGrowEvent event = null;
                if (treeType != null) {
                    event = new StructureGrowEvent(location, treeType, false, null, blocks);
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event == null || !event.isCancelled()) {
                    for (BlockState blockstate : blocks) {
                        CapturedBlockState.setBlockState(blockstate);
                    }
                }
            }
        }
    }

    @Override
    public boolean a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public boolean a(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return (double)world.z.i() < 0.45;
    }

    @Override
    public void a(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        this.a(worldserver, blockposition, iblockdata, randomsource);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{f});
    }
}

