/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;

public class VaultBlockEntity
extends TileEntity {
    private final VaultServerData a = new VaultServerData();
    private final VaultSharedData b = new VaultSharedData();
    private final VaultClientData c = new VaultClientData();
    private VaultConfig d = VaultConfig.b;

    public VaultBlockEntity(BlockPosition blockposition, IBlockData iblockdata) {
        super(TileEntityTypes.T, blockposition, iblockdata);
    }

    @Override
    @Nullable
    public Packet<PacketListenerPlayOut> ax_() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        return SystemUtils.a(new NBTTagCompound(), (? super T nbttagcompound) -> nbttagcompound.a("shared_data", VaultSharedData.b, holderlookup_a.a(DynamicOpsNBT.a), this.b));
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("config", VaultConfig.c, this.d);
        valueoutput.a("shared_data", VaultSharedData.b, this.b);
        valueoutput.a("server_data", VaultServerData.b, this.a);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        Optional<Object> optional = valueinput.a("server_data", VaultServerData.b);
        VaultServerData vaultserverdata = this.a;
        Objects.requireNonNull(this.a);
        optional.ifPresent(vaultserverdata::a);
        this.d = valueinput.a("config", VaultConfig.c).orElse(VaultConfig.b);
        optional = valueinput.a("shared_data", VaultSharedData.b);
        VaultSharedData vaultshareddata = this.b;
        Objects.requireNonNull(this.b);
        optional.ifPresent(vaultshareddata::a);
    }

    @Nullable
    public VaultServerData a() {
        return this.n != null && !this.n.D_() ? this.a : null;
    }

    public VaultSharedData c() {
        return this.b;
    }

    public VaultClientData d() {
        return this.c;
    }

    public VaultConfig f() {
        return this.d;
    }

    @VisibleForTesting
    public void a(VaultConfig vaultconfig) {
        this.d = vaultconfig;
    }

    public static final class a {
        private static final int a = 20;
        private static final float b = 0.5f;
        private static final float c = 0.02f;
        private static final int d = 20;
        private static final int e = 20;

        public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, VaultClientData vaultclientdata, VaultSharedData vaultshareddata) {
            vaultclientdata.c();
            if (world.ag() % 20L == 0L) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, blockposition, iblockdata, vaultshareddata);
            }
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, blockposition, vaultshareddata, iblockdata.c(VaultBlock.d) != false ? Particles.O : Particles.aN);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, blockposition, vaultshareddata);
        }

        public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, VaultSharedData vaultshareddata, ParticleParam particleparam) {
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, blockposition, iblockdata, vaultshareddata);
            RandomSource randomsource = world.z;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(blockposition, randomsource);
                world.a(Particles.ai, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                world.a(particleparam, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
            }
        }

        public static void a(World world, BlockPosition blockposition, ParticleParam particleparam) {
            RandomSource randomsource = world.z;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(blockposition, randomsource);
                Vec3D vec3d1 = new Vec3D(randomsource.k() * 0.02, randomsource.k() * 0.02, randomsource.k() * 0.02);
                world.a(particleparam, vec3d.a(), vec3d.b(), vec3d.c(), vec3d1.a(), vec3d1.b(), vec3d1.c());
            }
        }

        private static void a(World world, BlockPosition blockposition, VaultSharedData vaultshareddata, ParticleParam particleparam) {
            RandomSource randomsource = world.I_();
            if (randomsource.i() <= 0.5f) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(blockposition, randomsource);
                world.a(Particles.ai, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(vaultshareddata)) {
                    world.a(particleparam, vec3d.a(), vec3d.b(), vec3d.c(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void a(World world, Vec3D vec3d, EntityHuman entityhuman) {
            RandomSource randomsource = world.z;
            Vec3D vec3d1 = vec3d.a(entityhuman.dD().b(0.0, entityhuman.dB() / 2.0f, 0.0));
            int i2 = MathHelper.a(randomsource, 2, 5);
            for (int j2 = 0; j2 < i2; ++j2) {
                Vec3D vec3d2 = vec3d1.a(randomsource, 1.0f);
                world.a(Particles.be, vec3d.a(), vec3d.b(), vec3d.c(), vec3d2.a(), vec3d2.b(), vec3d2.c());
            }
        }

        private static void a(World world, BlockPosition blockposition, IBlockData iblockdata, VaultSharedData vaultshareddata) {
            Set<UUID> set = vaultshareddata.d();
            if (!set.isEmpty()) {
                Vec3D vec3d = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(blockposition, iblockdata.c(VaultBlock.c));
                for (UUID uuid : set) {
                    EntityHuman entityhuman = world.c(uuid);
                    if (entityhuman == null || !net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(blockposition, vaultshareddata, entityhuman)) continue;
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(world, vec3d, entityhuman);
                }
            }
        }

        private static boolean a(BlockPosition blockposition, VaultSharedData vaultshareddata, EntityHuman entityhuman) {
            return entityhuman.dF().j(blockposition) <= MathHelper.l(vaultshareddata.e());
        }

        private static void a(World world, BlockPosition blockposition, VaultSharedData vaultshareddata) {
            RandomSource randomsource;
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(vaultshareddata) && (randomsource = world.I_()).i() <= 0.02f) {
                world.a(blockposition, SoundEffects.CU, SoundCategory.e, randomsource.i() * 0.25f + 0.75f, randomsource.i() + 0.5f, false);
            }
        }

        public static boolean a(VaultSharedData vaultshareddata) {
            return vaultshareddata.b();
        }

        private static Vec3D a(BlockPosition blockposition, RandomSource randomsource) {
            return Vec3D.a(blockposition).b(MathHelper.a(randomsource, 0.4, 0.6), MathHelper.a(randomsource, 0.4, 0.6), MathHelper.a(randomsource, 0.4, 0.6));
        }

        private static Vec3D b(BlockPosition blockposition, RandomSource randomsource) {
            return Vec3D.a(blockposition).b(MathHelper.a(randomsource, 0.1, 0.9), MathHelper.a(randomsource, 0.25, 0.75), MathHelper.a(randomsource, 0.1, 0.9));
        }

        private static Vec3D a(BlockPosition blockposition, EnumDirection enumdirection) {
            return Vec3D.c(blockposition).b((double)enumdirection.j() * 0.5, 1.75, (double)enumdirection.l() * 0.5);
        }
    }

    public static final class b {
        private static final int a = 14;
        private static final int b = 20;
        private static final int c = 15;

        public static void a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata) {
            VaultState vaultstate = iblockdata.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver.ag(), vaultstate)) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, vaultstate, vaultconfig, vaultshareddata, blockposition);
            }
            IBlockData iblockdata1 = iblockdata;
            if (worldserver.ag() >= vaultserverdata.c() && iblockdata != (iblockdata1 = (IBlockData)iblockdata.b(VaultBlock.b, vaultstate.a(worldserver, blockposition, vaultconfig, vaultserverdata, vaultshareddata)))) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, blockposition, iblockdata, iblockdata1, vaultconfig, vaultshareddata);
            }
            if (vaultserverdata.c || vaultshareddata.c) {
                VaultBlockEntity.a(worldserver, blockposition, iblockdata);
                if (vaultshareddata.c) {
                    worldserver.a(blockposition, iblockdata, iblockdata1, 2);
                }
                vaultserverdata.c = false;
                vaultshareddata.c = false;
            }
        }

        public static void a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata, EntityHuman entityhuman, ItemStack itemstack) {
            VaultState vaultstate = iblockdata.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(vaultconfig, vaultstate)) {
                if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(vaultconfig, itemstack)) {
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, vaultserverdata, blockposition, SoundEffects.Dd);
                } else if (vaultserverdata.a(entityhuman)) {
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, vaultserverdata, blockposition, SoundEffects.CZ);
                } else {
                    List<ItemStack> list = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, vaultconfig, blockposition, entityhuman, itemstack);
                    if (!list.isEmpty()) {
                        entityhuman.b(StatisticList.c.b(itemstack.h()));
                        itemstack.a(vaultconfig.e().M(), (EntityLiving)entityhuman);
                        BlockDispenseLootEvent vaultDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(worldserver, blockposition, entityhuman, list);
                        if (vaultDispenseLootEvent.isCancelled()) {
                            return;
                        }
                        list = vaultDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList();
                        net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, iblockdata, blockposition, vaultconfig, vaultserverdata, vaultshareddata, list);
                        vaultserverdata.b(entityhuman);
                        vaultshareddata.a(worldserver, blockposition, vaultserverdata, vaultconfig, vaultconfig.d());
                    }
                }
            }
        }

        static void a(WorldServer worldserver, BlockPosition blockposition, IBlockData iblockdata, IBlockData iblockdata1, VaultConfig vaultconfig, VaultSharedData vaultshareddata) {
            VaultState vaultstate = iblockdata.c(VaultBlock.b);
            VaultState vaultstate1 = iblockdata1.c(VaultBlock.b);
            worldserver.a(blockposition, iblockdata1, 3);
            vaultstate.a(worldserver, blockposition, vaultstate1, vaultconfig, vaultshareddata, iblockdata1.c(VaultBlock.d));
        }

        static void a(WorldServer worldserver, VaultState vaultstate, VaultConfig vaultconfig, VaultSharedData vaultshareddata, BlockPosition blockposition) {
            if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(vaultconfig, vaultstate)) {
                vaultshareddata.a(ItemStack.l);
            } else {
                ItemStack itemstack = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, blockposition, vaultconfig.f().orElse(vaultconfig.b()));
                VaultDisplayItemEvent event = CraftEventFactory.callVaultDisplayItemEvent(worldserver, blockposition, itemstack);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = CraftItemStack.asNMSCopy(event.getDisplayItem());
                vaultshareddata.a(itemstack);
            }
        }

        private static ItemStack a(WorldServer worldserver, BlockPosition blockposition, ResourceKey<LootTable> resourcekey) {
            LootParams lootparams;
            LootTable loottable = worldserver.q().bi().a(resourcekey);
            ObjectArrayList<ItemStack> list = loottable.a(lootparams = new LootParams.a(worldserver).a(LootContextParameters.h, Vec3D.b(blockposition)).a(LootContextParameterSets.l), worldserver.I_());
            return list.isEmpty() ? ItemStack.l : SystemUtils.a(list, worldserver.I_());
        }

        private static void a(WorldServer worldserver, IBlockData iblockdata, BlockPosition blockposition, VaultConfig vaultconfig, VaultServerData vaultserverdata, VaultSharedData vaultshareddata, List<ItemStack> list) {
            vaultserverdata.a(list);
            vaultshareddata.a(vaultserverdata.f());
            vaultserverdata.b(worldserver.ag() + 14L);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(worldserver, blockposition, iblockdata, (IBlockData)iblockdata.b(VaultBlock.b, VaultState.c), vaultconfig, vaultshareddata);
        }

        private static List<ItemStack> a(WorldServer worldserver, VaultConfig vaultconfig, BlockPosition blockposition, EntityHuman entityhuman, ItemStack itemstack) {
            LootTable loottable = worldserver.q().bi().a(vaultconfig.b());
            LootParams lootparams = new LootParams.a(worldserver).a(LootContextParameters.h, Vec3D.b(blockposition)).a(entityhuman.ew()).a(LootContextParameters.a, entityhuman).a(LootContextParameters.k, itemstack).a(LootContextParameterSets.l);
            return loottable.a(lootparams);
        }

        private static boolean a(VaultConfig vaultconfig, VaultState vaultstate) {
            return !vaultconfig.e().f() && vaultstate != VaultState.a;
        }

        private static boolean a(VaultConfig vaultconfig, ItemStack itemstack) {
            return ItemStack.c(itemstack, vaultconfig.e()) && itemstack.M() >= vaultconfig.e().M();
        }

        private static boolean a(long i2, VaultState vaultstate) {
            return i2 % 20L == 0L && vaultstate == VaultState.b;
        }

        private static void a(WorldServer worldserver, VaultServerData vaultserverdata, BlockPosition blockposition, SoundEffect soundeffect) {
            if (worldserver.ag() >= vaultserverdata.a() + 15L) {
                worldserver.a((Entity)null, blockposition, soundeffect, SoundCategory.e);
                vaultserverdata.a(worldserver.ag());
            }
        }
    }
}

