/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.grower;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import org.bukkit.TreeType;

public final class WorldGenTreeProvider {
    private static final Map<String, WorldGenTreeProvider> l = new Object2ObjectArrayMap();
    public static final Codec<WorldGenTreeProvider> a;
    public static final WorldGenTreeProvider b;
    public static final WorldGenTreeProvider c;
    public static final WorldGenTreeProvider d;
    public static final WorldGenTreeProvider e;
    public static final WorldGenTreeProvider f;
    public static final WorldGenTreeProvider g;
    public static final WorldGenTreeProvider h;
    public static final WorldGenTreeProvider i;
    public static final WorldGenTreeProvider j;
    public static final WorldGenTreeProvider k;
    private final String m;
    private final float n;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> o;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> p;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> q;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> r;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> s;
    private final Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> t;

    public WorldGenTreeProvider(String s2, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional1, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional2) {
        this(s2, 0.0f, optional, Optional.empty(), optional1, Optional.empty(), optional2, Optional.empty());
    }

    public WorldGenTreeProvider(String s2, float f2, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional1, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional2, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional3, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional4, Optional<ResourceKey<WorldGenFeatureConfigured<?, ?>>> optional5) {
        this.m = s2;
        this.n = f2;
        this.o = optional;
        this.p = optional1;
        this.q = optional2;
        this.r = optional3;
        this.s = optional4;
        this.t = optional5;
        l.put(s2, this);
    }

    @Nullable
    private ResourceKey<WorldGenFeatureConfigured<?, ?>> a(RandomSource randomsource, boolean flag) {
        if (randomsource.i() < this.n) {
            if (flag && this.t.isPresent()) {
                return this.t.get();
            }
            if (this.r.isPresent()) {
                return this.r.get();
            }
        }
        return flag && this.s.isPresent() ? this.s.get() : (ResourceKey<WorldGenFeatureConfigured<?, ?>>)this.q.orElse(null);
    }

    @Nullable
    private ResourceKey<WorldGenFeatureConfigured<?, ?>> a(RandomSource randomsource) {
        return this.p.isPresent() && randomsource.i() < this.n ? this.p.get() : (ResourceKey<WorldGenFeatureConfigured<?, ?>>)this.o.orElse(null);
    }

    public boolean a(WorldServer worldserver, ChunkGenerator chunkgenerator, BlockPosition blockposition, IBlockData iblockdata, RandomSource randomsource) {
        ResourceKey<WorldGenFeatureConfigured<?, ?>> resourcekey1;
        Holder holder;
        ResourceKey<WorldGenFeatureConfigured<?, ?>> resourcekey = this.a(randomsource);
        if (resourcekey != null && (holder = (Holder)worldserver.L_().f(Registries.aS).a(resourcekey).orElse(null)) != null) {
            this.setTreeType(holder);
            for (int i2 = 0; i2 >= -1; --i2) {
                for (int j2 = 0; j2 >= -1; --j2) {
                    if (!WorldGenTreeProvider.a(iblockdata, worldserver, blockposition, i2, j2)) continue;
                    WorldGenFeatureConfigured worldgenfeatureconfigured = (WorldGenFeatureConfigured)holder.a();
                    IBlockData iblockdata1 = Blocks.a.m();
                    worldserver.a(blockposition.b(i2, 0, j2), iblockdata1, 260);
                    worldserver.a(blockposition.b(i2 + 1, 0, j2), iblockdata1, 260);
                    worldserver.a(blockposition.b(i2, 0, j2 + 1), iblockdata1, 260);
                    worldserver.a(blockposition.b(i2 + 1, 0, j2 + 1), iblockdata1, 260);
                    if (worldgenfeatureconfigured.a(worldserver, chunkgenerator, randomsource, blockposition.b(i2, 0, j2))) {
                        return true;
                    }
                    worldserver.a(blockposition.b(i2, 0, j2), iblockdata, 260);
                    worldserver.a(blockposition.b(i2 + 1, 0, j2), iblockdata, 260);
                    worldserver.a(blockposition.b(i2, 0, j2 + 1), iblockdata, 260);
                    worldserver.a(blockposition.b(i2 + 1, 0, j2 + 1), iblockdata, 260);
                    return false;
                }
            }
        }
        if ((resourcekey1 = this.a(randomsource, this.a(worldserver, blockposition))) == null) {
            return false;
        }
        Holder holder1 = worldserver.L_().f(Registries.aS).a(resourcekey1).orElse(null);
        if (holder1 == null) {
            return false;
        }
        this.setTreeType(holder1);
        WorldGenFeatureConfigured worldgenfeatureconfigured1 = (WorldGenFeatureConfigured)holder1.a();
        IBlockData iblockdata2 = worldserver.b_(blockposition).g();
        worldserver.a(blockposition, iblockdata2, 260);
        if (worldgenfeatureconfigured1.a(worldserver, chunkgenerator, randomsource, blockposition)) {
            if (worldserver.a_(blockposition) == iblockdata2) {
                worldserver.a(blockposition, iblockdata, iblockdata2, 2);
            }
            return true;
        }
        worldserver.a(blockposition, iblockdata, 260);
        return false;
    }

    private static boolean a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, int i2, int j2) {
        Block block = iblockdata.b();
        return iblockaccess.a_(blockposition.b(i2, 0, j2)).a(block) && iblockaccess.a_(blockposition.b(i2 + 1, 0, j2)).a(block) && iblockaccess.a_(blockposition.b(i2, 0, j2 + 1)).a(block) && iblockaccess.a_(blockposition.b(i2 + 1, 0, j2 + 1)).a(block);
    }

    private boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        for (BlockPosition blockposition1 : BlockPosition.MutableBlockPosition.c(blockposition.e().d(2).f(2), blockposition.d().e(2).g(2))) {
            if (!generatoraccess.a_(blockposition1).a(TagsBlock.Q)) continue;
            return true;
        }
        return false;
    }

    private void setTreeType(Holder<WorldGenFeatureConfigured<?, ?>> holder) {
        ResourceKey<WorldGenFeatureConfigured<?, ?>> worldgentreeabstract = holder.e().get();
        if (worldgentreeabstract == TreeFeatures.g || worldgentreeabstract == TreeFeatures.F) {
            BlockSapling.treeType = TreeType.TREE;
        } else if (worldgentreeabstract == TreeFeatures.f) {
            BlockSapling.treeType = TreeType.RED_MUSHROOM;
        } else if (worldgentreeabstract == TreeFeatures.e) {
            BlockSapling.treeType = TreeType.BROWN_MUSHROOM;
        } else if (worldgentreeabstract == TreeFeatures.p) {
            BlockSapling.treeType = TreeType.COCOA_TREE;
        } else if (worldgentreeabstract == TreeFeatures.r) {
            BlockSapling.treeType = TreeType.SMALL_JUNGLE;
        } else if (worldgentreeabstract == TreeFeatures.o) {
            BlockSapling.treeType = TreeType.TALL_REDWOOD;
        } else if (worldgentreeabstract == TreeFeatures.n) {
            BlockSapling.treeType = TreeType.REDWOOD;
        } else if (worldgentreeabstract == TreeFeatures.m) {
            BlockSapling.treeType = TreeType.ACACIA;
        } else if (worldgentreeabstract == TreeFeatures.l || worldgentreeabstract == TreeFeatures.J) {
            BlockSapling.treeType = TreeType.BIRCH;
        } else if (worldgentreeabstract == TreeFeatures.v) {
            BlockSapling.treeType = TreeType.TALL_BIRCH;
        } else if (worldgentreeabstract == TreeFeatures.x) {
            BlockSapling.treeType = TreeType.SWAMP;
        } else if (worldgentreeabstract == TreeFeatures.q || worldgentreeabstract == TreeFeatures.M) {
            BlockSapling.treeType = TreeType.BIG_TREE;
        } else if (worldgentreeabstract == TreeFeatures.y) {
            BlockSapling.treeType = TreeType.JUNGLE_BUSH;
        } else if (worldgentreeabstract == TreeFeatures.h) {
            BlockSapling.treeType = TreeType.DARK_OAK;
        } else if (worldgentreeabstract == TreeFeatures.t) {
            BlockSapling.treeType = TreeType.MEGA_REDWOOD;
        } else if (worldgentreeabstract == TreeFeatures.u) {
            BlockSapling.treeType = TreeType.MEGA_PINE;
        } else if (worldgentreeabstract == TreeFeatures.s) {
            BlockSapling.treeType = TreeType.JUNGLE;
        } else if (worldgentreeabstract == TreeFeatures.z) {
            BlockSapling.treeType = TreeType.AZALEA;
        } else if (worldgentreeabstract == TreeFeatures.A) {
            BlockSapling.treeType = TreeType.MANGROVE;
        } else if (worldgentreeabstract == TreeFeatures.B) {
            BlockSapling.treeType = TreeType.TALL_MANGROVE;
        } else if (worldgentreeabstract == TreeFeatures.C || worldgentreeabstract == TreeFeatures.O) {
            BlockSapling.treeType = TreeType.CHERRY;
        } else if (worldgentreeabstract == TreeFeatures.i || worldgentreeabstract == TreeFeatures.j) {
            BlockSapling.treeType = TreeType.PALE_OAK;
        } else if (worldgentreeabstract == TreeFeatures.k) {
            BlockSapling.treeType = TreeType.PALE_OAK_CREAKING;
        } else {
            throw new IllegalArgumentException("Unknown tree generator " + String.valueOf(worldgentreeabstract));
        }
    }

    static {
        Function<WorldGenTreeProvider, String> function = worldgentreeprovider -> worldgentreeprovider.m;
        Map<String, WorldGenTreeProvider> map = l;
        Objects.requireNonNull(map);
        a = Codec.stringResolver(function, map::get);
        b = new WorldGenTreeProvider("oak", 0.1f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.g), Optional.of(TreeFeatures.q), Optional.of(TreeFeatures.F), Optional.of(TreeFeatures.M));
        c = new WorldGenTreeProvider("spruce", 0.5f, Optional.of(TreeFeatures.t), Optional.of(TreeFeatures.u), Optional.of(TreeFeatures.n), Optional.empty(), Optional.empty(), Optional.empty());
        d = new WorldGenTreeProvider("mangrove", 0.85f, Optional.empty(), Optional.empty(), Optional.of(TreeFeatures.A), Optional.of(TreeFeatures.B), Optional.empty(), Optional.empty());
        e = new WorldGenTreeProvider("azalea", Optional.empty(), Optional.of(TreeFeatures.z), Optional.empty());
        f = new WorldGenTreeProvider("birch", Optional.empty(), Optional.of(TreeFeatures.l), Optional.of(TreeFeatures.J));
        g = new WorldGenTreeProvider("jungle", Optional.of(TreeFeatures.s), Optional.of(TreeFeatures.r), Optional.empty());
        h = new WorldGenTreeProvider("acacia", Optional.empty(), Optional.of(TreeFeatures.m), Optional.empty());
        i = new WorldGenTreeProvider("cherry", Optional.empty(), Optional.of(TreeFeatures.C), Optional.of(TreeFeatures.O));
        j = new WorldGenTreeProvider("dark_oak", Optional.of(TreeFeatures.h), Optional.empty(), Optional.empty());
        k = new WorldGenTreeProvider("pale_oak", Optional.of(TreeFeatures.j), Optional.empty(), Optional.empty());
    }
}

