/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class PersistentEntitySectionManager<T extends EntityAccess>
implements AutoCloseable {
    static final Logger a = LogUtils.getLogger();
    final Set<UUID> b = Sets.newHashSet();
    final LevelCallback<T> c;
    public final EntityPersistentStorage<T> d;
    private final EntityLookup<T> e = new EntityLookup();
    final EntitySectionStorage<T> f;
    private final LevelEntityGetter<T> g;
    private final Long2ObjectMap<Visibility> h = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<b> i = new Long2ObjectOpenHashMap();
    private final LongSet j = new LongOpenHashSet();
    private final Queue<ChunkEntities<T>> k = Queues.newConcurrentLinkedQueue();

    public PersistentEntitySectionManager(Class<T> oclass, LevelCallback<T> levelcallback, EntityPersistentStorage<T> entitypersistentstorage) {
        this.f = new EntitySectionStorage<T>(oclass, (Long2ObjectFunction<Visibility>)this.h);
        this.h.defaultReturnValue((Object)Visibility.a);
        this.i.defaultReturnValue((Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a);
        this.c = levelcallback;
        this.d = entitypersistentstorage;
        this.g = new LevelEntityGetterAdapter<T>(this.e, this.f);
    }

    public List<Entity> getEntities(ChunkCoordIntPair chunkCoordIntPair) {
        return this.f.b(chunkCoordIntPair.a()).flatMap(EntitySection::b).map(entity -> (Entity)entity).collect(Collectors.toList());
    }

    public boolean isPending(long pair) {
        return this.i.get(pair) == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b;
    }

    void a(long i2, EntitySection<T> entitysection) {
        if (entitysection.a()) {
            this.f.e(i2);
        }
    }

    private boolean b(T t0) {
        if (!this.b.add(t0.cT())) {
            a.warn("UUID of added entity already exists: {}", t0);
            return false;
        }
        return true;
    }

    public boolean a(T t0) {
        return this.a(t0, false);
    }

    private boolean a(T t0, boolean flag) {
        Visibility visibility;
        if (!this.b(t0)) {
            return false;
        }
        long i2 = SectionPosition.c(t0.dF());
        EntitySection<T> entitysection = this.f.c(i2);
        entitysection.a(t0);
        t0.a(new a((EntityAccess)t0, i2, entitysection));
        if (!flag) {
            this.c.g(t0);
        }
        if (t0 instanceof Entity) {
            Entity entity = (Entity)t0;
            entity.inWorld = true;
        }
        if ((visibility = PersistentEntitySectionManager.a(t0, entitysection.c())).b()) {
            this.e(t0);
        }
        if (visibility.a()) {
            this.c(t0);
        }
        return true;
    }

    static <T extends EntityAccess> Visibility a(T t0, Visibility visibility) {
        return t0.eg() ? Visibility.c : visibility;
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair) {
        return ((Visibility)((Object)this.h.get(chunkcoordintpair.a()))).a();
    }

    public void a(Stream<T> stream) {
        stream.forEach(entityaccess -> this.a(entityaccess, true));
    }

    public void b(Stream<T> stream) {
        stream.forEach(entityaccess -> this.a(entityaccess, false));
    }

    void c(T t0) {
        this.c.e(t0);
    }

    void d(T t0) {
        this.c.d(t0);
    }

    void e(T t0) {
        this.e.a(t0);
        this.c.c(t0);
    }

    void f(T t0) {
        this.c.b(t0);
        this.e.b(t0);
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, FullChunkStatus fullchunkstatus) {
        Visibility visibility = Visibility.a(fullchunkstatus);
        this.a(chunkcoordintpair, visibility);
    }

    public void a(ChunkCoordIntPair chunkcoordintpair, Visibility visibility) {
        long i2 = chunkcoordintpair.a();
        if (visibility == Visibility.a) {
            this.h.remove(i2);
            this.j.add(i2);
        } else {
            this.h.put(i2, (Object)visibility);
            this.j.remove(i2);
            this.b(i2);
        }
        this.f.b(i2).forEach(entitysection -> {
            Visibility visibility1 = entitysection.a(visibility);
            boolean flag = visibility1.b();
            boolean flag1 = visibility.b();
            boolean flag2 = visibility1.a();
            boolean flag3 = visibility.a();
            if (flag2 && !flag3) {
                entitysection.b().filter(entityaccess -> !entityaccess.eg()).forEach(this::d);
            }
            if (flag && !flag1) {
                entitysection.b().filter(entityaccess -> !entityaccess.eg()).forEach(this::f);
            } else if (!flag && flag1) {
                entitysection.b().filter(entityaccess -> !entityaccess.eg()).forEach(this::e);
            }
            if (!flag2 && flag3) {
                entitysection.b().filter(entityaccess -> !entityaccess.eg()).forEach(this::c);
            }
        });
    }

    public void b(long i2) {
        b persistententitysectionmanager_b = (b)((Object)this.i.get(i2));
        if (persistententitysectionmanager_b == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a) {
            this.c(i2);
        }
    }

    private boolean a(long i2, Consumer<T> consumer) {
        return this.storeChunkSections(i2, consumer, false);
    }

    private boolean storeChunkSections(long i2, Consumer<T> consumer, boolean callEvent) {
        b persistententitysectionmanager_b = (b)((Object)this.i.get(i2));
        if (persistententitysectionmanager_b == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b) {
            return false;
        }
        List<T> list = this.f.b(i2).flatMap(entitysection -> entitysection.b().filter(EntityAccess::ef)).collect(Collectors.toList());
        if (list.isEmpty()) {
            if (persistententitysectionmanager_b == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c) {
                if (callEvent) {
                    CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.d).d, new ChunkCoordIntPair(i2), (List<Entity>)ImmutableList.of());
                }
                this.d.a(new ChunkEntities(new ChunkCoordIntPair(i2), ImmutableList.of()));
            }
            return true;
        }
        if (persistententitysectionmanager_b == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.a) {
            this.c(i2);
            return false;
        }
        if (callEvent) {
            CraftEventFactory.callEntitiesUnloadEvent(((EntityStorage)this.d).d, new ChunkCoordIntPair(i2), list.stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
        }
        this.d.a(new ChunkEntities(new ChunkCoordIntPair(i2), list));
        list.forEach(consumer);
        return true;
    }

    private void c(long i2) {
        this.i.put(i2, (Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.b);
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
        CompletableFuture<ChunkEntities<T>> completablefuture = this.d.a(chunkcoordintpair);
        Queue<ChunkEntities<T>> queue = this.k;
        Objects.requireNonNull(this.k);
        ((CompletableFuture)completablefuture.thenAccept(queue::add)).exceptionally(throwable -> {
            a.error("Failed to read chunk {}", (Object)chunkcoordintpair, throwable);
            return null;
        });
    }

    private boolean d(long i2) {
        boolean flag = this.storeChunkSections(i2, entityaccess -> entityaccess.dl().forEach(this::g), true);
        if (!flag) {
            return false;
        }
        this.i.remove(i2);
        return true;
    }

    private void g(EntityAccess entityaccess) {
        entityaccess.setRemoved(Entity.RemovalReason.c, EntityRemoveEvent.Cause.UNLOAD);
        entityaccess.a(EntityInLevelCallback.a);
    }

    private void h() {
        this.j.removeIf(i2 -> this.h.get(i2) != Visibility.a ? true : this.d(i2));
    }

    public void a() {
        ChunkEntities<T> chunkentities;
        while ((chunkentities = this.k.poll()) != null) {
            chunkentities.b().forEach(entityaccess -> this.a(entityaccess, true));
            this.i.put(chunkentities.a().a(), (Object)net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c);
            List<Entity> entities = this.getEntities(chunkentities.a());
            CraftEventFactory.callEntitiesLoadEvent(((EntityStorage)this.d).d, chunkentities.a(), entities);
        }
    }

    public void b() {
        this.a();
        this.h();
    }

    private LongSet i() {
        LongSet longset = this.f.a();
        for (Long2ObjectMap.Entry long2objectmap_entry : Long2ObjectMaps.fastIterable(this.i)) {
            if (long2objectmap_entry.getValue() != net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c) continue;
            longset.add(long2objectmap_entry.getLongKey());
        }
        return longset;
    }

    public void c() {
        this.i().forEach(i2 -> {
            boolean flag;
            boolean bl = flag = this.h.get(i2) == Visibility.a;
            if (flag) {
                this.d(i2);
            } else {
                this.a(i2, (T entityaccess) -> {});
            }
        });
    }

    public void d() {
        LongSet longset = this.i();
        while (!longset.isEmpty()) {
            this.d.a(false);
            this.a();
            longset.removeIf(i2 -> {
                boolean flag = this.h.get(i2) == Visibility.a;
                return flag ? this.d(i2) : this.a(i2, (T entityaccess) -> {});
            });
        }
        this.d.a(true);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.d();
        }
        this.d.close();
    }

    public boolean a(UUID uuid) {
        return this.b.contains(uuid);
    }

    public LevelEntityGetter<T> e() {
        return this.g;
    }

    public boolean a(BlockPosition blockposition) {
        return ((Visibility)((Object)this.h.get(ChunkCoordIntPair.a(blockposition)))).a();
    }

    public boolean b(ChunkCoordIntPair chunkcoordintpair) {
        return ((Visibility)((Object)this.h.get(chunkcoordintpair.a()))).a();
    }

    public boolean a(long i2) {
        return this.i.get(i2) == net.minecraft.world.level.entity.PersistentEntitySectionManager$b.c;
    }

    public void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("visibility").a("load_status").a("entity_count").a(writer);
        this.f.a().forEach(i2 -> {
            b persistententitysectionmanager_b = (b)((Object)((Object)this.i.get(i2)));
            this.f.a(i2).forEach(j2 -> {
                EntitySection<T> entitysection = this.f.d(j2);
                if (entitysection != null) {
                    try {
                        csvwriter.a(new Object[]{SectionPosition.b(j2), SectionPosition.c(j2), SectionPosition.d(j2), entitysection.c(), persistententitysectionmanager_b, entitysection.d()});
                    }
                    catch (IOException ioexception) {
                        throw new UncheckedIOException(ioexception);
                    }
                }
            });
        });
    }

    @VisibleForDebug
    public String f() {
        int i2 = this.b.size();
        return i2 + "," + this.e.b() + "," + this.f.b() + "," + this.i.size() + "," + this.h.size() + "," + this.k.size() + "," + this.j.size();
    }

    @VisibleForDebug
    public int g() {
        return this.e.b();
    }

    private static enum b {
        a,
        b,
        c;

    }

    private class a
    implements EntityInLevelCallback {
        private final T c;
        private long d;
        private EntitySection<T> e;

        a(EntityAccess entityaccess, long i2, EntitySection entitysection) {
            this.c = entityaccess;
            this.d = i2;
            this.e = entitysection;
        }

        @Override
        public void a() {
            BlockPosition blockposition = this.c.dF();
            long i2 = SectionPosition.c(blockposition);
            if (i2 != this.d) {
                Visibility visibility = this.e.c();
                if (!this.e.b(this.c)) {
                    a.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.c, SectionPosition.a(this.d), i2});
                }
                PersistentEntitySectionManager.this.a(this.d, this.e);
                EntitySection entitysection = PersistentEntitySectionManager.this.f.c(i2);
                entitysection.a(this.c);
                this.e = entitysection;
                this.d = i2;
                this.a(visibility, entitysection.c());
            }
        }

        private void a(Visibility visibility, Visibility visibility1) {
            Visibility visibility3;
            Visibility visibility2 = PersistentEntitySectionManager.a(this.c, visibility);
            if (visibility2 == (visibility3 = PersistentEntitySectionManager.a(this.c, visibility1))) {
                if (visibility3.b()) {
                    PersistentEntitySectionManager.this.c.a(this.c);
                }
            } else {
                boolean flag = visibility2.b();
                boolean flag1 = visibility3.b();
                if (flag && !flag1) {
                    PersistentEntitySectionManager.this.f(this.c);
                } else if (!flag && flag1) {
                    PersistentEntitySectionManager.this.e(this.c);
                }
                boolean flag2 = visibility2.a();
                boolean flag3 = visibility3.a();
                if (flag2 && !flag3) {
                    PersistentEntitySectionManager.this.d(this.c);
                } else if (!flag2 && flag3) {
                    PersistentEntitySectionManager.this.c(this.c);
                }
                if (flag1) {
                    PersistentEntitySectionManager.this.c.a(this.c);
                }
            }
        }

        @Override
        public void a(Entity.RemovalReason entity_removalreason) {
            Visibility visibility;
            if (!this.e.b(this.c)) {
                a.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.c, SectionPosition.a(this.d), entity_removalreason});
            }
            if ((visibility = PersistentEntitySectionManager.a(this.c, this.e.c())).a()) {
                PersistentEntitySectionManager.this.d(this.c);
            }
            if (visibility.b()) {
                PersistentEntitySectionManager.this.f(this.c);
            }
            if (entity_removalreason.a()) {
                PersistentEntitySectionManager.this.c.f(this.c);
            }
            PersistentEntitySectionManager.this.b.remove(this.c.cT());
            this.c.a(a);
            PersistentEntitySectionManager.this.a(this.d, this.e);
        }
    }
}

