/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class FeatureCountTracker {
    private static final Logger a = LogUtils.getLogger();
    private static final LoadingCache<WorldServer, b> b = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<WorldServer, b>(){

        public b a(WorldServer var0) {
            return new b((Object2IntMap<a>)Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap()), new MutableInt(0));
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.a((WorldServer)object);
        }
    });

    public static void a(WorldServer var0) {
        try {
            ((b)b.get((Object)var0)).b().increment();
        }
        catch (Exception var1) {
            a.error("Failed to increment chunk count", (Throwable)var1);
        }
    }

    public static void a(WorldServer var02, WorldGenFeatureConfigured<?, ?> var12, Optional<PlacedFeature> var2) {
        try {
            ((b)b.get((Object)var02)).a().computeInt((Object)new a(var12, var2), (var0, var1) -> var1 == null ? 1 : var1 + 1);
        }
        catch (Exception var3) {
            a.error("Failed to increment feature count", (Throwable)var3);
        }
    }

    public static void a() {
        b.invalidateAll();
        a.debug("Cleared feature counts");
    }

    public static void b() {
        a.debug("Logging feature counts:");
        b.asMap().forEach((var0, var1) -> {
            String var2 = var0.al().a().toString();
            boolean var32 = var0.q().B();
            IRegistry<PlacedFeature> var42 = var0.L_().f(Registries.bj);
            String var5 = (var32 ? "running" : "dead") + " " + var2;
            Integer var6 = var1.b().getValue();
            a.debug("{} total_chunks: {}", (Object)var5, (Object)var6);
            var1.a().forEach((var3, var4) -> {
                Object[] objectArray = new Object[6];
                objectArray[0] = var5;
                objectArray[1] = String.format(Locale.ROOT, "%10d", var4);
                objectArray[2] = String.format(Locale.ROOT, "%10f", (double)var4.intValue() / (double)var6.intValue());
                objectArray[3] = var3.b().flatMap(var42::d).map(ResourceKey::a);
                objectArray[4] = var3.a().b();
                objectArray[5] = var3.a();
                a.debug("{} {} {} {} {} {}", objectArray);
            });
        });
    }

    record b(Object2IntMap<a> a, MutableInt b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "featureData;chunksWithFeatures", "a", "b"}, this, var0);
        }
    }

    record a(WorldGenFeatureConfigured<?, ?> a, Optional<PlacedFeature> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "feature;topFeature", "a", "b"}, this, var0);
        }
    }
}

