/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R6.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R6.map.RenderData;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger j = LogUtils.getLogger();
    private static final int k = 128;
    private static final int l = 64;
    public static final int a = 4;
    public static final int b = 256;
    private static final String m = "frame-";
    public static final Codec<WorldMap> c = RecordCodecBuilder.create(instance -> instance.group((App)World.g.fieldOf("dimension").forGetter(worldmap -> worldmap.f), (App)Codec.INT.fieldOf("xCenter").forGetter(worldmap -> worldmap.d), (App)Codec.INT.fieldOf("zCenter").forGetter(worldmap -> worldmap.e), (App)Codec.BYTE.optionalFieldOf("scale", (Object)0).forGetter(worldmap -> worldmap.g), (App)Codec.BYTE_BUFFER.fieldOf("colors").forGetter(worldmap -> ByteBuffer.wrap(worldmap.h)), (App)Codec.BOOL.optionalFieldOf("trackingPosition", (Object)true).forGetter(worldmap -> worldmap.n), (App)Codec.BOOL.optionalFieldOf("unlimitedTracking", (Object)false).forGetter(worldmap -> worldmap.o), (App)Codec.BOOL.optionalFieldOf("locked", (Object)false).forGetter(worldmap -> worldmap.i), (App)MapIconBanner.a.listOf().optionalFieldOf("banners", List.of()).forGetter(worldmap -> List.copyOf(worldmap.r.values())), (App)WorldMapFrame.a.listOf().optionalFieldOf("frames", List.of()).forGetter(worldmap -> List.copyOf(worldmap.t.values())), (App)Codec.LONG.optionalFieldOf("UUIDLeast", (Object)0L).forGetter(worldmap -> {
        UUID uuid = worldmap.updateUUID();
        return uuid != null ? uuid.getLeastSignificantBits() : 0L;
    }), (App)Codec.LONG.optionalFieldOf("UUIDMost", (Object)0L).forGetter(worldmap -> {
        UUID uuid = worldmap.updateUUID();
        return uuid != null ? uuid.getMostSignificantBits() : 0L;
    })).apply((Applicative)instance, WorldMap::new));
    public int d;
    public int e;
    public ResourceKey<World> f;
    public boolean n;
    public boolean o;
    public byte g;
    public byte[] h = new byte[16384];
    public boolean i;
    public final List<WorldMapHumanTracker> p = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> q = Maps.newHashMap();
    private final Map<String, MapIconBanner> r = Maps.newHashMap();
    public final Map<String, MapIcon> s = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> t = Maps.newHashMap();
    private int u;
    public final CraftMapView mapView;
    public UUID uniqueId = null;
    public MapId id;

    private static ResourceKey<World> getWorldKey(ResourceKey<World> resourcekey, long uuidLeast, long uuidMost) {
        UUID uniqueId;
        CraftWorld world;
        WorldServer lookup = MinecraftServer.getServer().a(resourcekey);
        if (lookup != null) {
            return resourcekey;
        }
        if (uuidLeast != 0L && uuidMost != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(uuidMost, uuidLeast)))) != null) {
            return world.getHandle().al();
        }
        throw new IllegalArgumentException("Invalid map dimension: " + String.valueOf(resourcekey));
    }

    @Nullable
    private UUID updateUUID() {
        WorldServer world;
        if (this.uniqueId == null && (world = MinecraftServer.getServer().a(this.f)) != null) {
            this.uniqueId = world.getWorld().getUID();
        }
        return this.uniqueId;
    }

    public static SavedDataType<WorldMap> a(MapId mapid) {
        return new SavedDataType<WorldMap>(mapid.a(), () -> {
            throw new IllegalStateException("Should never create an empty map saved data");
        }, c, DataFixTypes.k);
    }

    private WorldMap(int i2, int j2, byte b0, boolean flag, boolean flag1, boolean flag2, ResourceKey<World> resourcekey) {
        this.g = b0;
        this.d = i2;
        this.e = j2;
        this.f = resourcekey;
        this.n = flag;
        this.o = flag1;
        this.i = flag2;
        this.updateUUID();
        this.mapView = new CraftMapView(this);
    }

    private WorldMap(ResourceKey<World> resourcekey, int i2, int j2, byte b0, ByteBuffer bytebuffer, boolean flag, boolean flag1, boolean flag2, List<MapIconBanner> list, List<WorldMapFrame> list1, long uuidLeast, long uuidMost) {
        this(i2, j2, (byte)MathHelper.a((int)b0, 0, 4), flag, flag1, flag2, WorldMap.getWorldKey(resourcekey, uuidLeast, uuidMost));
        if (bytebuffer.array().length == 16384) {
            this.h = bytebuffer.array();
        }
        for (MapIconBanner mapiconbanner : list) {
            this.r.put(mapiconbanner.b(), mapiconbanner);
            this.a(mapiconbanner.a(), null, mapiconbanner.b(), mapiconbanner.c().u(), mapiconbanner.c().w(), 180.0, mapiconbanner.e().orElse(null));
        }
        for (WorldMapFrame worldmapframe : list1) {
            this.t.put(worldmapframe.a(), worldmapframe);
            this.a(MapDecorationTypes.b, null, WorldMap.b(worldmapframe.d()), worldmapframe.b().u(), worldmapframe.b().w(), worldmapframe.c(), null);
        }
    }

    public static WorldMap a(double d0, double d1, byte b0, boolean flag, boolean flag1, ResourceKey<World> resourcekey) {
        int i2 = 128 * (1 << b0);
        int j2 = MathHelper.a((d0 + 64.0) / (double)i2);
        int k2 = MathHelper.a((d1 + 64.0) / (double)i2);
        int l2 = j2 * i2 + i2 / 2 - 64;
        int i1 = k2 * i2 + i2 / 2 - 64;
        return new WorldMap(l2, i1, b0, flag, flag1, false, resourcekey);
    }

    public static WorldMap a(byte b0, boolean flag, ResourceKey<World> resourcekey) {
        return new WorldMap(0, 0, b0, false, false, flag, resourcekey);
    }

    public WorldMap a() {
        WorldMap worldmap = new WorldMap(this.d, this.e, this.g, this.n, this.o, true, this.f);
        worldmap.r.putAll(this.r);
        worldmap.s.putAll(this.s);
        worldmap.u = this.u;
        System.arraycopy(this.h, 0, worldmap.h, 0, this.h.length);
        return worldmap;
    }

    public WorldMap b() {
        return WorldMap.a(this.d, this.e, (byte)MathHelper.a(this.g + 1, 0, 4), this.n, this.o, this.f);
    }

    private static Predicate<ItemStack> a(ItemStack itemstack) {
        MapId mapid = itemstack.a(DataComponents.M);
        return itemstack1 -> itemstack1 == itemstack ? true : itemstack1.a(itemstack.h()) && Objects.equals(mapid, itemstack1.a(DataComponents.M));
    }

    public void a(EntityHuman entityhuman, ItemStack itemstack) {
        if (!this.q.containsKey(entityhuman)) {
            WorldMapHumanTracker worldmap_worldmaphumantracker = new WorldMapHumanTracker(entityhuman);
            this.q.put(entityhuman, worldmap_worldmaphumantracker);
            this.p.add(worldmap_worldmaphumantracker);
        }
        Predicate<ItemStack> predicate = WorldMap.a(itemstack);
        if (!entityhuman.gB().b(predicate)) {
            this.a(entityhuman.ap());
        }
        for (int i2 = 0; i2 < this.p.size(); ++i2) {
            WorldMapHumanTracker worldmap_worldmaphumantracker1 = this.p.get(i2);
            EntityHuman entityhuman1 = worldmap_worldmaphumantracker1.a;
            String s2 = entityhuman1.ap();
            if (!entityhuman1.ec() && (entityhuman1.gB().b(predicate) || itemstack.H())) {
                if (!itemstack.H() && entityhuman1.an().al() == this.f && this.n) {
                    this.a(MapDecorationTypes.a, entityhuman1.an(), s2, entityhuman1.dK(), entityhuman1.dQ(), entityhuman1.dX(), null);
                }
            } else {
                this.q.remove(entityhuman1);
                this.p.remove(worldmap_worldmaphumantracker1);
                this.a(s2);
            }
            if (entityhuman1.equals(entityhuman) || !WorldMap.b(entityhuman1)) continue;
            this.a(s2);
        }
        if (itemstack.H() && this.n) {
            EntityItemFrame entityitemframe = itemstack.I();
            BlockPosition blockposition = entityitemframe.i();
            WorldMapFrame worldmapframe = this.t.get(WorldMapFrame.a(blockposition));
            if (worldmapframe != null && entityitemframe.az() != worldmapframe.d() && this.t.containsKey(worldmapframe.a())) {
                this.a(WorldMap.b(worldmapframe.d()));
            }
            WorldMapFrame worldmapframe1 = new WorldMapFrame(blockposition, entityitemframe.db().e() * 90, entityitemframe.az());
            this.a(MapDecorationTypes.b, entityhuman.an(), WorldMap.b(entityitemframe.az()), blockposition.u(), blockposition.w(), entityitemframe.db().e() * 90, null);
            WorldMapFrame worldmapframe2 = this.t.put(worldmapframe1.a(), worldmapframe1);
            if (!worldmapframe1.equals(worldmapframe2)) {
                this.t();
            }
        }
        MapDecorations mapdecorations = itemstack.a(DataComponents.N, MapDecorations.a);
        if (!this.s.keySet().containsAll(mapdecorations.a().keySet())) {
            mapdecorations.a().forEach((s1, mapdecorations_a) -> {
                if (!this.s.containsKey(s1)) {
                    this.a(mapdecorations_a.a(), entityhuman.an(), (String)s1, mapdecorations_a.b(), mapdecorations_a.c(), mapdecorations_a.d(), null);
                }
            });
        }
    }

    private static boolean b(EntityHuman entityhuman) {
        for (EnumItemSlot enumitemslot : EnumItemSlot.values()) {
            if (enumitemslot == EnumItemSlot.a || enumitemslot == EnumItemSlot.b || !entityhuman.a(enumitemslot).a(TagsItem.cG)) continue;
            return true;
        }
        return false;
    }

    private void a(String s2) {
        MapIcon mapicon = this.s.remove(s2);
        if (mapicon != null && mapicon.c().a().f()) {
            --this.u;
        }
        this.f();
    }

    public static void a(ItemStack itemstack, BlockPosition blockposition, String s2, Holder<MapDecorationType> holder) {
        MapDecorations.a mapdecorations_a = new MapDecorations.a(holder, blockposition.u(), blockposition.w(), 180.0f);
        itemstack.a(DataComponents.N, MapDecorations.a, mapdecorations -> mapdecorations.a(s2, mapdecorations_a));
        if (holder.a().a()) {
            itemstack.b(DataComponents.L, new MapItemColor(holder.a().d()));
        }
    }

    private void a(Holder<MapDecorationType> holder, @Nullable GeneratorAccess generatoraccess, String s2, double d0, double d1, double d2, @Nullable IChatBaseComponent ichatbasecomponent) {
        int i2 = 1 << this.g;
        float f2 = (float)(d0 - (double)this.d) / (float)i2;
        float f1 = (float)(d1 - (double)this.e) / (float)i2;
        b worldmap_b = this.a(holder, generatoraccess, d2, f2, f1);
        if (worldmap_b == null) {
            this.a(s2);
        } else {
            MapIcon mapicon1;
            MapIcon mapicon = new MapIcon(worldmap_b.a(), worldmap_b.b(), worldmap_b.c(), worldmap_b.d(), Optional.ofNullable(ichatbasecomponent));
            if (!mapicon.equals(mapicon1 = this.s.put(s2, mapicon))) {
                if (mapicon1 != null && mapicon1.c().a().f()) {
                    --this.u;
                }
                if (worldmap_b.a().a().f()) {
                    ++this.u;
                }
                this.f();
            }
        }
    }

    @Nullable
    private b a(Holder<MapDecorationType> holder, @Nullable GeneratorAccess generatoraccess, double d0, float f2, float f1) {
        byte b0 = WorldMap.a(f2);
        byte b1 = WorldMap.a(f1);
        if (holder.a(MapDecorationTypes.a)) {
            Pair<Holder<MapDecorationType>, Byte> pair = this.b(holder, generatoraccess, d0, f2, f1);
            return pair == null ? null : new b((Holder)pair.getFirst(), b0, b1, (Byte)pair.getSecond());
        }
        return !WorldMap.a(f2, f1) && !this.o ? null : new b(holder, b0, b1, this.a(generatoraccess, d0));
    }

    @Nullable
    private Pair<Holder<MapDecorationType>, Byte> b(Holder<MapDecorationType> holder, @Nullable GeneratorAccess generatoraccess, double d0, float f2, float f1) {
        if (WorldMap.a(f2, f1)) {
            return Pair.of(holder, (Object)this.a(generatoraccess, d0));
        }
        Holder<MapDecorationType> holder1 = this.b(f2, f1);
        return holder1 == null ? null : Pair.of(holder1, (Object)0);
    }

    private byte a(@Nullable GeneratorAccess generatoraccess, double d0) {
        if (this.f == World.i && generatoraccess != null) {
            int i2 = (int)(generatoraccess.F_().c() / 10L);
            return (byte)(i2 * i2 * 34187121 + i2 * 121 >> 15 & 0xF);
        }
        double d1 = d0 < 0.0 ? d0 - 8.0 : d0 + 8.0;
        return (byte)(d1 * 16.0 / 360.0);
    }

    private static boolean a(float f2, float f1) {
        int i2 = 63;
        return f2 >= -63.0f && f1 >= -63.0f && f2 <= 63.0f && f1 <= 63.0f;
    }

    @Nullable
    private Holder<MapDecorationType> b(float f2, float f1) {
        boolean flag;
        int i2 = 320;
        boolean bl = flag = Math.abs(f2) < 320.0f && Math.abs(f1) < 320.0f;
        return flag ? MapDecorationTypes.g : (this.o ? MapDecorationTypes.h : null);
    }

    private static byte a(float f2) {
        int i2 = 63;
        return (byte)(f2 <= -63.0f ? -128 : (byte)(f2 >= 63.0f ? 127 : (byte)((double)(f2 * 2.0f) + 0.5)));
    }

    @Nullable
    public Packet<?> a(MapId mapid, EntityHuman entityhuman) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.q.get(entityhuman);
        return worldmap_worldmaphumantracker == null ? null : worldmap_worldmaphumantracker.a(mapid);
    }

    public void a(int i2, int j2) {
        this.t();
        for (WorldMapHumanTracker worldmap_worldmaphumantracker : this.p) {
            worldmap_worldmaphumantracker.a(i2, j2);
        }
    }

    public void f() {
        this.p.forEach(WorldMapHumanTracker::b);
    }

    public WorldMapHumanTracker a(EntityHuman entityhuman) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.q.get(entityhuman);
        if (worldmap_worldmaphumantracker == null) {
            worldmap_worldmaphumantracker = new WorldMapHumanTracker(entityhuman);
            this.q.put(entityhuman, worldmap_worldmaphumantracker);
            this.p.add(worldmap_worldmaphumantracker);
        }
        return worldmap_worldmaphumantracker;
    }

    public boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        double d0 = (double)blockposition.u() + 0.5;
        double d1 = (double)blockposition.w() + 0.5;
        int i2 = 1 << this.g;
        double d2 = (d0 - (double)this.d) / (double)i2;
        double d3 = (d1 - (double)this.e) / (double)i2;
        int j2 = 63;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapIconBanner mapiconbanner = MapIconBanner.a(generatoraccess, blockposition);
            if (mapiconbanner == null) {
                return false;
            }
            if (this.r.remove(mapiconbanner.b(), mapiconbanner)) {
                this.a(mapiconbanner.b());
                this.t();
                return true;
            }
            if (!this.a(256)) {
                this.r.put(mapiconbanner.b(), mapiconbanner);
                this.a(mapiconbanner.a(), generatoraccess, mapiconbanner.b(), d0, d1, 180.0, mapiconbanner.e().orElse(null));
                this.t();
                return true;
            }
        }
        return false;
    }

    public void a(IBlockAccess iblockaccess, int i2, int j2) {
        Iterator<MapIconBanner> iterator = this.r.values().iterator();
        while (iterator.hasNext()) {
            MapIconBanner mapiconbanner1;
            MapIconBanner mapiconbanner = iterator.next();
            if (mapiconbanner.c().u() != i2 || mapiconbanner.c().w() != j2 || mapiconbanner.equals(mapiconbanner1 = MapIconBanner.a(iblockaccess, mapiconbanner.c()))) continue;
            iterator.remove();
            this.a(mapiconbanner.b());
            this.t();
        }
    }

    public Collection<MapIconBanner> c() {
        return this.r.values();
    }

    public void a(BlockPosition blockposition, int i2) {
        this.a(WorldMap.b(i2));
        this.t.remove(WorldMapFrame.a(blockposition));
        this.t();
    }

    public boolean a(int i2, int j2, byte b0) {
        byte b1 = this.h[i2 + j2 * 128];
        if (b1 != b0) {
            this.b(i2, j2, b0);
            return true;
        }
        return false;
    }

    public void b(int i2, int j2, byte b0) {
        this.h[i2 + j2 * 128] = b0;
        this.a(i2, j2);
    }

    public boolean d() {
        for (MapIcon mapicon : this.s.values()) {
            if (!mapicon.c().a().e()) continue;
            return true;
        }
        return false;
    }

    public void a(List<MapIcon> list) {
        this.s.clear();
        this.u = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MapIcon mapicon = list.get(i2);
            this.s.put("icon-" + i2, mapicon);
            if (!mapicon.c().a().f()) continue;
            ++this.u;
        }
    }

    public Iterable<MapIcon> e() {
        return this.s.values();
    }

    public boolean a(int i2) {
        return this.u >= i2;
    }

    private static String b(int i2) {
        return m + i2;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman a;
        private boolean d = true;
        private int e;
        private int f;
        private int g = 127;
        private int h = 127;
        private boolean i = true;
        private int j;
        public int b;

        WorldMapHumanTracker(EntityHuman entityhuman) {
            this.a = entityhuman;
        }

        private c createPatch(byte[] buffer) {
            int i2 = this.e;
            int j2 = this.f;
            int k2 = this.g + 1 - this.e;
            int l2 = this.h + 1 - this.f;
            byte[] abyte = new byte[k2 * l2];
            for (int i1 = 0; i1 < k2; ++i1) {
                for (int j1 = 0; j1 < l2; ++j1) {
                    abyte[i1 + j1 * k2] = buffer[i2 + i1 + (j2 + j1) * 128];
                }
            }
            return new c(i2, j2, k2, l2, abyte);
        }

        @Nullable
        Packet<?> a(MapId mapid) {
            ArrayList<MapIcon> collection;
            c worldmap_c;
            RenderData render = WorldMap.this.mapView.render((CraftPlayer)this.a.getBukkitEntity());
            if (this.d) {
                this.d = false;
                worldmap_c = this.createPatch(render.buffer);
            } else {
                worldmap_c = null;
            }
            if (this.j++ % 5 == 0) {
                this.i = false;
                ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapIcon(CraftMapCursor.CraftType.bukkitToMinecraftHolder(cursor.getType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrOptional(cursor.getCaption())));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && worldmap_c == null ? null : new PacketPlayOutMap(mapid, WorldMap.this.g, WorldMap.this.i, collection, worldmap_c);
        }

        void a(int i2, int j2) {
            if (this.d) {
                this.e = Math.min(this.e, i2);
                this.f = Math.min(this.f, j2);
                this.g = Math.max(this.g, i2);
                this.h = Math.max(this.h, j2);
            } else {
                this.d = true;
                this.e = i2;
                this.f = j2;
                this.g = i2;
                this.h = j2;
            }
        }

        private void b() {
            this.i = true;
        }
    }

    private record b(Holder<MapDecorationType> a, byte b, byte c, byte d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "type;x;y;rot", "a", "b", "c", "d"}, this, o2);
        }
    }

    public static final class c
    extends Record {
        private final int b;
        private final int c;
        private final int d;
        private final int e;
        private final byte[] f;
        public static final StreamCodec<ByteBuf, Optional<c>> a = StreamCodec.a(c::a, c::a);

        public c(int startX, int startY, int width, int height, byte[] mapColors) {
            this.b = startX;
            this.c = startY;
            this.d = width;
            this.e = height;
            this.f = mapColors;
        }

        private static void a(ByteBuf bytebuf, Optional<c> optional) {
            if (optional.isPresent()) {
                c worldmap_c = optional.get();
                bytebuf.writeByte(worldmap_c.d);
                bytebuf.writeByte(worldmap_c.e);
                bytebuf.writeByte(worldmap_c.b);
                bytebuf.writeByte(worldmap_c.c);
                PacketDataSerializer.a(bytebuf, worldmap_c.f);
            } else {
                bytebuf.writeByte(0);
            }
        }

        private static Optional<c> a(ByteBuf bytebuf) {
            short i2 = bytebuf.readUnsignedByte();
            if (i2 > 0) {
                short j2 = bytebuf.readUnsignedByte();
                short k2 = bytebuf.readUnsignedByte();
                short l2 = bytebuf.readUnsignedByte();
                byte[] abyte = PacketDataSerializer.a(bytebuf);
                return Optional.of(new c(k2, l2, i2, j2, abyte));
            }
            return Optional.empty();
        }

        public void a(WorldMap worldmap) {
            for (int i2 = 0; i2 < this.d; ++i2) {
                for (int j2 = 0; j2 < this.e; ++j2) {
                    worldmap.b(this.b + i2, this.c + j2, this.f[i2 + j2 * this.d]);
                }
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "startX;startY;width;height;mapColors", "b", "c", "d", "e", "f"}, this, o2);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public int c() {
            return this.d;
        }

        public int d() {
            return this.e;
        }

        public byte[] e() {
            return this.f;
        }
    }
}

