/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMainHand;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Pose;
import org.bukkit.entity.model.PlayerModelPart;
import org.bukkit.inventory.MainHand;
import org.bukkit.profile.PlayerProfile;

public class CraftMannequin
extends CraftLivingEntity
implements Mannequin {
    public CraftMannequin(CraftServer server, net.minecraft.world.entity.decoration.Mannequin entity) {
        super(server, entity);
    }

    @Override
    public String toString() {
        return "CraftMannequin";
    }

    @Override
    public net.minecraft.world.entity.decoration.Mannequin getHandle() {
        return (net.minecraft.world.entity.decoration.Mannequin)super.getHandle();
    }

    public MainHand getMainHand() {
        return this.getHandle().as() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT;
    }

    public void setMainHand(MainHand hand) {
        Preconditions.checkArgument((hand != null ? 1 : 0) != 0, (Object)"hand cannot be null");
        this.getHandle().a(hand == MainHand.LEFT ? EnumMainHand.a : EnumMainHand.b);
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null");
        net.minecraft.world.entity.player.PlayerModelPart nms = net.minecraft.world.entity.player.PlayerModelPart.valueOf(part.name());
        return this.getHandle().a(nms);
    }

    public void setModelPartShown(PlayerModelPart part, boolean shown) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null");
        net.minecraft.world.entity.player.PlayerModelPart nms = net.minecraft.world.entity.player.PlayerModelPart.valueOf(part.name());
        byte flags = this.getHandle().aC().a(Avatar.t);
        flags = shown ? (byte)(flags | nms.a()) : (byte)(flags & ~nms.a());
        this.getHandle().aC().a(Avatar.t, flags);
    }

    public PlayerProfile getPlayerProfile() {
        return this.getHandle().k().equals(net.minecraft.world.entity.decoration.Mannequin.c) ? null : new CraftPlayerProfile(this.getHandle().k());
    }

    public void setPlayerProfile(PlayerProfile profile) {
        if (profile instanceof CraftPlayerProfile) {
            CraftPlayerProfile craftPlayerProfile = (CraftPlayerProfile)profile;
            this.getHandle().a(craftPlayerProfile.buildResolvableProfile());
        } else {
            this.getHandle().a(net.minecraft.world.entity.decoration.Mannequin.c);
        }
    }

    public void setPose(Pose pose) {
        Preconditions.checkArgument((pose != null ? 1 : 0) != 0, (Object)"pose cannot be null");
        EntityPose nmsPose = EntityPose.values()[pose.ordinal()];
        Preconditions.checkArgument((boolean)net.minecraft.world.entity.decoration.Mannequin.h.contains(nmsPose));
        this.getHandle().c(nmsPose);
    }

    public boolean isImmovable() {
        return this.getHandle().n();
    }

    public void setImmovable(boolean immovable) {
        this.getHandle().a(immovable);
    }

    public String getDescripion() {
        IChatBaseComponent description = this.getHandle().cg;
        return description != null ? CraftChatMessage.fromComponent(description) : null;
    }

    public void setDescription(String description) {
        if (description != null) {
            this.getHandle().a(CraftChatMessage.fromStringOrNull(description));
        } else {
            this.getHandle().a(net.minecraft.world.entity.decoration.Mannequin.j);
        }
    }

    public boolean isHideDescription() {
        return this.getHandle().ch;
    }

    public void setHideDescription(boolean hide) {
        this.getHandle().b(hide);
    }
}

