/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.generator;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;

@Deprecated
public final class OldCraftChunkData
implements ChunkGenerator.ChunkData {
    private final int minHeight;
    private final int maxHeight;
    private final ChunkSection[] sections;
    private final PalettedContainerFactory biomes;
    private Set<BlockPosition> tiles;
    private final Set<BlockPosition> lights = new HashSet<BlockPosition>();

    public OldCraftChunkData(int minHeight, int maxHeight, PalettedContainerFactory biomes) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.biomes = biomes;
        this.sections = new ChunkSection[(maxHeight - 1 >> 4) + 1 - (minHeight >> 4)];
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public Biome getBiome(int x2, int y2, int z2) {
        throw new UnsupportedOperationException("Unsupported, in older chunk generator api");
    }

    public void setBlock(int x2, int y2, int z2, Material material) {
        this.setBlock(x2, y2, z2, material.createBlockData());
    }

    public void setBlock(int x2, int y2, int z2, MaterialData material) {
        this.setBlock(x2, y2, z2, CraftMagicNumbers.getBlock(material));
    }

    public void setBlock(int x2, int y2, int z2, BlockData blockData) {
        this.setBlock(x2, y2, z2, ((CraftBlockData)blockData).getState());
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Material material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, material.createBlockData());
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, MaterialData material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, CraftMagicNumbers.getBlock(material));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockData blockData) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, ((CraftBlockData)blockData).getState());
    }

    public Material getType(int x2, int y2, int z2) {
        return CraftBlockType.minecraftToBukkit(this.getTypeId(x2, y2, z2).b());
    }

    public MaterialData getTypeAndData(int x2, int y2, int z2) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x2, y2, z2));
    }

    public BlockData getBlockData(int x2, int y2, int z2) {
        return CraftBlockData.fromData(this.getTypeId(x2, y2, z2));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IBlockData type) {
        if (xMin > 15 || yMin >= this.maxHeight || zMin > 15) {
            return;
        }
        if (xMin < 0) {
            xMin = 0;
        }
        if (yMin < this.minHeight) {
            yMin = this.minHeight;
        }
        if (zMin < 0) {
            zMin = 0;
        }
        if (xMax > 16) {
            xMax = 16;
        }
        if (yMax > this.maxHeight) {
            yMax = this.maxHeight;
        }
        if (zMax > 16) {
            zMax = 16;
        }
        if (xMin >= xMax || yMin >= yMax || zMin >= zMax) {
            return;
        }
        for (int y2 = yMin; y2 < yMax; ++y2) {
            ChunkSection section = this.getChunkSection(y2, true);
            int offsetBase = y2 & 0xF;
            for (int x2 = xMin; x2 < xMax; ++x2) {
                for (int z2 = zMin; z2 < zMax; ++z2) {
                    section.a(x2, offsetBase, z2, type);
                }
            }
        }
    }

    public IBlockData getTypeId(int x2, int y2, int z2) {
        if (x2 != (x2 & 0xF) || y2 < this.minHeight || y2 >= this.maxHeight || z2 != (z2 & 0xF)) {
            return Blocks.a.m();
        }
        ChunkSection section = this.getChunkSection(y2, false);
        if (section == null) {
            return Blocks.a.m();
        }
        return section.a(x2, y2 & 0xF, z2);
    }

    public byte getData(int x2, int y2, int z2) {
        return CraftMagicNumbers.toLegacyData(this.getTypeId(x2, y2, z2));
    }

    private void setBlock(int x2, int y2, int z2, IBlockData type) {
        if (x2 != (x2 & 0xF) || y2 < this.minHeight || y2 >= this.maxHeight || z2 != (z2 & 0xF)) {
            return;
        }
        ChunkSection section = this.getChunkSection(y2, true);
        section.a(x2, y2 & 0xF, z2, type);
        if (type.k() > 0) {
            this.lights.add(new BlockPosition(x2, y2, z2));
        } else {
            this.lights.remove(new BlockPosition(x2, y2, z2));
        }
        if (type.x()) {
            if (this.tiles == null) {
                this.tiles = new HashSet<BlockPosition>();
            }
            this.tiles.add(new BlockPosition(x2, y2, z2));
        }
    }

    private ChunkSection getChunkSection(int y2, boolean create) {
        int offset = y2 - this.minHeight >> 4;
        ChunkSection section = this.sections[offset];
        if (create && section == null) {
            this.sections[offset] = section = new ChunkSection(this.biomes);
        }
        return section;
    }

    ChunkSection[] getRawChunkData() {
        return this.sections;
    }

    Set<BlockPosition> getTiles() {
        return this.tiles;
    }

    Set<BlockPosition> getLights() {
        return this.lights;
    }
}

