/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.component.ResolvableProfile;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaSkull
extends CraftMetaItem
implements SkullMeta {
    static final CraftMetaItem.ItemMetaKeyType<ResolvableProfile> SKULL_PROFILE = new CraftMetaItem.ItemMetaKeyType<ResolvableProfile>(DataComponents.ak, "SkullProfile");
    static final ItemMetaKey SKULL_OWNER = new ItemMetaKey("skull-owner");
    static final ItemMetaKey BLOCK_ENTITY_TAG = new ItemMetaKey("BlockEntityTag");
    static final CraftMetaItem.ItemMetaKeyType<MinecraftKey> NOTE_BLOCK_SOUND = new CraftMetaItem.ItemMetaKeyType<MinecraftKey>(DataComponents.al, "note_block_sound");
    static final int MAX_OWNER_LENGTH = 16;
    private ResolvableProfile profile;
    private MinecraftKey noteBlockSound;

    CraftMetaSkull(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSkull)) {
            return;
        }
        CraftMetaSkull skullMeta = (CraftMetaSkull)meta;
        this.setProfile(skullMeta.profile);
        this.noteBlockSound = skullMeta.noteBlockSound;
    }

    CraftMetaSkull(DataComponentPatch tag) {
        super(tag);
        CraftMetaSkull.getOrEmpty(tag, SKULL_PROFILE).ifPresent(this::setProfile);
        CraftMetaSkull.getOrEmpty(tag, NOTE_BLOCK_SOUND).ifPresent(minecraftKey -> {
            this.noteBlockSound = minecraftKey;
        });
    }

    CraftMetaSkull(Map<String, Object> map) {
        super(map);
        Object object;
        if (this.profile == null) {
            object = map.get(CraftMetaSkull.SKULL_OWNER.BUKKIT);
            if (object instanceof PlayerProfile) {
                PlayerProfile playerProfile = (PlayerProfile)object;
                this.setOwnerProfile(playerProfile);
            } else {
                this.setOwner(SerializableMeta.getString(map, CraftMetaSkull.SKULL_OWNER.BUKKIT, true));
            }
        }
        if (this.noteBlockSound == null && (object = map.get(CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT)) != null) {
            this.setNoteBlockSound(NamespacedKey.fromString((String)object.toString()));
        }
    }

    @Override
    void deserializeInternal(NBTTagCompound tag, Object context) {
        super.deserializeInternal(tag, context);
        tag.m(CraftMetaSkull.SKULL_PROFILE.NBT).ifPresent(skullTag -> {
            skullTag.i("Id").ifPresent(id -> {
                UUID uuid = UUID.fromString(id);
                skullTag.a("Id", UUIDUtil.a, uuid);
            });
            ResolvableProfile.a.parse((DynamicOps)DynamicOpsNBT.a, skullTag).result().ifPresent(this::setProfile);
        });
        tag.m(CraftMetaSkull.BLOCK_ENTITY_TAG.NBT).flatMap(nbtTagCompound -> nbtTagCompound.i(CraftMetaSkull.NOTE_BLOCK_SOUND.NBT)).ifPresent(noteBlockSound -> {
            this.noteBlockSound = MinecraftKey.c(noteBlockSound);
        });
    }

    private void setProfile(ResolvableProfile profile) {
        this.profile = profile;
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.hasOwner()) {
            CraftPlayerProfile ownerProfile;
            tag.put(SKULL_PROFILE, this.profile);
            if (!(this.profile instanceof ResolvableProfile.Dynamic) && (ownerProfile = new CraftPlayerProfile(this.profile)).getTextures().isEmpty()) {
                ownerProfile.update().thenAccept(filledProfile -> {
                    this.setOwnerProfile((PlayerProfile)filledProfile);
                    tag.put(SKULL_PROFILE, this.profile);
                });
            }
        }
        if (this.noteBlockSound != null) {
            tag.put(NOTE_BLOCK_SOUND, this.noteBlockSound);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isSkullEmpty();
    }

    boolean isSkullEmpty() {
        return this.profile == null && this.noteBlockSound == null;
    }

    @Override
    public CraftMetaSkull clone() {
        return (CraftMetaSkull)super.clone();
    }

    public boolean hasOwner() {
        return this.profile != null;
    }

    public String getOwner() {
        return this.hasOwner() ? (String)this.profile.d().orElse(null) : null;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            if (!this.profile.b().id().equals(SystemUtils.e)) {
                return Bukkit.getOfflinePlayer((UUID)this.profile.b().id());
            }
            if (this.profile.d().filter(s2 -> !s2.isEmpty()).isPresent()) {
                return Bukkit.getOfflinePlayer((String)this.profile.d().get());
            }
        }
        return null;
    }

    public boolean setOwner(String name) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (name == null) {
            this.setProfile(null);
        } else {
            this.setProfile(ResolvableProfile.a(new GameProfile(SystemUtils.e, name)));
        }
        return true;
    }

    public boolean setOwningPlayer(OfflinePlayer owner) {
        if (owner == null) {
            this.setProfile(null);
        } else if (owner instanceof CraftPlayer) {
            CraftPlayer craftPlayer = (CraftPlayer)owner;
            this.setProfile(ResolvableProfile.a(craftPlayer.getProfile()));
        } else {
            this.setProfile(ResolvableProfile.a(new GameProfile(owner.getUniqueId(), owner.getName() == null ? "" : owner.getName())));
        }
        return true;
    }

    public PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    public void setOwnerProfile(PlayerProfile profile) {
        if (profile instanceof CraftPlayerProfile) {
            CraftPlayerProfile craftPlayerProfile = (CraftPlayerProfile)profile;
            this.setProfile(CraftPlayerProfile.validateSkullProfile(craftPlayerProfile.buildResolvableProfile()));
        } else {
            this.setProfile(null);
        }
    }

    public void setNoteBlockSound(NamespacedKey noteBlockSound) {
        this.noteBlockSound = noteBlockSound == null ? null : CraftNamespacedKey.toMinecraft(noteBlockSound);
    }

    public NamespacedKey getNoteBlockSound() {
        return this.noteBlockSound == null ? null : CraftNamespacedKey.fromMinecraft(this.noteBlockSound);
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasOwner()) {
            hash = 61 * hash + this.profile.hashCode();
        }
        if (this.noteBlockSound != null) {
            hash = 61 * hash + this.noteBlockSound.hashCode();
        }
        return original != hash ? CraftMetaSkull.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSkull) {
            CraftMetaSkull that = (CraftMetaSkull)meta;
            return Objects.equals(this.profile, that.profile) && Objects.equals(this.noteBlockSound, that.noteBlockSound);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSkull || this.isSkullEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        NamespacedKey namespacedKeyNB;
        super.serialize(builder);
        if (this.hasOwner()) {
            builder.put((Object)CraftMetaSkull.SKULL_OWNER.BUKKIT, (Object)new CraftPlayerProfile(this.profile));
        }
        if ((namespacedKeyNB = this.getNoteBlockSound()) != null) {
            builder.put((Object)CraftMetaSkull.NOTE_BLOCK_SOUND.BUKKIT, (Object)namespacedKeyNB.toString());
        }
        return builder;
    }
}

