/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory.util;

import java.util.function.Supplier;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.inventory.ContainerStonecutter;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftAccessLocationInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftBlockEntityInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftDoubleChestInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftMerchantInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftStandardInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.BeaconView;
import org.bukkit.inventory.view.BrewingStandView;
import org.bukkit.inventory.view.CrafterView;
import org.bukkit.inventory.view.EnchantmentView;
import org.bukkit.inventory.view.FurnaceView;
import org.bukkit.inventory.view.LecternView;
import org.bukkit.inventory.view.LoomView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.inventory.view.StonecutterView;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;

public final class CraftMenus {
    public static void openMerchantMenu(EntityPlayer player, ContainerMerchant merchant) {
        IMerchant minecraftMerchant = ((CraftMerchant)merchant.getBukkitView().getMerchant()).getMerchant();
        int level = 1;
        if (minecraftMerchant instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)minecraftMerchant;
            level = villager.gR().c();
        }
        if (minecraftMerchant.gI() != null) {
            minecraftMerchant.gI().r();
        }
        minecraftMerchant.g(player);
        player.g.b(new PacketPlayOutOpenWindow(merchant.l, Containers.t, merchant.getTitle()));
        player.cl = merchant;
        player.a(merchant);
        MerchantRecipeList merchantrecipelist = minecraftMerchant.gK();
        if (!merchantrecipelist.isEmpty()) {
            player.a(merchant.l, merchantrecipelist, level, minecraftMerchant.s(), minecraftMerchant.gL(), minecraftMerchant.gU());
        }
    }

    public static <V extends InventoryView, B extends InventoryViewBuilder<V>> MenuTypeData<V, B> getMenuTypeData(CraftMenuType<?, ?> menuType) {
        Containers handle = (Containers)menuType.getHandle();
        if (menuType == MenuType.GENERIC_9X6) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftDoubleChestInventoryViewBuilder>(InventoryView.class, () -> new CraftDoubleChestInventoryViewBuilder(handle)));
        }
        if (menuType == MenuType.GENERIC_9X3) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.cS, null)));
        }
        if (menuType == MenuType.GENERIC_3X3) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.bb, TileEntityDispenser::new)));
        }
        if (menuType == MenuType.CRAFTER_3X3) {
            return CraftMenus.asType(new MenuTypeData<CrafterView, CraftBlockEntityInventoryViewBuilder>(CrafterView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.uP, CrafterBlockEntity::new)));
        }
        if (menuType == MenuType.ANVIL) {
            return CraftMenus.asType(new MenuTypeData<AnvilView, CraftAccessLocationInventoryViewBuilder>(AnvilView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, ContainerAnvil::new)));
        }
        if (menuType == MenuType.BEACON) {
            return CraftMenus.asType(new MenuTypeData<BeaconView, CraftBlockEntityInventoryViewBuilder>(BeaconView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.gD, TileEntityBeacon::new)));
        }
        if (menuType == MenuType.BLAST_FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.oT, TileEntityBlastFurnace::new)));
        }
        if (menuType == MenuType.BREWING_STAND) {
            return CraftMenus.asType(new MenuTypeData<BrewingStandView, CraftBlockEntityInventoryViewBuilder>(BrewingStandView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.gh, TileEntityBrewingStand::new)));
        }
        if (menuType == MenuType.CRAFTING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, ContainerWorkbench::new)));
        }
        if (menuType == MenuType.ENCHANTMENT) {
            return CraftMenus.asType(new MenuTypeData<EnchantmentView, CraftAccessLocationInventoryViewBuilder>(EnchantmentView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, ContainerEnchantTable::new)));
        }
        if (menuType == MenuType.FURNACE) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.da, TileEntityFurnaceFurnace::new)));
        }
        if (menuType == MenuType.GRINDSTONE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, ContainerGrindstone::new)));
        }
        if (menuType == MenuType.HOPPER) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.hT, TileEntityHopper::new)));
        }
        if (menuType == MenuType.LECTERN) {
            return CraftMenus.asType(new MenuTypeData<LecternView, CraftBlockEntityInventoryViewBuilder>(LecternView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.oX, TileEntityLectern::new)));
        }
        if (menuType == MenuType.LOOM) {
            return CraftMenus.asType(new MenuTypeData<LoomView, CraftStandardInventoryViewBuilder>(LoomView.class, () -> new CraftStandardInventoryViewBuilder(handle)));
        }
        if (menuType == MenuType.MERCHANT) {
            return CraftMenus.asType(new MenuTypeData<MerchantView, CraftMerchantInventoryViewBuilder>(MerchantView.class, () -> new CraftMerchantInventoryViewBuilder(handle)));
        }
        if (menuType == MenuType.SHULKER_BOX) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftBlockEntityInventoryViewBuilder>(InventoryView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.lL, null)));
        }
        if (menuType == MenuType.SMITHING) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, ContainerSmithing::new)));
        }
        if (menuType == MenuType.SMOKER) {
            return CraftMenus.asType(new MenuTypeData<FurnaceView, CraftBlockEntityInventoryViewBuilder>(FurnaceView.class, () -> new CraftBlockEntityInventoryViewBuilder(handle, Blocks.oS, TileEntitySmoker::new)));
        }
        if (menuType == MenuType.CARTOGRAPHY_TABLE) {
            return CraftMenus.asType(new MenuTypeData<InventoryView, CraftAccessLocationInventoryViewBuilder>(InventoryView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, ContainerCartography::new)));
        }
        if (menuType == MenuType.STONECUTTER) {
            return CraftMenus.asType(new MenuTypeData<StonecutterView, CraftAccessLocationInventoryViewBuilder>(StonecutterView.class, () -> new CraftAccessLocationInventoryViewBuilder(handle, ContainerStonecutter::new)));
        }
        return CraftMenus.asType(new MenuTypeData<InventoryView, CraftStandardInventoryViewBuilder>(InventoryView.class, () -> new CraftStandardInventoryViewBuilder(handle)));
    }

    private static <V extends InventoryView, B extends InventoryViewBuilder<V>> MenuTypeData<V, B> asType(MenuTypeData<?, ?> data) {
        return data;
    }

    public record MenuTypeData<V extends InventoryView, B extends InventoryViewBuilder<V>>(Class<V> viewClass, Supplier<B> viewBuilder) {
    }
}

