/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ITileEntityContainer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftAbstractLocationInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;

public class CraftBlockEntityInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractLocationInventoryViewBuilder<V> {
    private final Block block;
    private final CraftTileInventoryBuilder builder;

    public CraftBlockEntityInventoryViewBuilder(Containers<?> handle, Block block, CraftTileInventoryBuilder builder) {
        super(handle);
        this.block = block;
        this.builder = builder;
    }

    @Override
    protected Container buildContainer(EntityPlayer player) {
        TileEntity entity;
        if (this.world == null) {
            this.world = player.A();
        }
        if (this.position == null) {
            this.position = player.dF();
        }
        if (!((entity = this.world.c_(this.position)) instanceof ITileEntityContainer)) {
            return this.buildFakeTile(player);
        }
        ITileEntityContainer container = (ITileEntityContainer)((Object)entity);
        Container atBlock = container.createMenu(player.nextContainerCounter(), player.gB(), player);
        if (atBlock.a() != this.handle) {
            return this.buildFakeTile(player);
        }
        return atBlock;
    }

    private Container buildFakeTile(EntityPlayer player) {
        if (this.builder == null) {
            return this.handle.a(player.nextContainerCounter(), player.gB());
        }
        ITileInventory inventory = this.builder.build(this.position, this.block.m());
        if (inventory instanceof TileEntity) {
            TileEntity tile = (TileEntity)((Object)inventory);
            tile.a(this.world);
        }
        return inventory.createMenu(player.nextContainerCounter(), player.gB(), player);
    }

    @Override
    public LocationInventoryViewBuilder<V> copy() {
        CraftBlockEntityInventoryViewBuilder<V> copy = new CraftBlockEntityInventoryViewBuilder<V>(this.handle, this.block, this.builder);
        copy.world = this.world;
        copy.position = this.position;
        copy.checkReachable = this.checkReachable;
        copy.title = this.title;
        return copy;
    }

    public static interface CraftTileInventoryBuilder {
        public ITileInventory build(BlockPosition var1, IBlockData var2);
    }
}

