/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.MatrixUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.ExtraCodecs;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Transformation {
    private final Matrix4fc matrix;
    public static final Codec<Transformation> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.VECTOR3F.fieldOf("translation").forGetter(var0 -> var0.translation), (App)ExtraCodecs.QUATERNIONF.fieldOf("left_rotation").forGetter(var0 -> var0.leftRotation), (App)ExtraCodecs.VECTOR3F.fieldOf("scale").forGetter(var0 -> var0.scale), (App)ExtraCodecs.QUATERNIONF.fieldOf("right_rotation").forGetter(var0 -> var0.rightRotation)).apply((Applicative)var02, Transformation::new));
    public static final Codec<Transformation> EXTENDED_CODEC = Codec.withAlternative(CODEC, (Codec)ExtraCodecs.MATRIX4F.xmap(Transformation::new, Transformation::getMatrix));
    private boolean decomposed;
    @Nullable
    private Vector3f translation;
    @Nullable
    private Quaternionf leftRotation;
    @Nullable
    private Vector3f scale;
    @Nullable
    private Quaternionf rightRotation;
    private static final Transformation IDENTITY = Util.make(() -> {
        Transformation var0 = new Transformation((Matrix4fc)new Matrix4f());
        var0.translation = new Vector3f();
        var0.leftRotation = new Quaternionf();
        var0.scale = new Vector3f(1.0f, 1.0f, 1.0f);
        var0.rightRotation = new Quaternionf();
        var0.decomposed = true;
        return var0;
    });

    public Transformation(@Nullable Matrix4fc var0) {
        this.matrix = var0 == null ? new Matrix4f() : var0;
    }

    public Transformation(@Nullable Vector3f var0, @Nullable Quaternionf var1, @Nullable Vector3f var2, @Nullable Quaternionf var3) {
        this.matrix = Transformation.compose(var0, var1, var2, var3);
        this.translation = var0 != null ? var0 : new Vector3f();
        this.leftRotation = var1 != null ? var1 : new Quaternionf();
        this.scale = var2 != null ? var2 : new Vector3f(1.0f, 1.0f, 1.0f);
        this.rightRotation = var3 != null ? var3 : new Quaternionf();
        this.decomposed = true;
    }

    public static Transformation identity() {
        return IDENTITY;
    }

    public Transformation compose(Transformation var0) {
        Matrix4f var1 = this.getMatrixCopy();
        var1.mul(var0.getMatrix());
        return new Transformation((Matrix4fc)var1);
    }

    @Nullable
    public Transformation inverse() {
        if (this == IDENTITY) {
            return this;
        }
        Matrix4f var0 = this.getMatrixCopy().invertAffine();
        if (var0.isFinite()) {
            return new Transformation((Matrix4fc)var0);
        }
        return null;
    }

    private void ensureDecomposed() {
        if (!this.decomposed) {
            float var0 = 1.0f / this.matrix.m33();
            Triple<Quaternionf, Vector3f, Quaternionf> var1 = MatrixUtil.svdDecompose(new Matrix3f(this.matrix).scale(var0));
            this.translation = this.matrix.getTranslation(new Vector3f()).mul(var0);
            this.leftRotation = new Quaternionf((Quaternionfc)var1.getLeft());
            this.scale = new Vector3f((Vector3fc)var1.getMiddle());
            this.rightRotation = new Quaternionf((Quaternionfc)var1.getRight());
            this.decomposed = true;
        }
    }

    private static Matrix4f compose(@Nullable Vector3f var0, @Nullable Quaternionf var1, @Nullable Vector3f var2, @Nullable Quaternionf var3) {
        Matrix4f var4 = new Matrix4f();
        if (var0 != null) {
            var4.translation((Vector3fc)var0);
        }
        if (var1 != null) {
            var4.rotate((Quaternionfc)var1);
        }
        if (var2 != null) {
            var4.scale((Vector3fc)var2);
        }
        if (var3 != null) {
            var4.rotate((Quaternionfc)var3);
        }
        return var4;
    }

    public Matrix4fc getMatrix() {
        return this.matrix;
    }

    public Matrix4f getMatrixCopy() {
        return new Matrix4f(this.matrix);
    }

    public Vector3f getTranslation() {
        this.ensureDecomposed();
        return new Vector3f((Vector3fc)this.translation);
    }

    public Quaternionf getLeftRotation() {
        this.ensureDecomposed();
        return new Quaternionf((Quaternionfc)this.leftRotation);
    }

    public Vector3f getScale() {
        this.ensureDecomposed();
        return new Vector3f((Vector3fc)this.scale);
    }

    public Quaternionf getRightRotation() {
        this.ensureDecomposed();
        return new Quaternionf((Quaternionfc)this.rightRotation);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        Transformation var1 = (Transformation)var0;
        return Objects.equals(this.matrix, var1.matrix);
    }

    public int hashCode() {
        return Objects.hash(this.matrix);
    }

    public Transformation slerp(Transformation var0, float var1) {
        Vector3f var2 = this.getTranslation();
        Quaternionf var3 = this.getLeftRotation();
        Vector3f var4 = this.getScale();
        Quaternionf var5 = this.getRightRotation();
        var2.lerp((Vector3fc)var0.getTranslation(), var1);
        var3.slerp((Quaternionfc)var0.getLeftRotation(), var1);
        var4.lerp((Vector3fc)var0.getScale(), var1);
        var5.slerp((Quaternionfc)var0.getRightRotation(), var1);
        return new Transformation(var2, var3, var4, var5);
    }
}

