/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.DataVersion;
import org.slf4j.Logger;

public class DetectedVersion {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final WorldVersion BUILT_IN = DetectedVersion.createFromConstants();

    private static WorldVersion createFromConstants() {
        return new WorldVersion.Simple(UUID.randomUUID().toString().replaceAll("-", ""), "1.21.6", new DataVersion(4435, "main"), SharedConstants.getProtocolVersion(), 63, 80, new Date(), true);
    }

    private static WorldVersion createFromJson(JsonObject var0) {
        JsonObject var1 = GsonHelper.getAsJsonObject(var0, "pack_version");
        return new WorldVersion.Simple(GsonHelper.getAsString(var0, "id"), GsonHelper.getAsString(var0, "name"), new DataVersion(GsonHelper.getAsInt(var0, "world_version"), GsonHelper.getAsString(var0, "series_id", "main")), GsonHelper.getAsInt(var0, "protocol_version"), GsonHelper.getAsInt(var1, "resource"), GsonHelper.getAsInt(var1, "data"), Date.from(ZonedDateTime.parse(GsonHelper.getAsString(var0, "build_time")).toInstant()), GsonHelper.getAsBoolean(var0, "stable"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static WorldVersion tryDetectVersion() {
        try (InputStream var0 = DetectedVersion.class.getResourceAsStream("/version.json");){
            WorldVersion worldVersion;
            if (var0 == null) {
                LOGGER.warn("Missing version information!");
                WorldVersion worldVersion2 = BUILT_IN;
                return worldVersion2;
            }
            try (InputStreamReader var1 = new InputStreamReader(var0);){
                worldVersion = DetectedVersion.createFromJson(GsonHelper.parse(var1));
            }
            return worldVersion;
        }
        catch (JsonParseException | IOException var02) {
            throw new IllegalStateException("Game version information is corrupt", var02);
        }
    }
}

