/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class DisplayInfo {
    public static final Codec<DisplayInfo> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ItemStack.STRICT_CODEC.fieldOf("icon").forGetter(DisplayInfo::getIcon), (App)ComponentSerialization.CODEC.fieldOf("title").forGetter(DisplayInfo::getTitle), (App)ComponentSerialization.CODEC.fieldOf("description").forGetter(DisplayInfo::getDescription), (App)ClientAsset.CODEC.optionalFieldOf("background").forGetter(DisplayInfo::getBackground), (App)AdvancementType.CODEC.optionalFieldOf("frame", (Object)AdvancementType.TASK).forGetter(DisplayInfo::getType), (App)Codec.BOOL.optionalFieldOf("show_toast", (Object)true).forGetter(DisplayInfo::shouldShowToast), (App)Codec.BOOL.optionalFieldOf("announce_to_chat", (Object)true).forGetter(DisplayInfo::shouldAnnounceChat), (App)Codec.BOOL.optionalFieldOf("hidden", (Object)false).forGetter(DisplayInfo::isHidden)).apply((Applicative)var0, DisplayInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DisplayInfo> STREAM_CODEC = StreamCodec.ofMember(DisplayInfo::serializeToNetwork, DisplayInfo::fromNetwork);
    private final Component title;
    private final Component description;
    private final ItemStack icon;
    private final Optional<ClientAsset> background;
    private final AdvancementType type;
    private final boolean showToast;
    private final boolean announceChat;
    private final boolean hidden;
    private float x;
    private float y;

    public DisplayInfo(ItemStack var0, Component var1, Component var2, Optional<ClientAsset> var3, AdvancementType var4, boolean var5, boolean var6, boolean var7) {
        this.title = var1;
        this.description = var2;
        this.icon = var0;
        this.background = var3;
        this.type = var4;
        this.showToast = var5;
        this.announceChat = var6;
        this.hidden = var7;
    }

    public void setLocation(float var0, float var1) {
        this.x = var0;
        this.y = var1;
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getDescription() {
        return this.description;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public Optional<ClientAsset> getBackground() {
        return this.background;
    }

    public AdvancementType getType() {
        return this.type;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean shouldShowToast() {
        return this.showToast;
    }

    public boolean shouldAnnounceChat() {
        return this.announceChat;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    private void serializeToNetwork(RegistryFriendlyByteBuf var0) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode(var0, this.title);
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode(var0, this.description);
        ItemStack.STREAM_CODEC.encode(var0, this.icon);
        var0.writeEnum(this.type);
        int var1 = 0;
        if (this.background.isPresent()) {
            var1 |= 1;
        }
        if (this.showToast) {
            var1 |= 2;
        }
        if (this.hidden) {
            var1 |= 4;
        }
        var0.writeInt(var1);
        this.background.map(ClientAsset::id).ifPresent(var0::writeResourceLocation);
        var0.writeFloat(this.x);
        var0.writeFloat(this.y);
    }

    private static DisplayInfo fromNetwork(RegistryFriendlyByteBuf var0) {
        Component var1 = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(var0);
        Component var2 = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(var0);
        ItemStack var3 = (ItemStack)ItemStack.STREAM_CODEC.decode(var0);
        AdvancementType var4 = var0.readEnum(AdvancementType.class);
        int var5 = var0.readInt();
        Optional<ClientAsset> var6 = (var5 & 1) != 0 ? Optional.of(new ClientAsset(var0.readResourceLocation())) : Optional.empty();
        boolean var7 = (var5 & 2) != 0;
        boolean var8 = (var5 & 4) != 0;
        DisplayInfo var9 = new DisplayInfo(var3, var1, var2, var6, var4, var7, false, var8);
        var9.setLocation(var0.readFloat(), var0.readFloat());
        return var9;
    }
}

