/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementNode;

public class TreeNodePosition {
    private final AdvancementNode node;
    @Nullable
    private final TreeNodePosition parent;
    @Nullable
    private final TreeNodePosition previousSibling;
    private final int childIndex;
    private final List<TreeNodePosition> children = Lists.newArrayList();
    private TreeNodePosition ancestor;
    @Nullable
    private TreeNodePosition thread;
    private int x;
    private float y;
    private float mod;
    private float change;
    private float shift;

    public TreeNodePosition(AdvancementNode var0, @Nullable TreeNodePosition var1, @Nullable TreeNodePosition var2, int var3, int var4) {
        if (var0.advancement().display().isEmpty()) {
            throw new IllegalArgumentException("Can't position an invisible advancement!");
        }
        this.node = var0;
        this.parent = var1;
        this.previousSibling = var2;
        this.childIndex = var3;
        this.ancestor = this;
        this.x = var4;
        this.y = -1.0f;
        TreeNodePosition var5 = null;
        for (AdvancementNode var7 : var0.children()) {
            var5 = this.addChild(var7, var5);
        }
    }

    @Nullable
    private TreeNodePosition addChild(AdvancementNode var0, @Nullable TreeNodePosition var1) {
        if (var0.advancement().display().isPresent()) {
            var1 = new TreeNodePosition(var0, this, var1, this.children.size() + 1, this.x + 1);
            this.children.add(var1);
        } else {
            for (AdvancementNode var3 : var0.children()) {
                var1 = this.addChild(var3, var1);
            }
        }
        return var1;
    }

    private void firstWalk() {
        if (this.children.isEmpty()) {
            this.y = this.previousSibling != null ? this.previousSibling.y + 1.0f : 0.0f;
            return;
        }
        TreeNodePosition var0 = null;
        for (TreeNodePosition var2 : this.children) {
            var2.firstWalk();
            var0 = var2.apportion(var0 == null ? var2 : var0);
        }
        this.executeShifts();
        float var1 = (this.children.get((int)0).y + this.children.get((int)(this.children.size() - 1)).y) / 2.0f;
        if (this.previousSibling != null) {
            this.y = this.previousSibling.y + 1.0f;
            this.mod = this.y - var1;
        } else {
            this.y = var1;
        }
    }

    private float secondWalk(float var0, int var1, float var2) {
        this.y += var0;
        this.x = var1;
        if (this.y < var2) {
            var2 = this.y;
        }
        for (TreeNodePosition var4 : this.children) {
            var2 = var4.secondWalk(var0 + this.mod, var1 + 1, var2);
        }
        return var2;
    }

    private void thirdWalk(float var0) {
        this.y += var0;
        for (TreeNodePosition var2 : this.children) {
            var2.thirdWalk(var0);
        }
    }

    private void executeShifts() {
        float var0 = 0.0f;
        float var1 = 0.0f;
        for (int var2 = this.children.size() - 1; var2 >= 0; --var2) {
            TreeNodePosition var3 = this.children.get(var2);
            var3.y += var0;
            var3.mod += var0;
            var0 += var3.shift + (var1 += var3.change);
        }
    }

    @Nullable
    private TreeNodePosition previousOrThread() {
        if (this.thread != null) {
            return this.thread;
        }
        if (!this.children.isEmpty()) {
            return this.children.get(0);
        }
        return null;
    }

    @Nullable
    private TreeNodePosition nextOrThread() {
        if (this.thread != null) {
            return this.thread;
        }
        if (!this.children.isEmpty()) {
            return this.children.get(this.children.size() - 1);
        }
        return null;
    }

    private TreeNodePosition apportion(TreeNodePosition var0) {
        if (this.previousSibling == null) {
            return var0;
        }
        TreeNodePosition var1 = this;
        TreeNodePosition var2 = this;
        TreeNodePosition var3 = this.previousSibling;
        TreeNodePosition var4 = this.parent.children.get(0);
        float var5 = this.mod;
        float var6 = this.mod;
        float var7 = var3.mod;
        float var8 = var4.mod;
        while (var3.nextOrThread() != null && var1.previousOrThread() != null) {
            var3 = var3.nextOrThread();
            var1 = var1.previousOrThread();
            var4 = var4.previousOrThread();
            var2 = var2.nextOrThread();
            var2.ancestor = this;
            float var9 = var3.y + var7 - (var1.y + var5) + 1.0f;
            if (var9 > 0.0f) {
                var3.getAncestor(this, var0).moveSubtree(this, var9);
                var5 += var9;
                var6 += var9;
            }
            var7 += var3.mod;
            var5 += var1.mod;
            var8 += var4.mod;
            var6 += var2.mod;
        }
        if (var3.nextOrThread() != null && var2.nextOrThread() == null) {
            var2.thread = var3.nextOrThread();
            var2.mod += var7 - var6;
        } else {
            if (var1.previousOrThread() != null && var4.previousOrThread() == null) {
                var4.thread = var1.previousOrThread();
                var4.mod += var5 - var8;
            }
            var0 = this;
        }
        return var0;
    }

    private void moveSubtree(TreeNodePosition var0, float var1) {
        float var2 = var0.childIndex - this.childIndex;
        if (var2 != 0.0f) {
            var0.change -= var1 / var2;
            this.change += var1 / var2;
        }
        var0.shift += var1;
        var0.y += var1;
        var0.mod += var1;
    }

    private TreeNodePosition getAncestor(TreeNodePosition var0, TreeNodePosition var1) {
        if (this.ancestor != null && var0.parent.children.contains(this.ancestor)) {
            return this.ancestor;
        }
        return var1;
    }

    private void finalizePosition() {
        this.node.advancement().display().ifPresent(var0 -> var0.setLocation(this.x, this.y));
        if (!this.children.isEmpty()) {
            for (TreeNodePosition var1 : this.children) {
                var1.finalizePosition();
            }
        }
    }

    public static void run(AdvancementNode var0) {
        if (var0.advancement().display().isEmpty()) {
            throw new IllegalArgumentException("Can't position children of an invisible root!");
        }
        TreeNodePosition var1 = new TreeNodePosition(var0, null, null, 1, 0);
        var1.firstWalk();
        float var2 = var1.secondWalk(0.0f, 0, var1.y);
        if (var2 < 0.0f) {
            var1.thirdWalk(-var2);
        }
        var1.finalizePosition();
    }
}

