/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public record EnchantmentPredicate(Optional<HolderSet<Enchantment>> enchantments, MinMaxBounds.Ints level) {
    public static final Codec<EnchantmentPredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.ENCHANTMENT).optionalFieldOf("enchantments").forGetter(EnchantmentPredicate::enchantments), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("levels", (Object)MinMaxBounds.Ints.ANY).forGetter(EnchantmentPredicate::level)).apply((Applicative)var0, EnchantmentPredicate::new));

    public EnchantmentPredicate(Holder<Enchantment> var0, MinMaxBounds.Ints var1) {
        this(Optional.of(HolderSet.direct(var0)), var1);
    }

    public EnchantmentPredicate(HolderSet<Enchantment> var0, MinMaxBounds.Ints var1) {
        this(Optional.of(var0), var1);
    }

    public boolean containedIn(ItemEnchantments var0) {
        if (this.enchantments.isPresent()) {
            for (Holder holder : this.enchantments.get()) {
                if (!this.matchesEnchantment(var0, holder)) continue;
                return true;
            }
            return false;
        }
        if (this.level != MinMaxBounds.Ints.ANY) {
            for (Object2IntMap.Entry<Holder<Enchantment>> entry : var0.entrySet()) {
                if (!this.level.matches(entry.getIntValue())) continue;
                return true;
            }
            return false;
        }
        return !var0.isEmpty();
    }

    private boolean matchesEnchantment(ItemEnchantments var0, Holder<Enchantment> var1) {
        int var2 = var0.getLevel(var1);
        if (var2 == 0) {
            return false;
        }
        if (this.level == MinMaxBounds.Ints.ANY) {
            return true;
        }
        return this.level.matches(var2);
    }
}

