/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class FishingRodHookedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer var0, ItemStack var1, FishingHook var2, Collection<ItemStack> var32) {
        LootContext var4 = EntityPredicate.createContext(var0, var2.getHookedIn() != null ? var2.getHookedIn() : var2);
        this.trigger(var0, var3 -> var3.matches(var1, var4, var32));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> rod, Optional<ContextAwarePredicate> entity, Optional<ItemPredicate> item) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("rod").forGetter(TriggerInstance::rod), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(TriggerInstance::entity), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item)).apply((Applicative)var0, TriggerInstance::new));

        public static Criterion<TriggerInstance> fishedItem(Optional<ItemPredicate> var0, Optional<EntityPredicate> var1, Optional<ItemPredicate> var2) {
            return CriteriaTriggers.FISHING_ROD_HOOKED.createCriterion(new TriggerInstance(Optional.empty(), var0, EntityPredicate.wrap(var1), var2));
        }

        public boolean matches(ItemStack var0, LootContext var1, Collection<ItemStack> var2) {
            if (this.rod.isPresent() && !this.rod.get().test(var0)) {
                return false;
            }
            if (this.entity.isPresent() && !this.entity.get().matches(var1)) {
                return false;
            }
            if (this.item.isPresent()) {
                boolean var3 = false;
                Entity var4 = var1.getOptionalParameter(LootContextParams.THIS_ENTITY);
                if (var4 instanceof ItemEntity) {
                    ItemEntity var5 = (ItemEntity)var4;
                    if (this.item.get().test(var5.getItem())) {
                        var3 = true;
                    }
                }
                for (ItemStack var6 : var2) {
                    if (!this.item.get().test(var6)) continue;
                    var3 = true;
                    break;
                }
                if (!var3) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void validate(CriterionValidator var0) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(var0);
            var0.validateEntity(this.entity, "entity");
        }
    }
}

