/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InventoryChangeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer var0, Inventory var1, ItemStack var2) {
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        for (int var6 = 0; var6 < var1.getContainerSize(); ++var6) {
            ItemStack var7 = var1.getItem(var6);
            if (var7.isEmpty()) {
                ++var4;
                continue;
            }
            ++var5;
            if (var7.getCount() < var7.getMaxStackSize()) continue;
            ++var3;
        }
        this.trigger(var0, var1, var2, var3, var4, var5);
    }

    private void trigger(ServerPlayer var0, Inventory var1, ItemStack var2, int var3, int var4, int var52) {
        this.trigger(var0, var5 -> var5.matches(var1, var2, var3, var4, var52));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Slots slots, List<ItemPredicate> items) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Slots.CODEC.optionalFieldOf("slots", (Object)Slots.ANY).forGetter(TriggerInstance::slots), (App)ItemPredicate.CODEC.listOf().optionalFieldOf("items", List.of()).forGetter(TriggerInstance::items)).apply((Applicative)var0, TriggerInstance::new));

        public static Criterion<TriggerInstance> hasItems(ItemPredicate.Builder ... var0) {
            return TriggerInstance.hasItems((ItemPredicate[])Stream.of(var0).map(ItemPredicate.Builder::build).toArray(ItemPredicate[]::new));
        }

        public static Criterion<TriggerInstance> hasItems(ItemPredicate ... var0) {
            return CriteriaTriggers.INVENTORY_CHANGED.createCriterion(new TriggerInstance(Optional.empty(), Slots.ANY, List.of(var0)));
        }

        public static Criterion<TriggerInstance> hasItems(ItemLike ... var0) {
            ItemPredicate[] var1 = new ItemPredicate[var0.length];
            for (int var2 = 0; var2 < var0.length; ++var2) {
                var1[var2] = new ItemPredicate(Optional.of(HolderSet.direct(var0[var2].asItem().builtInRegistryHolder())), MinMaxBounds.Ints.ANY, DataComponentMatchers.ANY);
            }
            return TriggerInstance.hasItems(var1);
        }

        public boolean matches(Inventory var0, ItemStack var12, int var2, int var3, int var4) {
            if (!this.slots.matches(var2, var3, var4)) {
                return false;
            }
            if (this.items.isEmpty()) {
                return true;
            }
            if (this.items.size() == 1) {
                return !var12.isEmpty() && this.items.get(0).test(var12);
            }
            ObjectArrayList var5 = new ObjectArrayList(this.items);
            int var6 = var0.getContainerSize();
            for (int var7 = 0; var7 < var6; ++var7) {
                if (var5.isEmpty()) {
                    return true;
                }
                ItemStack var8 = var0.getItem(var7);
                if (var8.isEmpty()) continue;
                var5.removeIf(var1 -> var1.test(var8));
            }
            return var5.isEmpty();
        }

        public record Slots(MinMaxBounds.Ints occupied, MinMaxBounds.Ints full, MinMaxBounds.Ints empty) {
            public static final Codec<Slots> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("occupied", (Object)MinMaxBounds.Ints.ANY).forGetter(Slots::occupied), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("full", (Object)MinMaxBounds.Ints.ANY).forGetter(Slots::full), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("empty", (Object)MinMaxBounds.Ints.ANY).forGetter(Slots::empty)).apply((Applicative)var0, Slots::new));
            public static final Slots ANY = new Slots(MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY);

            public boolean matches(int var0, int var1, int var2) {
                if (!this.full.matches(var0)) {
                    return false;
                }
                if (!this.empty.matches(var1)) {
                    return false;
                }
                return this.occupied.matches(var2);
            }
        }
    }
}

