/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;

public class ItemUsedOnLocationTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer var0, BlockPos var12, ItemStack var2) {
        ServerLevel var3 = var0.level();
        BlockState var4 = var3.getBlockState(var12);
        LootParams var5 = new LootParams.Builder(var3).withParameter(LootContextParams.ORIGIN, var12.getCenter()).withParameter(LootContextParams.THIS_ENTITY, var0).withParameter(LootContextParams.BLOCK_STATE, var4).withParameter(LootContextParams.TOOL, var2).create(LootContextParamSets.ADVANCEMENT_LOCATION);
        LootContext var6 = new LootContext.Builder(var5).create(Optional.empty());
        this.trigger(var0, var1 -> var1.matches(var6));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> location) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ContextAwarePredicate.CODEC.optionalFieldOf("location").forGetter(TriggerInstance::location)).apply((Applicative)var0, TriggerInstance::new));

        public static Criterion<TriggerInstance> placedBlock(Block var0) {
            ContextAwarePredicate var1 = ContextAwarePredicate.create(LootItemBlockStatePropertyCondition.hasBlockStateProperties(var0).build());
            return CriteriaTriggers.PLACED_BLOCK.createCriterion(new TriggerInstance(Optional.empty(), Optional.of(var1)));
        }

        public static Criterion<TriggerInstance> placedBlock(LootItemCondition.Builder ... var0) {
            ContextAwarePredicate var1 = ContextAwarePredicate.create((LootItemCondition[])Arrays.stream(var0).map(LootItemCondition.Builder::build).toArray(LootItemCondition[]::new));
            return CriteriaTriggers.PLACED_BLOCK.createCriterion(new TriggerInstance(Optional.empty(), Optional.of(var1)));
        }

        public static <T extends Comparable<T>> Criterion<TriggerInstance> placedBlockWithProperties(Block var0, Property<T> var1, String var2) {
            StatePropertiesPredicate.Builder var3 = StatePropertiesPredicate.Builder.properties().hasProperty(var1, var2);
            ContextAwarePredicate var4 = ContextAwarePredicate.create(LootItemBlockStatePropertyCondition.hasBlockStateProperties(var0).setProperties(var3).build());
            return CriteriaTriggers.PLACED_BLOCK.createCriterion(new TriggerInstance(Optional.empty(), Optional.of(var4)));
        }

        public static Criterion<TriggerInstance> placedBlockWithProperties(Block var0, Property<Boolean> var1, boolean var2) {
            return TriggerInstance.placedBlockWithProperties(var0, var1, String.valueOf(var2));
        }

        public static Criterion<TriggerInstance> placedBlockWithProperties(Block var0, Property<Integer> var1, int var2) {
            return TriggerInstance.placedBlockWithProperties(var0, var1, String.valueOf(var2));
        }

        public static <T extends Comparable<T> & StringRepresentable> Criterion<TriggerInstance> placedBlockWithProperties(Block var0, Property<T> var1, T var2) {
            return TriggerInstance.placedBlockWithProperties(var0, var1, ((StringRepresentable)var2).getSerializedName());
        }

        private static TriggerInstance itemUsedOnLocation(LocationPredicate.Builder var0, ItemPredicate.Builder var1) {
            ContextAwarePredicate var2 = ContextAwarePredicate.create(LocationCheck.checkLocation(var0).build(), MatchTool.toolMatches(var1).build());
            return new TriggerInstance(Optional.empty(), Optional.of(var2));
        }

        public static Criterion<TriggerInstance> itemUsedOnBlock(LocationPredicate.Builder var0, ItemPredicate.Builder var1) {
            return CriteriaTriggers.ITEM_USED_ON_BLOCK.createCriterion(TriggerInstance.itemUsedOnLocation(var0, var1));
        }

        public static Criterion<TriggerInstance> allayDropItemOnBlock(LocationPredicate.Builder var0, ItemPredicate.Builder var1) {
            return CriteriaTriggers.ALLAY_DROP_ITEM_ON_BLOCK.createCriterion(TriggerInstance.itemUsedOnLocation(var0, var1));
        }

        public boolean matches(LootContext var0) {
            return this.location.isEmpty() || this.location.get().matches(var0);
        }

        @Override
        public void validate(CriterionValidator var0) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(var0);
            this.location.ifPresent(var1 -> var0.validate((ContextAwarePredicate)var1, LootContextParamSets.ADVANCEMENT_LOCATION, "location"));
        }
    }
}

