/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> EXAMPLES = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType ERROR_FAILED_TO_PARSE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.resource_or_id.failed_to_parse", var0));
    public static final Dynamic2CommandExceptionType ERROR_NO_SUCH_ELEMENT = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("argument.resource_or_id.no_such_element", var0, var1));
    public static final DynamicOps<Tag> OPS = NbtOps.INSTANCE;
    private final HolderLookup.Provider registryLookup;
    private final Optional<? extends HolderLookup.RegistryLookup<T>> elementLookup;
    private final Codec<T> codec;
    private final Grammar<Result<T, Tag>> grammar;
    private final ResourceKey<? extends Registry<T>> registryKey;

    protected ResourceOrIdArgument(CommandBuildContext var0, ResourceKey<? extends Registry<T>> var1, Codec<T> var2) {
        this.registryLookup = var0;
        this.elementLookup = var0.lookup(var1);
        this.registryKey = var1;
        this.codec = var2;
        this.grammar = ResourceOrIdArgument.createGrammar(var1, OPS);
    }

    public static <T, O> Grammar<Result<T, O>> createGrammar(ResourceKey<? extends Registry<T>> var0, DynamicOps<O> var1) {
        Grammar<O> var2 = SnbtGrammar.createParser(var1);
        Dictionary<StringReader> var32 = new Dictionary<StringReader>();
        Atom var4 = Atom.of("result");
        Atom var5 = Atom.of("id");
        Atom var6 = Atom.of("value");
        var32.put(var5, ResourceLocationParseRule.INSTANCE);
        var32.put(var6, var2.top().value());
        NamedRule var7 = var32.put(var4, Term.alternative(var32.named(var5), var32.named(var6)), var3 -> {
            ResourceLocation var4 = (ResourceLocation)var3.get(var5);
            if (var4 != null) {
                return new ReferenceResult(ResourceKey.create(var0, var4));
            }
            Object var5 = var3.getOrThrow(var6);
            return new InlineResult(var5);
        });
        return new Grammar<Result<T, O>>(var32, var7);
    }

    public static LootTableArgument lootTable(CommandBuildContext var0) {
        return new LootTableArgument(var0);
    }

    public static Holder<LootTable> getLootTable(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static LootModifierArgument lootModifier(CommandBuildContext var0) {
        return new LootModifierArgument(var0);
    }

    public static Holder<LootItemFunction> getLootModifier(CommandContext<CommandSourceStack> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static LootPredicateArgument lootPredicate(CommandBuildContext var0) {
        return new LootPredicateArgument(var0);
    }

    public static Holder<LootItemCondition> getLootPredicate(CommandContext<CommandSourceStack> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static DialogArgument dialog(CommandBuildContext var0) {
        return new DialogArgument(var0);
    }

    public static Holder<Dialog> getDialog(CommandContext<CommandSourceStack> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    private static <T> Holder<T> getResource(CommandContext<CommandSourceStack> var0, String var1) {
        return (Holder)var0.getArgument(var1, Holder.class);
    }

    @Nullable
    public Holder<T> parse(StringReader var0) throws CommandSyntaxException {
        return this.parse(var0, this.grammar, OPS);
    }

    @Nullable
    private <O> Holder<T> parse(StringReader var0, Grammar<Result<T, O>> var1, DynamicOps<O> var2) throws CommandSyntaxException {
        Result<T, O> var3 = var1.parseForCommands(var0);
        if (this.elementLookup.isEmpty()) {
            return null;
        }
        return var3.parse((ImmutableStringReader)var0, this.registryLookup, var2, this.codec, this.elementLookup.get());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return SharedSuggestionProvider.listSuggestions(var0, var1, this.registryKey, SharedSuggestionProvider.ElementSuggestionType.ELEMENTS);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Nullable
    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class LootTableArgument
    extends ResourceOrIdArgument<LootTable> {
        protected LootTableArgument(CommandBuildContext var0) {
            super(var0, Registries.LOOT_TABLE, LootTable.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class LootModifierArgument
    extends ResourceOrIdArgument<LootItemFunction> {
        protected LootModifierArgument(CommandBuildContext var0) {
            super(var0, Registries.ITEM_MODIFIER, LootItemFunctions.ROOT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class LootPredicateArgument
    extends ResourceOrIdArgument<LootItemCondition> {
        protected LootPredicateArgument(CommandBuildContext var0) {
            super(var0, Registries.PREDICATE, LootItemCondition.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class DialogArgument
    extends ResourceOrIdArgument<Dialog> {
        protected DialogArgument(CommandBuildContext var0) {
            super(var0, Registries.DIALOG, Dialog.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static sealed interface Result<T, O>
    permits InlineResult, ReferenceResult {
        public Holder<T> parse(ImmutableStringReader var1, HolderLookup.Provider var2, DynamicOps<O> var3, Codec<T> var4, HolderLookup.RegistryLookup<T> var5) throws CommandSyntaxException;
    }

    public record ReferenceResult<T, O>(ResourceKey<T> key) implements Result<T, O>
    {
        @Override
        public Holder<T> parse(ImmutableStringReader var0, HolderLookup.Provider var1, DynamicOps<O> var2, Codec<T> var3, HolderLookup.RegistryLookup<T> var4) throws CommandSyntaxException {
            return var4.get(this.key).orElseThrow(() -> ERROR_NO_SUCH_ELEMENT.createWithContext(var0, (Object)this.key.location(), (Object)this.key.registry()));
        }
    }

    public record InlineResult<T, O>(O value) implements Result<T, O>
    {
        @Override
        public Holder<T> parse(ImmutableStringReader var0, HolderLookup.Provider var12, DynamicOps<O> var2, Codec<T> var3, HolderLookup.RegistryLookup<T> var4) throws CommandSyntaxException {
            return Holder.direct(var3.parse(var12.createSerializationContext(var2), this.value).getOrThrow(var1 -> ERROR_FAILED_TO_PARSE.createWithContext(var0, var1)));
        }
    }
}

