/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class ResourceSelectorArgument<T>
implements ArgumentType<Collection<Holder.Reference<T>>> {
    private static final Collection<String> EXAMPLES = List.of("minecraft:*", "*:asset", "*");
    public static final Dynamic2CommandExceptionType ERROR_NO_MATCHES = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("argument.resource_selector.not_found", var0, var1));
    final ResourceKey<? extends Registry<T>> registryKey;
    private final HolderLookup<T> registryLookup;

    ResourceSelectorArgument(CommandBuildContext var0, ResourceKey<? extends Registry<T>> var1) {
        this.registryKey = var1;
        this.registryLookup = var0.lookupOrThrow(var1);
    }

    public Collection<Holder.Reference<T>> parse(StringReader var0) throws CommandSyntaxException {
        String var12 = ResourceSelectorArgument.ensureNamespaced(ResourceSelectorArgument.readPattern(var0));
        List<Holder.Reference<T>> var2 = this.registryLookup.listElements().filter(var1 -> ResourceSelectorArgument.matches(var12, var1.key().location())).toList();
        if (var2.isEmpty()) {
            throw ERROR_NO_MATCHES.createWithContext((ImmutableStringReader)var0, (Object)var12, (Object)this.registryKey.location());
        }
        return var2;
    }

    public static <T> Collection<Holder.Reference<T>> parse(StringReader var0, HolderLookup<T> var12) {
        String var2 = ResourceSelectorArgument.ensureNamespaced(ResourceSelectorArgument.readPattern(var0));
        return var12.listElements().filter(var1 -> ResourceSelectorArgument.matches(var2, var1.key().location())).toList();
    }

    private static String readPattern(StringReader var0) {
        int var1 = var0.getCursor();
        while (var0.canRead() && ResourceSelectorArgument.isAllowedPatternCharacter(var0.peek())) {
            var0.skip();
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    private static boolean isAllowedPatternCharacter(char var0) {
        return ResourceLocation.isAllowedInResourceLocation(var0) || var0 == '*' || var0 == '?';
    }

    private static String ensureNamespaced(String var0) {
        if (!var0.contains(":")) {
            return "minecraft:" + var0;
        }
        return var0;
    }

    private static boolean matches(String var0, ResourceLocation var1) {
        return FilenameUtils.wildcardMatch((String)var1.toString(), (String)var0);
    }

    public static <T> ResourceSelectorArgument<T> resourceSelector(CommandBuildContext var0, ResourceKey<? extends Registry<T>> var1) {
        return new ResourceSelectorArgument<T>(var0, var1);
    }

    public static <T> Collection<Holder.Reference<T>> getSelectedResources(CommandContext<CommandSourceStack> var0, String var1) {
        return (Collection)var0.getArgument(var1, Collection.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return SharedSuggestionProvider.listSuggestions(var0, var1, this.registryKey, SharedSuggestionProvider.ElementSuggestionType.ELEMENTS);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceSelectorArgument<T>, Template> {
        @Override
        public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
            var1.writeResourceKey(var0.registryKey);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf var0) {
            return new Template(var0.readRegistryKey());
        }

        @Override
        public void serializeToJson(Template var0, JsonObject var1) {
            var1.addProperty("registry", var0.registryKey.location().toString());
        }

        @Override
        public Template unpack(ResourceSelectorArgument<T> var0) {
            return new Template(var0.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return this.deserializeFromNetwork(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceSelectorArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey var1) {
                this.registryKey = var1;
            }

            @Override
            public ResourceSelectorArgument<T> instantiate(CommandBuildContext var0) {
                return new ResourceSelectorArgument(var0, this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceSelectorArgument<T>, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

