/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.util.parsing.packrat.commands.ResourceLookupRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.TagParseRule;

public class ComponentPredicateParser {
    public static <T, C, P> Grammar<List<T>> createGrammar(Context<T, C, P> var02) {
        Atom var1 = Atom.of("top");
        Atom var22 = Atom.of("type");
        Atom var32 = Atom.of("any_type");
        Atom var42 = Atom.of("element_type");
        Atom var5 = Atom.of("tag_type");
        Atom var6 = Atom.of("conditions");
        Atom var7 = Atom.of("alternatives");
        Atom var8 = Atom.of("term");
        Atom var9 = Atom.of("negation");
        Atom var10 = Atom.of("test");
        Atom var11 = Atom.of("component_type");
        Atom var12 = Atom.of("predicate_type");
        Atom var13 = Atom.of("id");
        Atom var14 = Atom.of("tag");
        Dictionary<StringReader> var15 = new Dictionary<StringReader>();
        NamedRule<StringReader, ResourceLocation> var16 = var15.put(var13, ResourceLocationParseRule.INSTANCE);
        NamedRule var17 = var15.put(var1, Term.alternative(Term.sequence(var15.named(var22), StringReaderTerms.character('['), Term.cut(), Term.optional(var15.named(var6)), StringReaderTerms.character(']')), var15.named(var22)), var2 -> {
            ImmutableList.Builder var3 = ImmutableList.builder();
            ((Optional)var2.getOrThrow(var22)).ifPresent(arg_0 -> ((ImmutableList.Builder)var3).add(arg_0));
            List var4 = (List)var2.get(var6);
            if (var4 != null) {
                var3.addAll((Iterable)var4);
            }
            return var3.build();
        });
        var15.put(var22, Term.alternative(var15.named(var42), Term.sequence(StringReaderTerms.character('#'), Term.cut(), var15.named(var5)), var15.named(var32)), var2 -> Optional.ofNullable(var2.getAny(var42, var5)));
        var15.put(var32, StringReaderTerms.character('*'), var0 -> Unit.INSTANCE);
        var15.put(var42, new ElementLookupRule<T, C, P>(var16, var02));
        var15.put(var5, new TagLookupRule<T, C, P>(var16, var02));
        var15.put(var6, Term.sequence(var15.named(var7), Term.optional(Term.sequence(StringReaderTerms.character(','), var15.named(var6)))), var3 -> {
            Object var4 = var02.anyOf((List)var3.getOrThrow(var7));
            return Optional.ofNullable((List)var3.get(var6)).map(var1 -> Util.copyAndAdd(var4, var1)).orElse(List.of(var4));
        });
        var15.put(var7, Term.sequence(var15.named(var8), Term.optional(Term.sequence(StringReaderTerms.character('|'), var15.named(var7)))), var2 -> {
            Object var3 = var2.getOrThrow(var8);
            return Optional.ofNullable((List)var2.get(var7)).map(var1 -> Util.copyAndAdd(var3, var1)).orElse(List.of(var3));
        });
        var15.put(var8, Term.alternative(var15.named(var10), Term.sequence(StringReaderTerms.character('!'), var15.named(var9))), var2 -> var2.getAnyOrThrow(var10, var9));
        var15.put(var9, var15.named(var10), var2 -> var02.negate(var2.getOrThrow(var10)));
        var15.putComplex(var10, Term.alternative(Term.sequence(var15.named(var11), StringReaderTerms.character('='), Term.cut(), var15.named(var14)), Term.sequence(var15.named(var12), StringReaderTerms.character('~'), Term.cut(), var15.named(var14)), var15.named(var11)), var4 -> {
            Scope var5 = var4.scope();
            Object var6 = var5.get(var12);
            try {
                if (var6 != null) {
                    Dynamic var7 = (Dynamic)var5.getOrThrow(var14);
                    return var02.createPredicateTest((ImmutableStringReader)var4.input(), var6, var7);
                }
                Object var7 = var5.getOrThrow(var11);
                Dynamic var8 = (Dynamic)var5.get(var14);
                return var8 != null ? var02.createComponentTest((ImmutableStringReader)var4.input(), var7, var8) : var02.createComponentTest((ImmutableStringReader)var4.input(), var7);
            }
            catch (CommandSyntaxException var7) {
                var4.errorCollector().store(var4.mark(), (Object)var7);
                return null;
            }
        });
        var15.put(var11, new ComponentLookupRule<T, C, P>(var16, var02));
        var15.put(var12, new PredicateLookupRule<T, C, P>(var16, var02));
        var15.put(var14, new TagParseRule<Tag>(NbtOps.INSTANCE));
        return new Grammar<List<T>>(var15, var17);
    }

    static class ElementLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        ElementLookupRule(NamedRule<StringReader, ResourceLocation> var0, Context<T, C, P> var1) {
            super(var0, var1);
        }

        @Override
        protected T validateElement(ImmutableStringReader var0, ResourceLocation var1) throws Exception {
            return ((Context)this.context).forElementType(var0, var1);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listElementTypes();
        }
    }

    public static interface Context<T, C, P> {
        public T forElementType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listElementTypes();

        public T forTagType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listTagTypes();

        public C lookupComponentType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listComponentTypes();

        public T createComponentTest(ImmutableStringReader var1, C var2, Dynamic<?> var3) throws CommandSyntaxException;

        public T createComponentTest(ImmutableStringReader var1, C var2);

        public P lookupPredicateType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listPredicateTypes();

        public T createPredicateTest(ImmutableStringReader var1, P var2, Dynamic<?> var3) throws CommandSyntaxException;

        public T negate(T var1);

        public T anyOf(List<T> var1);
    }

    static class TagLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        TagLookupRule(NamedRule<StringReader, ResourceLocation> var0, Context<T, C, P> var1) {
            super(var0, var1);
        }

        @Override
        protected T validateElement(ImmutableStringReader var0, ResourceLocation var1) throws Exception {
            return ((Context)this.context).forTagType(var0, var1);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listTagTypes();
        }
    }

    static class ComponentLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, C> {
        ComponentLookupRule(NamedRule<StringReader, ResourceLocation> var0, Context<T, C, P> var1) {
            super(var0, var1);
        }

        @Override
        protected C validateElement(ImmutableStringReader var0, ResourceLocation var1) throws Exception {
            return ((Context)this.context).lookupComponentType(var0, var1);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listComponentTypes();
        }
    }

    static class PredicateLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, P> {
        PredicateLookupRule(NamedRule<StringReader, ResourceLocation> var0, Context<T, C, P> var1) {
            super(var0, var1);
        }

        @Override
        protected P validateElement(ImmutableStringReader var0, ResourceLocation var1) throws Exception {
            return ((Context)this.context).lookupPredicateType(var0, var1);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listPredicateTypes();
        }
    }
}

