/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.EntryAction;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.ContinuationTask;
import net.minecraft.commands.execution.tasks.ExecuteCommand;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.network.chat.Component;

public class BuildContexts<T extends ExecutionCommandSource<T>> {
    @VisibleForTesting
    public static final DynamicCommandExceptionType ERROR_FORK_LIMIT_REACHED = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("command.forkLimit", var0));
    private final String commandInput;
    private final ContextChain<T> command;

    public BuildContexts(String var0, ContextChain<T> var1) {
        this.commandInput = var0;
        this.command = var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(T var02, List<T> var12, ExecutionContext<T> var22, Frame var3, ChainModifiers var4) {
        ExecuteCommand<ExecutionCommandSource> var10;
        Command var9;
        ContextChain var5 = this.command;
        ChainModifiers var6 = var4;
        List<Object> var7 = var12;
        if (var5.getStage() != ContextChain.Stage.EXECUTE) {
            var22.profiler().push(() -> "prepare " + this.commandInput);
            try {
                int var8 = var22.forkLimit();
                while (var5.getStage() != ContextChain.Stage.EXECUTE) {
                    var9 = var5.getTopContext();
                    if (var9.isForked()) {
                        var6 = var6.setForked();
                    }
                    if ((var10 = var9.getRedirectModifier()) instanceof CustomModifierExecutor) {
                        CustomModifierExecutor var11 = (CustomModifierExecutor)((Object)var10);
                        var11.apply(var02, var7, var5, var6, ExecutionControl.create(var22, var3));
                        return;
                    }
                    if (var10 != null) {
                        var22.incrementCost();
                        boolean var11 = var6.isForked();
                        ObjectArrayList var122 = new ObjectArrayList();
                        for (ExecutionCommandSource executionCommandSource : var7) {
                            Collection var15;
                            block21: {
                                try {
                                    var15 = ContextChain.runModifier((CommandContext)var9, (Object)executionCommandSource, (var0, var1, var2) -> {}, (boolean)var11);
                                    if (var122.size() + var15.size() < var8) break block21;
                                    var02.handleError(ERROR_FORK_LIMIT_REACHED.create((Object)var8), var11, var22.tracer());
                                    return;
                                }
                                catch (CommandSyntaxException var152) {
                                    executionCommandSource.handleError(var152, var11, var22.tracer());
                                    if (var11) continue;
                                    var22.profiler().pop();
                                    return;
                                }
                            }
                            var122.addAll(var15);
                        }
                        var7 = var122;
                    }
                    var5 = var5.nextStage();
                }
            }
            finally {
                var22.profiler().pop();
            }
        }
        if (var7.isEmpty()) {
            if (var6.isReturn()) {
                var22.queueNext(new CommandQueueEntry(var3, FallthroughTask.instance()));
            }
            return;
        }
        CommandContext var8 = var5.getTopContext();
        var9 = var8.getCommand();
        if (var9 instanceof CustomCommandExecutor) {
            var10 = (CustomCommandExecutor)var9;
            ExecutionControl var11 = ExecutionControl.create(var22, var3);
            for (ExecutionCommandSource executionCommandSource : var7) {
                var10.run(executionCommandSource, (ContextChain<ExecutionCommandSource>)var5, var6, var11);
            }
        } else {
            if (var6.isReturn()) {
                var10 = (ExecutionCommandSource)var7.get(0);
                var10 = var10.withCallback(CommandResultCallback.chain(var10.callback(), var3.returnValueConsumer()));
                var7 = List.of(var10);
            }
            var10 = new ExecuteCommand(this.commandInput, var6, var8);
            ContinuationTask.schedule(var22, var3, var7, (var1, var2) -> new CommandQueueEntry<ExecutionCommandSource>(var1, var10.bind((ExecutionCommandSource)var2)));
        }
    }

    protected void traceCommandStart(ExecutionContext<T> var0, Frame var1) {
        TraceCallbacks var2 = var0.tracer();
        if (var2 != null) {
            var2.onCommand(var1.depth(), this.commandInput);
        }
    }

    public String toString() {
        return this.commandInput;
    }

    public static class TopLevel<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements EntryAction<T> {
        private final T source;

        public TopLevel(String var0, ContextChain<T> var1, T var2) {
            super(var0, var1);
            this.source = var2;
        }

        @Override
        public void execute(ExecutionContext<T> var0, Frame var1) {
            this.traceCommandStart(var0, var1);
            this.execute(this.source, List.of(this.source), var0, var1, ChainModifiers.DEFAULT);
        }
    }

    public static class Continuation<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements EntryAction<T> {
        private final ChainModifiers modifiers;
        private final T originalSource;
        private final List<T> sources;

        public Continuation(String var0, ContextChain<T> var1, ChainModifiers var2, T var3, List<T> var4) {
            super(var0, var1);
            this.originalSource = var3;
            this.sources = var4;
            this.modifiers = var2;
        }

        @Override
        public void execute(ExecutionContext<T> var0, Frame var1) {
            this.execute(this.originalSource, this.sources, var0, var1, this.modifiers);
        }
    }

    public static class Unbound<T extends ExecutionCommandSource<T>>
    extends BuildContexts<T>
    implements UnboundEntryAction<T> {
        public Unbound(String var0, ContextChain<T> var1) {
            super(var0, var1);
        }

        @Override
        public void execute(T var0, ExecutionContext<T> var1, Frame var2) {
            this.traceCommandStart(var1, var2);
            this.execute(var0, List.of(var0), var1, var2, ChainModifiers.DEFAULT);
        }

        @Override
        public /* synthetic */ void execute(Object object, ExecutionContext executionContext, Frame frame) {
            this.execute((ExecutionCommandSource)object, executionContext, frame);
        }
    }
}

