/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class IntegerArgumentInfo
implements ArgumentTypeInfo<IntegerArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
        boolean var2 = var0.min != Integer.MIN_VALUE;
        boolean var3 = var0.max != Integer.MAX_VALUE;
        var1.writeByte(ArgumentUtils.createNumberFlags(var2, var3));
        if (var2) {
            var1.writeInt(var0.min);
        }
        if (var3) {
            var1.writeInt(var0.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf var0) {
        byte var1 = var0.readByte();
        int var2 = ArgumentUtils.numberHasMin(var1) ? var0.readInt() : Integer.MIN_VALUE;
        int var3 = ArgumentUtils.numberHasMax(var1) ? var0.readInt() : Integer.MAX_VALUE;
        return new Template(var2, var3);
    }

    @Override
    public void serializeToJson(Template var0, JsonObject var1) {
        if (var0.min != Integer.MIN_VALUE) {
            var1.addProperty("min", (Number)var0.min);
        }
        if (var0.max != Integer.MAX_VALUE) {
            var1.addProperty("max", (Number)var0.max);
        }
    }

    @Override
    public Template unpack(IntegerArgumentType var0) {
        return new Template(var0.getMinimum(), var0.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        return this.deserializeFromNetwork(friendlyByteBuf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<IntegerArgumentType> {
        final int min;
        final int max;

        Template(int var1, int var2) {
            this.min = var1;
            this.max = var2;
        }

        @Override
        public IntegerArgumentType instantiate(CommandBuildContext var0) {
            return IntegerArgumentType.integer((int)this.min, (int)this.max);
        }

        @Override
        public ArgumentTypeInfo<IntegerArgumentType, ?> type() {
            return IntegerArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return this.instantiate(commandBuildContext);
        }
    }
}

