/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import net.minecraft.core.Direction;

public enum AxisCycle {
    NONE{

        @Override
        public int cycle(int var0, int var1, int var2, Direction.Axis var3) {
            return var3.choose(var0, var1, var2);
        }

        @Override
        public double cycle(double var0, double var2, double var4, Direction.Axis var6) {
            return var6.choose(var0, var2, var4);
        }

        @Override
        public Direction.Axis cycle(Direction.Axis var0) {
            return var0;
        }

        @Override
        public AxisCycle inverse() {
            return this;
        }
    }
    ,
    FORWARD{

        @Override
        public int cycle(int var0, int var1, int var2, Direction.Axis var3) {
            return var3.choose(var2, var0, var1);
        }

        @Override
        public double cycle(double var0, double var2, double var4, Direction.Axis var6) {
            return var6.choose(var4, var0, var2);
        }

        @Override
        public Direction.Axis cycle(Direction.Axis var0) {
            return AXIS_VALUES[Math.floorMod(var0.ordinal() + 1, 3)];
        }

        @Override
        public AxisCycle inverse() {
            return BACKWARD;
        }
    }
    ,
    BACKWARD{

        @Override
        public int cycle(int var0, int var1, int var2, Direction.Axis var3) {
            return var3.choose(var1, var2, var0);
        }

        @Override
        public double cycle(double var0, double var2, double var4, Direction.Axis var6) {
            return var6.choose(var2, var4, var0);
        }

        @Override
        public Direction.Axis cycle(Direction.Axis var0) {
            return AXIS_VALUES[Math.floorMod(var0.ordinal() - 1, 3)];
        }

        @Override
        public AxisCycle inverse() {
            return FORWARD;
        }
    };

    public static final Direction.Axis[] AXIS_VALUES;
    public static final AxisCycle[] VALUES;

    public abstract int cycle(int var1, int var2, int var3, Direction.Axis var4);

    public abstract double cycle(double var1, double var3, double var5, Direction.Axis var7);

    public abstract Direction.Axis cycle(Direction.Axis var1);

    public abstract AxisCycle inverse();

    public static AxisCycle between(Direction.Axis var0, Direction.Axis var1) {
        return VALUES[Math.floorMod(var1.ordinal() - var0.ordinal(), 3)];
    }

    static {
        AXIS_VALUES = Direction.Axis.values();
        VALUES = AxisCycle.values();
    }
}

