/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.repository.KnownPack;

public class RegistrySynchronization {
    private static final Set<ResourceKey<? extends Registry<?>>> NETWORKABLE_REGISTRIES = RegistryDataLoader.SYNCHRONIZED_REGISTRIES.stream().map(RegistryDataLoader.RegistryData::key).collect(Collectors.toUnmodifiableSet());

    public static void packRegistries(DynamicOps<Tag> var0, RegistryAccess var1, Set<KnownPack> var2, BiConsumer<ResourceKey<? extends Registry<?>>, List<PackedRegistryEntry>> var3) {
        RegistryDataLoader.SYNCHRONIZED_REGISTRIES.forEach(var4 -> RegistrySynchronization.packRegistry(var0, var4, var1, var2, var3));
    }

    private static <T> void packRegistry(DynamicOps<Tag> var0, RegistryDataLoader.RegistryData<T> var1, RegistryAccess var2, Set<KnownPack> var3, BiConsumer<ResourceKey<? extends Registry<?>>, List<PackedRegistryEntry>> var42) {
        var2.lookup(var1.key()).ifPresent(var4 -> {
            ArrayList var52 = new ArrayList(var4.size());
            var4.listElements().forEach(var5 -> {
                Optional<Tag> var7;
                boolean var6 = var4.registrationInfo(var5.key()).flatMap(RegistrationInfo::knownPackInfo).filter(var3::contains).isPresent();
                if (var6) {
                    var7 = Optional.empty();
                } else {
                    Tag var8 = (Tag)var1.elementCodec().encodeStart(var0, var5.value()).getOrThrow(var1 -> new IllegalArgumentException("Failed to serialize " + String.valueOf(var5.key()) + ": " + var1));
                    var7 = Optional.of(var8);
                }
                var52.add(new PackedRegistryEntry(var5.key().location(), var7));
            });
            var42.accept(var4.key(), var52);
        });
    }

    private static Stream<RegistryAccess.RegistryEntry<?>> ownedNetworkableRegistries(RegistryAccess var02) {
        return var02.registries().filter(var0 -> RegistrySynchronization.isNetworkable(var0.key()));
    }

    public static Stream<RegistryAccess.RegistryEntry<?>> networkedRegistries(LayeredRegistryAccess<RegistryLayer> var0) {
        return RegistrySynchronization.ownedNetworkableRegistries(var0.getAccessFrom(RegistryLayer.WORLDGEN));
    }

    public static Stream<RegistryAccess.RegistryEntry<?>> networkSafeRegistries(LayeredRegistryAccess<RegistryLayer> var0) {
        Stream<RegistryAccess.RegistryEntry<?>> var1 = var0.getLayer(RegistryLayer.STATIC).registries();
        Stream<RegistryAccess.RegistryEntry<?>> var2 = RegistrySynchronization.networkedRegistries(var0);
        return Stream.concat(var2, var1);
    }

    public static boolean isNetworkable(ResourceKey<? extends Registry<?>> var0) {
        return NETWORKABLE_REGISTRIES.contains(var0);
    }

    public record PackedRegistryEntry(ResourceLocation id, Optional<Tag> data) {
        public static final StreamCodec<ByteBuf, PackedRegistryEntry> STREAM_CODEC = StreamCodec.composite(ResourceLocation.STREAM_CODEC, PackedRegistryEntry::id, ByteBufCodecs.TAG.apply(ByteBufCodecs::optional), PackedRegistryEntry::data, PackedRegistryEntry::new);
    }
}

