/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.block.DispenserBlock;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.projectiles.CraftBlockProjectileSource;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ProjectileDispenseBehavior
extends DefaultDispenseItemBehavior {
    private final ProjectileItem projectileItem;
    private final ProjectileItem.DispenseConfig dispenseConfig;

    public ProjectileDispenseBehavior(Item item) {
        ProjectileItem projectileitem;
        if (!(item instanceof ProjectileItem)) {
            String s = String.valueOf(item);
            throw new IllegalArgumentException(s + " not instance of " + ProjectileItem.class.getSimpleName());
        }
        this.projectileItem = projectileitem = (ProjectileItem)((Object)item);
        this.dispenseConfig = projectileitem.createDispenseConfig();
    }

    @Override
    public net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        ServerLevel worldserver = sourceblock.level();
        Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
        Position iposition = this.dispenseConfig.positionFunction().getDispensePosition(sourceblock, enumdirection);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
        CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), new Vector((double)enumdirection.getStepX(), (double)enumdirection.getStepY(), (double)enumdirection.getStepZ()));
        if (!DispenserBlock.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            itemstack.grow(1);
            return itemstack;
        }
        if (!event.getItem().equals((Object)craftItem)) {
            itemstack.grow(1);
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != DispenseItemBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return itemstack;
            }
        }
        if (!itemstack1.isEmpty()) {
            Projectile iprojectile = Projectile.spawnProjectileUsingShoot(this.projectileItem.asProjectile(worldserver, iposition, itemstack1, enumdirection), worldserver, itemstack1, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), this.dispenseConfig.power(), this.dispenseConfig.uncertainty());
            iprojectile.projectileSource = new CraftBlockProjectileSource(sourceblock.blockEntity());
        }
        return itemstack;
    }

    @Override
    protected void playSound(BlockSource sourceblock) {
        sourceblock.level().levelEvent(this.dispenseConfig.overrideDispenseEvent().orElse(1002), sourceblock.pos(), 0);
    }
}

