/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.ReportGameListener;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class GameTestRunner {
    public static final int DEFAULT_TESTS_PER_ROW = 8;
    private static final Logger LOGGER = LogUtils.getLogger();
    final ServerLevel level;
    private final GameTestTicker testTicker;
    private final List<GameTestInfo> allTestInfos;
    private ImmutableList<GameTestBatch> batches;
    final List<GameTestBatchListener> batchListeners = Lists.newArrayList();
    private final List<GameTestInfo> scheduledForRerun = Lists.newArrayList();
    private final GameTestBatcher testBatcher;
    private boolean stopped = true;
    @Nullable
    private Holder<TestEnvironmentDefinition> currentEnvironment;
    private final StructureSpawner existingStructureSpawner;
    private final StructureSpawner newStructureSpawner;
    final boolean haltOnError;

    protected GameTestRunner(GameTestBatcher var02, Collection<GameTestBatch> var1, ServerLevel var2, GameTestTicker var3, StructureSpawner var4, StructureSpawner var5, boolean var6) {
        this.level = var2;
        this.testTicker = var3;
        this.testBatcher = var02;
        this.existingStructureSpawner = var4;
        this.newStructureSpawner = var5;
        this.batches = ImmutableList.copyOf(var1);
        this.haltOnError = var6;
        this.allTestInfos = this.batches.stream().flatMap(var0 -> var0.gameTestInfos().stream()).collect(Util.toMutableList());
        var3.setRunner(this);
        this.allTestInfos.forEach(var0 -> var0.addListener(new ReportGameListener()));
    }

    public List<GameTestInfo> getTestInfos() {
        return this.allTestInfos;
    }

    public void start() {
        this.stopped = false;
        this.runBatch(0);
    }

    public void stop() {
        this.stopped = true;
        if (this.currentEnvironment != null) {
            this.endCurrentEnvironment();
        }
    }

    public void rerunTest(GameTestInfo var0) {
        GameTestInfo var1 = var0.copyReset();
        var0.getListeners().forEach(var2 -> var2.testAddedForRerun(var0, var1, this));
        this.allTestInfos.add(var1);
        this.scheduledForRerun.add(var1);
        if (this.stopped) {
            this.runScheduledRerunTests();
        }
    }

    void runBatch(final int var0) {
        if (var0 >= this.batches.size()) {
            this.endCurrentEnvironment();
            this.runScheduledRerunTests();
            return;
        }
        final GameTestBatch var12 = (GameTestBatch)this.batches.get(var0);
        this.existingStructureSpawner.onBatchStart(this.level);
        this.newStructureSpawner.onBatchStart(this.level);
        Collection<GameTestInfo> var2 = this.createStructuresForBatch(var12.gameTestInfos());
        LOGGER.info("Running test environment '{}' batch {} ({} tests)...", new Object[]{var12.environment().getRegisteredName(), var12.index(), var2.size()});
        if (this.currentEnvironment != var12.environment()) {
            this.endCurrentEnvironment();
            this.currentEnvironment = var12.environment();
            this.currentEnvironment.value().setup(this.level);
        }
        this.batchListeners.forEach(var1 -> var1.testBatchStarting(var12));
        final MultipleTestTracker var3 = new MultipleTestTracker();
        var2.forEach(var3::addTestToTrack);
        var3.addListener(new GameTestListener(){

            private void testCompleted() {
                if (var3.isDone()) {
                    GameTestRunner.this.batchListeners.forEach(var1 -> var1.testBatchFinished(var12));
                    LongArraySet var02 = new LongArraySet(GameTestRunner.this.level.getForceLoadedChunks());
                    var02.forEach(var0 -> GameTestRunner.this.level.setChunkForced(ChunkPos.getX(var0), ChunkPos.getZ(var0), false));
                    GameTestRunner.this.runBatch(var0 + 1);
                }
            }

            @Override
            public void testStructureLoaded(GameTestInfo var02) {
            }

            @Override
            public void testPassed(GameTestInfo var02, GameTestRunner var1) {
                this.testCompleted();
            }

            @Override
            public void testFailed(GameTestInfo var02, GameTestRunner var1) {
                if (GameTestRunner.this.haltOnError) {
                    GameTestRunner.this.endCurrentEnvironment();
                    LongArraySet var2 = new LongArraySet(GameTestRunner.this.level.getForceLoadedChunks());
                    var2.forEach(var0 -> GameTestRunner.this.level.setChunkForced(ChunkPos.getX(var0), ChunkPos.getZ(var0), false));
                    GameTestTicker.SINGLETON.clear();
                } else {
                    this.testCompleted();
                }
            }

            @Override
            public void testAddedForRerun(GameTestInfo var02, GameTestInfo var1, GameTestRunner var2) {
            }
        });
        var2.forEach(this.testTicker::add);
    }

    void endCurrentEnvironment() {
        if (this.currentEnvironment != null) {
            this.currentEnvironment.value().teardown(this.level);
            this.currentEnvironment = null;
        }
    }

    private void runScheduledRerunTests() {
        if (!this.scheduledForRerun.isEmpty()) {
            LOGGER.info("Starting re-run of tests: {}", (Object)this.scheduledForRerun.stream().map(var0 -> var0.id().toString()).collect(Collectors.joining(", ")));
            this.batches = ImmutableList.copyOf(this.testBatcher.batch(this.scheduledForRerun));
            this.scheduledForRerun.clear();
            this.stopped = false;
            this.runBatch(0);
        } else {
            this.batches = ImmutableList.of();
            this.stopped = true;
        }
    }

    public void addListener(GameTestBatchListener var0) {
        this.batchListeners.add(var0);
    }

    private Collection<GameTestInfo> createStructuresForBatch(Collection<GameTestInfo> var0) {
        return var0.stream().map(this::spawn).flatMap(Optional::stream).toList();
    }

    private Optional<GameTestInfo> spawn(GameTestInfo var0) {
        if (var0.getTestBlockPos() == null) {
            return this.newStructureSpawner.spawnStructure(var0);
        }
        return this.existingStructureSpawner.spawnStructure(var0);
    }

    public static void clearMarkers(ServerLevel var0) {
        DebugPackets.sendGameTestClearPacket(var0);
    }

    public static interface GameTestBatcher {
        public Collection<GameTestBatch> batch(Collection<GameTestInfo> var1);
    }

    public static interface StructureSpawner {
        public static final StructureSpawner IN_PLACE = var02 -> Optional.ofNullable(var02.prepareTestStructure()).map(var0 -> var0.startExecution(1));
        public static final StructureSpawner NOT_SET = var0 -> Optional.empty();

        public Optional<GameTestInfo> spawnStructure(GameTestInfo var1);

        default public void onBatchStart(ServerLevel var0) {
        }
    }

    public static class Builder {
        private final ServerLevel level;
        private final GameTestTicker testTicker = GameTestTicker.SINGLETON;
        private GameTestBatcher batcher = GameTestBatchFactory.fromGameTestInfo();
        private StructureSpawner existingStructureSpawner = StructureSpawner.IN_PLACE;
        private StructureSpawner newStructureSpawner = StructureSpawner.NOT_SET;
        private final Collection<GameTestBatch> batches;
        private boolean haltOnError = false;

        private Builder(Collection<GameTestBatch> var0, ServerLevel var1) {
            this.batches = var0;
            this.level = var1;
        }

        public static Builder fromBatches(Collection<GameTestBatch> var0, ServerLevel var1) {
            return new Builder(var0, var1);
        }

        public static Builder fromInfo(Collection<GameTestInfo> var0, ServerLevel var1) {
            return Builder.fromBatches(GameTestBatchFactory.fromGameTestInfo().batch(var0), var1);
        }

        public Builder haltOnError(boolean var0) {
            this.haltOnError = var0;
            return this;
        }

        public Builder newStructureSpawner(StructureSpawner var0) {
            this.newStructureSpawner = var0;
            return this;
        }

        public Builder existingStructureSpawner(StructureGridSpawner var0) {
            this.existingStructureSpawner = var0;
            return this;
        }

        public Builder batcher(GameTestBatcher var0) {
            this.batcher = var0;
            return this;
        }

        public GameTestRunner build() {
            return new GameTestRunner(this.batcher, this.batches, this.level, this.testTicker, this.existingStructureSpawner, this.newStructureSpawner, this.haltOnError);
        }
    }
}

