/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;

public class MultipleTestTracker {
    private static final char NOT_STARTED_TEST_CHAR = ' ';
    private static final char ONGOING_TEST_CHAR = '_';
    private static final char SUCCESSFUL_TEST_CHAR = '+';
    private static final char FAILED_OPTIONAL_TEST_CHAR = 'x';
    private static final char FAILED_REQUIRED_TEST_CHAR = 'X';
    private final Collection<GameTestInfo> tests = Lists.newArrayList();
    private final Collection<GameTestListener> listeners = Lists.newArrayList();

    public MultipleTestTracker() {
    }

    public MultipleTestTracker(Collection<GameTestInfo> var0) {
        this.tests.addAll(var0);
    }

    public void addTestToTrack(GameTestInfo var0) {
        this.tests.add(var0);
        this.listeners.forEach(var0::addListener);
    }

    public void addListener(GameTestListener var0) {
        this.listeners.add(var0);
        this.tests.forEach(var1 -> var1.addListener(var0));
    }

    public void addFailureListener(final Consumer<GameTestInfo> var0) {
        this.addListener(new GameTestListener(this){

            @Override
            public void testStructureLoaded(GameTestInfo var02) {
            }

            @Override
            public void testPassed(GameTestInfo var02, GameTestRunner var1) {
            }

            @Override
            public void testFailed(GameTestInfo var02, GameTestRunner var1) {
                var0.accept(var02);
            }

            @Override
            public void testAddedForRerun(GameTestInfo var02, GameTestInfo var1, GameTestRunner var2) {
            }
        });
    }

    public int getFailedRequiredCount() {
        return (int)this.tests.stream().filter(GameTestInfo::hasFailed).filter(GameTestInfo::isRequired).count();
    }

    public int getFailedOptionalCount() {
        return (int)this.tests.stream().filter(GameTestInfo::hasFailed).filter(GameTestInfo::isOptional).count();
    }

    public int getDoneCount() {
        return (int)this.tests.stream().filter(GameTestInfo::isDone).count();
    }

    public boolean hasFailedRequired() {
        return this.getFailedRequiredCount() > 0;
    }

    public boolean hasFailedOptional() {
        return this.getFailedOptionalCount() > 0;
    }

    public Collection<GameTestInfo> getFailedRequired() {
        return this.tests.stream().filter(GameTestInfo::hasFailed).filter(GameTestInfo::isRequired).collect(Collectors.toList());
    }

    public Collection<GameTestInfo> getFailedOptional() {
        return this.tests.stream().filter(GameTestInfo::hasFailed).filter(GameTestInfo::isOptional).collect(Collectors.toList());
    }

    public int getTotalCount() {
        return this.tests.size();
    }

    public boolean isDone() {
        return this.getDoneCount() == this.getTotalCount();
    }

    public String getProgressBar() {
        StringBuffer var0 = new StringBuffer();
        var0.append('[');
        this.tests.forEach(var1 -> {
            if (!var1.hasStarted()) {
                var0.append(' ');
            } else if (var1.hasSucceeded()) {
                var0.append('+');
            } else if (var1.hasFailed()) {
                var0.append(var1.isRequired() ? (char)'X' : (char)'x');
            } else {
                var0.append('_');
            }
        });
        var0.append(']');
        return var0.toString();
    }

    public String toString() {
        return this.getProgressBar();
    }

    public void remove(GameTestInfo var0) {
        this.tests.remove(var0);
    }
}

