/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;
import org.spigotmc.LimitStream;

public class NbtIo {
    private static final OpenOption[] SYNC_OUTPUT_OPTIONS = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static CompoundTag readCompressed(Path path, NbtAccounter nbtreadlimiter) throws IOException {
        CompoundTag nbttagcompound;
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream inputstream1 = new FastBufferedInputStream(inputstream);){
            nbttagcompound = NbtIo.readCompressed(inputstream1, nbtreadlimiter);
        }
        return nbttagcompound;
    }

    private static DataInputStream createDecompressorStream(InputStream inputstream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(inputstream)));
    }

    private static DataOutputStream createCompressorStream(OutputStream outputstream) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputstream)));
    }

    public static CompoundTag readCompressed(InputStream inputstream, NbtAccounter nbtreadlimiter) throws IOException {
        try (DataInputStream datainputstream = NbtIo.createDecompressorStream(inputstream);){
            CompoundTag compoundTag = NbtIo.read(datainputstream, nbtreadlimiter);
            return compoundTag;
        }
    }

    public static void parseCompressed(Path path, StreamTagVisitor streamtagvisitor, NbtAccounter nbtreadlimiter) throws IOException {
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream inputstream1 = new FastBufferedInputStream(inputstream);){
            NbtIo.parseCompressed(inputstream1, streamtagvisitor, nbtreadlimiter);
        }
    }

    public static void parseCompressed(InputStream inputstream, StreamTagVisitor streamtagvisitor, NbtAccounter nbtreadlimiter) throws IOException {
        try (DataInputStream datainputstream = NbtIo.createDecompressorStream(inputstream);){
            NbtIo.parse(datainputstream, streamtagvisitor, nbtreadlimiter);
        }
    }

    public static void writeCompressed(CompoundTag nbttagcompound, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream outputstream1 = new BufferedOutputStream(outputstream);){
            NbtIo.writeCompressed(nbttagcompound, outputstream1);
        }
    }

    public static void writeCompressed(CompoundTag nbttagcompound, OutputStream outputstream) throws IOException {
        try (DataOutputStream dataoutputstream = NbtIo.createCompressorStream(outputstream);){
            NbtIo.write(nbttagcompound, dataoutputstream);
        }
    }

    public static void write(CompoundTag nbttagcompound, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream outputstream1 = new BufferedOutputStream(outputstream);
             DataOutputStream dataoutputstream = new DataOutputStream(outputstream1);){
            NbtIo.write(nbttagcompound, dataoutputstream);
        }
    }

    @Nullable
    public static CompoundTag read(Path path) throws IOException {
        CompoundTag nbttagcompound;
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             DataInputStream datainputstream = new DataInputStream(inputstream);){
            nbttagcompound = NbtIo.read(datainputstream, NbtAccounter.unlimitedHeap());
        }
        return nbttagcompound;
    }

    public static CompoundTag read(DataInput datainput) throws IOException {
        return NbtIo.read(datainput, NbtAccounter.unlimitedHeap());
    }

    public static CompoundTag read(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
        Tag nbtbase;
        if (datainput instanceof ByteBufInputStream) {
            datainput = new DataInputStream(new LimitStream((InputStream)((Object)datainput), nbtreadlimiter));
        }
        if ((nbtbase = NbtIo.readUnnamedTag(datainput, nbtreadlimiter)) instanceof CompoundTag) {
            return (CompoundTag)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(CompoundTag nbttagcompound, DataOutput dataoutput) throws IOException {
        NbtIo.writeUnnamedTagWithFallback(nbttagcompound, dataoutput);
    }

    public static void parse(DataInput datainput, StreamTagVisitor streamtagvisitor, NbtAccounter nbtreadlimiter) throws IOException {
        TagType<?> nbttagtype = TagTypes.getType(datainput.readByte());
        if (nbttagtype == EndTag.TYPE) {
            if (streamtagvisitor.visitRootEntry(EndTag.TYPE) == StreamTagVisitor.ValueResult.CONTINUE) {
                streamtagvisitor.visitEnd();
            }
        } else {
            switch (streamtagvisitor.visitRootEntry(nbttagtype)) {
                default: {
                    break;
                }
                case BREAK: {
                    StringTag.skipString(datainput);
                    nbttagtype.skip(datainput, nbtreadlimiter);
                    break;
                }
                case CONTINUE: {
                    StringTag.skipString(datainput);
                    nbttagtype.parse(datainput, streamtagvisitor, nbtreadlimiter);
                }
            }
        }
    }

    public static Tag readAnyTag(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
        byte b0 = datainput.readByte();
        return b0 == 0 ? EndTag.INSTANCE : NbtIo.readTagSafe(datainput, nbtreadlimiter, b0);
    }

    public static void writeAnyTag(Tag nbtbase, DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(nbtbase.getId());
        if (nbtbase.getId() != 0) {
            nbtbase.write(dataoutput);
        }
    }

    public static void writeUnnamedTag(Tag nbtbase, DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(nbtbase.getId());
        if (nbtbase.getId() != 0) {
            dataoutput.writeUTF("");
            nbtbase.write(dataoutput);
        }
    }

    public static void writeUnnamedTagWithFallback(Tag nbtbase, DataOutput dataoutput) throws IOException {
        NbtIo.writeUnnamedTag(nbtbase, new StringFallbackDataOutput(dataoutput));
    }

    @VisibleForTesting
    public static Tag readUnnamedTag(DataInput datainput, NbtAccounter nbtreadlimiter) throws IOException {
        byte b0 = datainput.readByte();
        if (b0 == 0) {
            return EndTag.INSTANCE;
        }
        StringTag.skipString(datainput);
        return NbtIo.readTagSafe(datainput, nbtreadlimiter, b0);
    }

    private static Tag readTagSafe(DataInput datainput, NbtAccounter nbtreadlimiter, byte b0) {
        try {
            return TagTypes.getType(b0).load(datainput, nbtreadlimiter);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.forThrowable(ioexception, "Loading NBT data");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("NBT Tag");
            crashreportsystemdetails.setDetail("Tag type", b0);
            throw new ReportedNbtException(crashreport);
        }
    }

    public static class StringFallbackDataOutput
    extends DelegateDataOutput {
        public StringFallbackDataOutput(DataOutput dataoutput) {
            super(dataoutput);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            try {
                super.writeUTF(s);
            }
            catch (UTFDataFormatException utfdataformatexception) {
                Util.logAndPauseIfInIde("Failed to write NBT String", utfdataformatexception);
                super.writeUTF("");
            }
        }
    }
}

