/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps INSTANCE = new NbtOps();

    private NbtOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U convertTo(DynamicOps<U> var0, Tag var1) {
        Object object;
        Tag tag = var1;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EndTag.class, ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class, ByteArrayTag.class, StringTag.class, ListTag.class, CompoundTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)tag2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                EndTag var4 = (EndTag)tag2;
                object = var0.empty();
                return (U)object;
            }
            case 1: {
                byte var6;
                ByteTag byteTag = (ByteTag)tag2;
                try {
                    byte by;
                    var6 = by = byteTag.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                object = var0.createByte(var6);
                return (U)object;
            }
            case 2: {
                short var8;
                ShortTag shortTag = (ShortTag)tag2;
                {
                    short s;
                    var8 = s = shortTag.value();
                }
                object = var0.createShort(var8);
                return (U)object;
            }
            case 3: {
                int var10;
                IntTag intTag = (IntTag)tag2;
                {
                    int n2;
                    var10 = n2 = intTag.value();
                }
                object = var0.createInt(var10);
                return (U)object;
            }
            case 4: {
                long var12;
                LongTag longTag = (LongTag)tag2;
                {
                    long l;
                    var12 = l = longTag.value();
                }
                object = var0.createLong(var12);
                return (U)object;
            }
            case 5: {
                float var15;
                FloatTag floatTag = (FloatTag)tag2;
                {
                    float f;
                    var15 = f = floatTag.value();
                }
                object = var0.createFloat(var15);
                return (U)object;
            }
            case 6: {
                double var17;
                DoubleTag doubleTag = (DoubleTag)tag2;
                {
                    double d;
                    var17 = d = doubleTag.value();
                }
                object = var0.createDouble(var17);
                return (U)object;
            }
            case 7: {
                ByteArrayTag var19 = (ByteArrayTag)tag2;
                object = var0.createByteList(ByteBuffer.wrap(var19.getAsByteArray()));
                return (U)object;
            }
            case 8: {
                String var21;
                StringTag stringTag = (StringTag)tag2;
                {
                    String string;
                    var21 = string = stringTag.value();
                }
                object = var0.createString(var21);
                return (U)object;
            }
            case 9: {
                ListTag var22 = (ListTag)tag2;
                object = this.convertList(var0, var22);
                return (U)object;
            }
            case 10: {
                CompoundTag var23 = (CompoundTag)tag2;
                object = this.convertMap(var0, var23);
                return (U)object;
            }
            case 11: {
                IntArrayTag var24 = (IntArrayTag)tag2;
                object = var0.createIntList(Arrays.stream(var24.getAsIntArray()));
                return (U)object;
            }
            case 12: 
        }
        LongArrayTag var25 = (LongArrayTag)tag2;
        object = var0.createLongList(Arrays.stream(var25.getAsLongArray()));
        return (U)object;
    }

    public DataResult<Number> getNumberValue(Tag var0) {
        return var0.asNumber().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Not a number"));
    }

    public Tag createNumeric(Number var0) {
        return DoubleTag.valueOf(var0.doubleValue());
    }

    public Tag createByte(byte var0) {
        return ByteTag.valueOf(var0);
    }

    public Tag createShort(short var0) {
        return ShortTag.valueOf(var0);
    }

    public Tag createInt(int var0) {
        return IntTag.valueOf(var0);
    }

    public Tag createLong(long var0) {
        return LongTag.valueOf(var0);
    }

    public Tag createFloat(float var0) {
        return FloatTag.valueOf(var0);
    }

    public Tag createDouble(double var0) {
        return DoubleTag.valueOf(var0);
    }

    public Tag createBoolean(boolean var0) {
        return ByteTag.valueOf(var0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<String> getStringValue(Tag var0) {
        String var2;
        if (!(var0 instanceof StringTag)) return DataResult.error(() -> "Not a string");
        StringTag stringTag = (StringTag)var0;
        try {
            String string;
            var2 = string = stringTag.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)var2);
    }

    public Tag createString(String var0) {
        return StringTag.valueOf(var0);
    }

    public DataResult<Tag> mergeToList(Tag var0, Tag var12) {
        return NbtOps.createCollector(var0).map(var1 -> DataResult.success((Object)var1.accept(var12).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(var0), (Object)var0));
    }

    public DataResult<Tag> mergeToList(Tag var0, List<Tag> var12) {
        return NbtOps.createCollector(var0).map(var1 -> DataResult.success((Object)var1.acceptAll(var12).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(var0), (Object)var0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Tag> mergeToMap(Tag var0, Tag var1, Tag var2) {
        CompoundTag compoundTag;
        String var3;
        if (!(var0 instanceof CompoundTag) && !(var0 instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(var0), (Object)var0);
        }
        if (!(var1 instanceof StringTag)) return DataResult.error(() -> "key is not a string: " + String.valueOf(var1), (Object)var0);
        StringTag stringTag = (StringTag)var1;
        try {
            String string;
            var3 = string = stringTag.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (var0 instanceof CompoundTag) {
            CompoundTag var5 = (CompoundTag)var0;
            compoundTag = var5.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag var4 = compoundTag;
        var4.put(var3, var2);
        return DataResult.success((Object)var4);
    }

    public DataResult<Tag> mergeToMap(Tag var0, MapLike<Tag> var1) {
        CompoundTag compoundTag;
        Object var3;
        if (!(var0 instanceof CompoundTag) && !(var0 instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(var0), (Object)var0);
        }
        if (var0 instanceof CompoundTag) {
            var3 = (CompoundTag)var0;
            compoundTag = ((CompoundTag)var3).shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag var2 = compoundTag;
        var3 = new ArrayList();
        var1.entries().forEach(arg_0 -> NbtOps.lambda$mergeToMap$12((List)var3, var2, arg_0));
        if (!var3.isEmpty()) {
            return DataResult.error(() -> NbtOps.lambda$mergeToMap$13((List)var3), (Object)var2);
        }
        return DataResult.success((Object)var2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataResult<Tag> mergeToMap(Tag var0, Map<Tag, Tag> var1) {
        CompoundTag compoundTag;
        Object var3;
        if (!(var0 instanceof CompoundTag) && !(var0 instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(var0), (Object)var0);
        }
        if (var0 instanceof CompoundTag) {
            var3 = (CompoundTag)var0;
            compoundTag = ((CompoundTag)var3).shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag var2 = compoundTag;
        var3 = new ArrayList();
        for (Map.Entry<Tag, Tag> var5 : var1.entrySet()) {
            Tag var6 = var5.getKey();
            if (var6 instanceof StringTag) {
                StringTag stringTag = (StringTag)var6;
                try {
                    String string;
                    String var8 = string = stringTag.value();
                    var2.put(var8, var5.getValue());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            var3.add(var6);
        }
        if (!var3.isEmpty()) {
            return DataResult.error(() -> NbtOps.lambda$mergeToMap$15((List)var3), (Object)var2);
        }
        return DataResult.success((Object)var2);
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag var02) {
        if (var02 instanceof CompoundTag) {
            CompoundTag var1 = (CompoundTag)var02;
            return DataResult.success(var1.entrySet().stream().map(var0 -> Pair.of((Object)this.createString((String)var0.getKey()), (Object)((Tag)var0.getValue()))));
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(var02));
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag var0) {
        if (var0 instanceof CompoundTag) {
            CompoundTag var12 = (CompoundTag)var0;
            return DataResult.success(var1 -> {
                for (Map.Entry<String, Tag> var3 : var12.entrySet()) {
                    var1.accept(this.createString(var3.getKey()), var3.getValue());
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(var0));
    }

    public DataResult<MapLike<Tag>> getMap(Tag var0) {
        if (var0 instanceof CompoundTag) {
            final CompoundTag var1 = (CompoundTag)var0;
            return DataResult.success((Object)new MapLike<Tag>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public Tag get(Tag var0) {
                    if (!(var0 instanceof StringTag)) throw new UnsupportedOperationException("Cannot get map entry with non-string key: " + String.valueOf(var0));
                    StringTag stringTag = (StringTag)var0;
                    try {
                        String string;
                        String var2 = string = stringTag.value();
                        return var1.get(var2);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }

                @Nullable
                public Tag get(String var0) {
                    return var1.get(var0);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return var1.entrySet().stream().map(var0 -> Pair.of((Object)NbtOps.this.createString((String)var0.getKey()), (Object)((Tag)var0.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(var1) + "]";
                }

                @Nullable
                public /* synthetic */ Object get(String string) {
                    return this.get(string);
                }

                @Nullable
                public /* synthetic */ Object get(Object object) {
                    return this.get((Tag)object);
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + String.valueOf(var0));
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> var0) {
        CompoundTag var12 = new CompoundTag();
        var0.forEach(var1 -> {
            Tag var2 = (Tag)var1.getFirst();
            Tag var3 = (Tag)var1.getSecond();
            if (!(var2 instanceof StringTag)) throw new UnsupportedOperationException("Cannot create map with non-string key: " + String.valueOf(var2));
            StringTag var5 = (StringTag)var2;
            try {
                String var6;
                String var4 = var6 = var5.value();
                var12.put(var4, var3);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
        return var12;
    }

    public DataResult<Stream<Tag>> getStream(Tag var0) {
        if (var0 instanceof CollectionTag) {
            CollectionTag var1 = (CollectionTag)var0;
            return DataResult.success(var1.stream());
        }
        return DataResult.error(() -> "Not a list");
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag var0) {
        if (var0 instanceof CollectionTag) {
            CollectionTag var1 = (CollectionTag)var0;
            return DataResult.success(var1::forEach);
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(var0));
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag var0) {
        if (var0 instanceof ByteArrayTag) {
            ByteArrayTag var1 = (ByteArrayTag)var0;
            return DataResult.success((Object)ByteBuffer.wrap(var1.getAsByteArray()));
        }
        return super.getByteBuffer((Object)var0);
    }

    public Tag createByteList(ByteBuffer var0) {
        ByteBuffer var1 = var0.duplicate().clear();
        byte[] var2 = new byte[var0.capacity()];
        var1.get(0, var2, 0, var2.length);
        return new ByteArrayTag(var2);
    }

    public DataResult<IntStream> getIntStream(Tag var0) {
        if (var0 instanceof IntArrayTag) {
            IntArrayTag var1 = (IntArrayTag)var0;
            return DataResult.success((Object)Arrays.stream(var1.getAsIntArray()));
        }
        return super.getIntStream((Object)var0);
    }

    public Tag createIntList(IntStream var0) {
        return new IntArrayTag(var0.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag var0) {
        if (var0 instanceof LongArrayTag) {
            LongArrayTag var1 = (LongArrayTag)var0;
            return DataResult.success((Object)Arrays.stream(var1.getAsLongArray()));
        }
        return super.getLongStream((Object)var0);
    }

    public Tag createLongList(LongStream var0) {
        return new LongArrayTag(var0.toArray());
    }

    public Tag createList(Stream<Tag> var0) {
        return new ListTag(var0.collect(Util.toMutableList()));
    }

    public Tag remove(Tag var0, String var1) {
        if (var0 instanceof CompoundTag) {
            CompoundTag var2 = (CompoundTag)var0;
            CompoundTag var3 = var2.shallowCopy();
            var3.remove(var1);
            return var3;
        }
        return var0;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder(this);
    }

    private static Optional<ListCollector> createCollector(Tag var0) {
        if (var0 instanceof EndTag) {
            return Optional.of(new GenericListCollector());
        }
        if (var0 instanceof CollectionTag) {
            CollectionTag var1 = (CollectionTag)var0;
            if (var1.isEmpty()) {
                return Optional.of(new GenericListCollector());
            }
            CollectionTag collectionTag = var1;
            Objects.requireNonNull(collectionTag);
            CollectionTag collectionTag2 = collectionTag;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ListTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)collectionTag2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ListTag var4 = (ListTag)collectionTag2;
                    yield Optional.of(new GenericListCollector(var4));
                }
                case 1 -> {
                    ByteArrayTag var5 = (ByteArrayTag)collectionTag2;
                    yield Optional.of(new ByteListCollector(var5.getAsByteArray()));
                }
                case 2 -> {
                    IntArrayTag var6 = (IntArrayTag)collectionTag2;
                    yield Optional.of(new IntListCollector(var6.getAsIntArray()));
                }
                case 3 -> {
                    LongArrayTag var7 = (LongArrayTag)collectionTag2;
                    yield Optional.of(new LongListCollector(var7.getAsLongArray()));
                }
            };
        }
        return Optional.empty();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((Tag)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((Tag)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((Tag)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((Tag)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((Tag)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((Tag)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((Tag)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((Tag)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((Tag)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((Tag)object, (MapLike<Tag>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Map map) {
        return this.mergeToMap((Tag)object, (Map<Tag, Tag>)map);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((Tag)object, (Tag)object2, (Tag)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((Tag)object, (List<Tag>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((Tag)object, (Tag)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((Tag)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((Tag)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (Tag)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    private static /* synthetic */ String lambda$mergeToMap$15(List var0) {
        return "some keys are not strings: " + String.valueOf(var0);
    }

    private static /* synthetic */ String lambda$mergeToMap$13(List var0) {
        return "some keys are not strings: " + String.valueOf(var0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ void lambda$mergeToMap$12(List var0, CompoundTag var1, Pair var2) {
        String var4;
        Tag var3 = (Tag)var2.getFirst();
        if (!(var3 instanceof StringTag)) {
            var0.add(var3);
            return;
        }
        StringTag var5 = (StringTag)var3;
        try {
            String var6;
            var4 = var6 = var5.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        var1.put(var4, (Tag)var2.getSecond());
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder(NbtOps nbtOps) {
            super((DynamicOps)nbtOps);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String var0, Tag var1, CompoundTag var2) {
            var2.put(var0, var1);
            return var2;
        }

        protected DataResult<Tag> build(CompoundTag var0, Tag var1) {
            if (var1 == null || var1 == EndTag.INSTANCE) {
                return DataResult.success((Object)var0);
            }
            if (var1 instanceof CompoundTag) {
                CompoundTag var2 = (CompoundTag)var1;
                CompoundTag var3 = var2.shallowCopy();
                for (Map.Entry<String, Tag> var5 : var0.entrySet()) {
                    var3.put(var5.getKey(), var5.getValue());
                }
                return DataResult.success((Object)var3);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(var1), (Object)var1);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.append(string, (Tag)object, (CompoundTag)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((CompoundTag)object, (Tag)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }

    static class GenericListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        GenericListCollector() {
        }

        GenericListCollector(ListTag var0) {
            this.result.addAll(var0);
        }

        public GenericListCollector(IntArrayList var02) {
            var02.forEach(var0 -> this.result.add(IntTag.valueOf(var0)));
        }

        public GenericListCollector(ByteArrayList var02) {
            var02.forEach(var0 -> this.result.add(ByteTag.valueOf(var0)));
        }

        public GenericListCollector(LongArrayList var02) {
            var02.forEach(var0 -> this.result.add(LongTag.valueOf(var0)));
        }

        @Override
        public ListCollector accept(Tag var0) {
            this.result.add(var0);
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList values = new ByteArrayList();

        public ByteListCollector(byte[] var0) {
            this.values.addElements(0, var0);
        }

        @Override
        public ListCollector accept(Tag var0) {
            if (var0 instanceof ByteTag) {
                ByteTag var1 = (ByteTag)var0;
                this.values.add(var1.byteValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(var0);
        }

        @Override
        public Tag result() {
            return new ByteArrayTag(this.values.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList values = new IntArrayList();

        public IntListCollector(int[] var0) {
            this.values.addElements(0, var0);
        }

        @Override
        public ListCollector accept(Tag var0) {
            if (var0 instanceof IntTag) {
                IntTag var1 = (IntTag)var0;
                this.values.add(var1.intValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(var0);
        }

        @Override
        public Tag result() {
            return new IntArrayTag(this.values.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList values = new LongArrayList();

        public LongListCollector(long[] var0) {
            this.values.addElements(0, var0);
        }

        @Override
        public ListCollector accept(Tag var0) {
            if (var0 instanceof LongTag) {
                LongTag var1 = (LongTag)var0;
                this.values.add(var1.longValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(var0);
        }

        @Override
        public Tag result() {
            return new LongArrayTag(this.values.toLongArray());
        }
    }

    static interface ListCollector {
        public ListCollector accept(Tag var1);

        default public ListCollector acceptAll(Iterable<Tag> var0) {
            ListCollector var1 = this;
            for (Tag var3 : var0) {
                var1 = var1.accept(var3);
            }
            return var1;
        }

        default public ListCollector acceptAll(Stream<Tag> var0) {
            return this.acceptAll(var0::iterator);
        }

        public Tag result();
    }
}

