/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;

public interface TagType<T extends Tag> {
    public T load(DataInput var1, NbtAccounter var2) throws IOException;

    public StreamTagVisitor.ValueResult parse(DataInput var1, StreamTagVisitor var2, NbtAccounter var3) throws IOException;

    default public void parseRoot(DataInput var0, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
        switch (var1.visitRootEntry(this)) {
            case CONTINUE: {
                this.parse(var0, var1, var2);
                break;
            }
            case HALT: {
                break;
            }
            case BREAK: {
                this.skip(var0, var2);
            }
        }
    }

    public void skip(DataInput var1, int var2, NbtAccounter var3) throws IOException;

    public void skip(DataInput var1, NbtAccounter var2) throws IOException;

    public String getName();

    public String getPrettyName();

    public static TagType<EndTag> createInvalid(final int var0) {
        return new TagType<EndTag>(){

            private IOException createException() {
                return new IOException("Invalid tag id: " + var0);
            }

            @Override
            public EndTag load(DataInput var02, NbtAccounter var1) throws IOException {
                throw this.createException();
            }

            @Override
            public StreamTagVisitor.ValueResult parse(DataInput var02, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
                throw this.createException();
            }

            @Override
            public void skip(DataInput var02, int var1, NbtAccounter var2) throws IOException {
                throw this.createException();
            }

            @Override
            public void skip(DataInput var02, NbtAccounter var1) throws IOException {
                throw this.createException();
            }

            @Override
            public String getName() {
                return "INVALID[" + var0 + "]";
            }

            @Override
            public String getPrettyName() {
                return "UNKNOWN_" + var0;
            }

            @Override
            public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
                return this.load(dataInput, nbtAccounter);
            }
        };
    }

    public static interface VariableSize<T extends Tag>
    extends TagType<T> {
        @Override
        default public void skip(DataInput var0, int var1, NbtAccounter var2) throws IOException {
            for (int var3 = 0; var3 < var1; ++var3) {
                this.skip(var0, var2);
            }
        }
    }

    public static interface StaticSize<T extends Tag>
    extends TagType<T> {
        @Override
        default public void skip(DataInput var0, NbtAccounter var1) throws IOException {
            var0.skipBytes(this.size());
        }

        @Override
        default public void skip(DataInput var0, int var1, NbtAccounter var2) throws IOException {
            var0.skipBytes(this.size() * var1);
        }

        public int size();
    }
}

