/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.security.SignatureException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;

public record SignedMessageLink(int index, UUID sender, UUID sessionId) {
    public static final Codec<SignedMessageLink> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("index").forGetter(SignedMessageLink::index), (App)UUIDUtil.CODEC.fieldOf("sender").forGetter(SignedMessageLink::sender), (App)UUIDUtil.CODEC.fieldOf("session_id").forGetter(SignedMessageLink::sessionId)).apply((Applicative)var0, SignedMessageLink::new));

    public static SignedMessageLink unsigned(UUID var0) {
        return SignedMessageLink.root(var0, Util.NIL_UUID);
    }

    public static SignedMessageLink root(UUID var0, UUID var1) {
        return new SignedMessageLink(0, var0, var1);
    }

    public void updateSignature(SignatureUpdater.Output var0) throws SignatureException {
        var0.update(UUIDUtil.uuidToByteArray(this.sender));
        var0.update(UUIDUtil.uuidToByteArray(this.sessionId));
        var0.update(Ints.toByteArray((int)this.index));
    }

    public boolean isDescendantOf(SignedMessageLink var0) {
        return this.index > var0.index() && this.sender.equals(var0.sender()) && this.sessionId.equals(var0.sessionId());
    }

    @Nullable
    public SignedMessageLink advance() {
        if (this.index == Integer.MAX_VALUE) {
            return null;
        }
        return new SignedMessageLink(this.index + 1, this.sender, this.sessionId);
    }
}

