/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public record BrainDebugPayload(BrainDump brainDump) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, BrainDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(BrainDebugPayload::write, BrainDebugPayload::new);
    public static final CustomPacketPayload.Type<BrainDebugPayload> TYPE = CustomPacketPayload.createType("debug/brain");

    private BrainDebugPayload(FriendlyByteBuf var0) {
        this(new BrainDump(var0));
    }

    private void write(FriendlyByteBuf var0) {
        this.brainDump.write(var0);
    }

    public CustomPacketPayload.Type<BrainDebugPayload> type() {
        return TYPE;
    }

    public record BrainDump(UUID uuid, int id, String name, String profession, int xp, float health, float maxHealth, Vec3 pos, String inventory, @Nullable Path path, boolean wantsGolem, int angerLevel, List<String> activities, List<String> behaviors, List<String> memories, List<String> gossips, Set<BlockPos> pois, Set<BlockPos> potentialPois) {
        public BrainDump(FriendlyByteBuf var0) {
            this(var0.readUUID(), var0.readInt(), var0.readUtf(), var0.readUtf(), var0.readInt(), var0.readFloat(), var0.readFloat(), var0.readVec3(), var0.readUtf(), var0.readNullable(Path::createFromStream), var0.readBoolean(), var0.readInt(), var0.readList(FriendlyByteBuf::readUtf), var0.readList(FriendlyByteBuf::readUtf), var0.readList(FriendlyByteBuf::readUtf), var0.readList(FriendlyByteBuf::readUtf), var0.readCollection(HashSet::new, BlockPos.STREAM_CODEC), var0.readCollection(HashSet::new, BlockPos.STREAM_CODEC));
        }

        public void write(FriendlyByteBuf var02) {
            var02.writeUUID(this.uuid);
            var02.writeInt(this.id);
            var02.writeUtf(this.name);
            var02.writeUtf(this.profession);
            var02.writeInt(this.xp);
            var02.writeFloat(this.health);
            var02.writeFloat(this.maxHealth);
            var02.writeVec3(this.pos);
            var02.writeUtf(this.inventory);
            var02.writeNullable(this.path, (var0, var1) -> var1.writeToStream((FriendlyByteBuf)((Object)var0)));
            var02.writeBoolean(this.wantsGolem);
            var02.writeInt(this.angerLevel);
            var02.writeCollection(this.activities, FriendlyByteBuf::writeUtf);
            var02.writeCollection(this.behaviors, FriendlyByteBuf::writeUtf);
            var02.writeCollection(this.memories, FriendlyByteBuf::writeUtf);
            var02.writeCollection(this.gossips, FriendlyByteBuf::writeUtf);
            var02.writeCollection(this.pois, BlockPos.STREAM_CODEC);
            var02.writeCollection(this.potentialPois, BlockPos.STREAM_CODEC);
        }

        public boolean hasPoi(BlockPos var0) {
            return this.pois.contains(var0);
        }

        public boolean hasPotentialPoi(BlockPos var0) {
            return this.potentialPois.contains(var0);
        }
    }
}

