/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record GoalDebugPayload(int entityId, BlockPos pos, List<DebugGoal> goals) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, GoalDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(GoalDebugPayload::write, GoalDebugPayload::new);
    public static final CustomPacketPayload.Type<GoalDebugPayload> TYPE = CustomPacketPayload.createType("debug/goal_selector");

    private GoalDebugPayload(FriendlyByteBuf var0) {
        this(var0.readInt(), var0.readBlockPos(), var0.readList(DebugGoal::new));
    }

    private void write(FriendlyByteBuf var02) {
        var02.writeInt(this.entityId);
        var02.writeBlockPos(this.pos);
        var02.writeCollection(this.goals, (var0, var1) -> var1.write((FriendlyByteBuf)((Object)var0)));
    }

    public CustomPacketPayload.Type<GoalDebugPayload> type() {
        return TYPE;
    }

    public record DebugGoal(int priority, boolean isRunning, String name) {
        public DebugGoal(FriendlyByteBuf var0) {
            this(var0.readInt(), var0.readBoolean(), var0.readUtf(255));
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeInt(this.priority);
            var0.writeBoolean(this.isRunning);
            var0.writeUtf(this.name);
        }
    }
}

