/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record HiveDebugPayload(HiveInfo hiveInfo) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, HiveDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(HiveDebugPayload::write, HiveDebugPayload::new);
    public static final CustomPacketPayload.Type<HiveDebugPayload> TYPE = CustomPacketPayload.createType("debug/hive");

    private HiveDebugPayload(FriendlyByteBuf var0) {
        this(new HiveInfo(var0));
    }

    private void write(FriendlyByteBuf var0) {
        this.hiveInfo.write(var0);
    }

    public CustomPacketPayload.Type<HiveDebugPayload> type() {
        return TYPE;
    }

    public record HiveInfo(BlockPos pos, String hiveType, int occupantCount, int honeyLevel, boolean sedated) {
        public HiveInfo(FriendlyByteBuf var0) {
            this(var0.readBlockPos(), var0.readUtf(), var0.readInt(), var0.readInt(), var0.readBoolean());
        }

        public void write(FriendlyByteBuf var0) {
            var0.writeBlockPos(this.pos);
            var0.writeUtf(this.hiveType);
            var0.writeInt(this.occupantCount);
            var0.writeInt(this.honeyLevel);
            var0.writeBoolean(this.sedated);
        }
    }
}

