/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;

public class ClientboundHorseScreenOpenPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundHorseScreenOpenPacket> STREAM_CODEC = Packet.codec(ClientboundHorseScreenOpenPacket::write, ClientboundHorseScreenOpenPacket::new);
    private final int containerId;
    private final int inventoryColumns;
    private final int entityId;

    public ClientboundHorseScreenOpenPacket(int var0, int var1, int var2) {
        this.containerId = var0;
        this.inventoryColumns = var1;
        this.entityId = var2;
    }

    private ClientboundHorseScreenOpenPacket(FriendlyByteBuf var0) {
        this.containerId = var0.readContainerId();
        this.inventoryColumns = var0.readVarInt();
        this.entityId = var0.readInt();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeContainerId(this.containerId);
        var0.writeVarInt(this.inventoryColumns);
        var0.writeInt(this.entityId);
    }

    @Override
    public PacketType<ClientboundHorseScreenOpenPacket> type() {
        return GamePacketTypes.CLIENTBOUND_HORSE_SCREEN_OPEN;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleHorseScreenOpen(this);
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getInventoryColumns() {
        return this.inventoryColumns;
    }

    public int getEntityId() {
        return this.entityId;
    }
}

